/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.Bucket;
import com.facebook.imagepipeline.memory.IntPair;
import java.util.HashMap;
import java.util.Map;

public class PoolStats<V> {
    public BasePool<V> mPool;
    public int mUsedBytes;
    public int mUsedCount;
    public int mFreeBytes;
    public int mFreeCount;
    Map<Integer, IntPair> mBucketStats;

    public PoolStats(BasePool<V> pool) {
        this.mPool = pool;
        this.mBucketStats = new HashMap<Integer, IntPair>();
    }

    public void setPool(BasePool<V> pool) {
        this.mPool = pool;
    }

    public void refresh() {
        this.refreshBasic();
        this.refreshBucketStats();
    }

    public void refreshBasic() {
        this.mUsedBytes = this.mPool.mUsed.mNumBytes;
        this.mUsedCount = this.mPool.mUsed.mCount;
        this.mFreeBytes = this.mPool.mFree.mNumBytes;
        this.mFreeCount = this.mPool.mFree.mCount;
    }

    public void refreshBucketStats() {
        this.mBucketStats.clear();
        for (int i = 0; i < this.mPool.mBuckets.size(); ++i) {
            int bucketedSize = this.mPool.mBuckets.keyAt(i);
            Bucket bucket = (Bucket)this.mPool.mBuckets.valueAt(i);
            this.mBucketStats.put(bucketedSize, new IntPair(bucket.getInUseCount(), bucket.getFreeListSize()));
        }
    }

    Map<Integer, IntPair> getBucketStats() {
        return this.mBucketStats;
    }
}

