/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.common.internal.Preconditions;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0087\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0000H\u0086\u0002J\b\u0010\f\u001a\u00020\bH\u0016J\u0013\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/imagepipeline/common/BytesRange;", "", "from", "", "to", "<init>", "(II)V", "toHttpRangeHeaderValue", "", "contains", "", "compare", "toString", "equals", "other", "hashCode", "component1", "component2", "copy", "Companion", "imagepipeline-base_release"})
@Immutable
public final class BytesRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int from;
    @JvmField
    public final int to;
    public static final int TO_END_OF_CONTENT = Integer.MAX_VALUE;
    @NotNull
    private static final Lazy<Pattern> headerParsingRegEx$delegate = LazyKt.lazy(BytesRange::headerParsingRegEx_delegate$lambda$0);

    public BytesRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    @NotNull
    public final String toHttpRangeHeaderValue() {
        Locale locale = null;
        String string = "bytes=%s-%s";
        Object[] objectArray = new Object[]{BytesRange.Companion.valueOrEmpty(this.from), BytesRange.Companion.valueOrEmpty(this.to)};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final boolean contains(@Nullable BytesRange compare) {
        return compare == null ? false : this.from <= compare.from && compare.to <= this.to;
    }

    @NotNull
    public String toString() {
        Locale locale = null;
        String string = "%s-%s";
        Object[] objectArray = new Object[]{BytesRange.Companion.valueOrEmpty(this.from), BytesRange.Companion.valueOrEmpty(this.to)};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.facebook.imagepipeline.common.BytesRange");
        BytesRange otherRange = (BytesRange)other;
        return this.from == otherRange.from && this.to == otherRange.to;
    }

    public int hashCode() {
        int result = this.from;
        result = 31 * result + this.to;
        return result;
    }

    public final int component1() {
        return this.from;
    }

    public final int component2() {
        return this.to;
    }

    @NotNull
    public final BytesRange copy(int from, int to) {
        return new BytesRange(from, to);
    }

    public static /* synthetic */ BytesRange copy$default(BytesRange bytesRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = bytesRange.from;
        }
        if ((n3 & 2) != 0) {
            n2 = bytesRange.to;
        }
        return bytesRange.copy(n, n2);
    }

    private static final Pattern headerParsingRegEx_delegate$lambda$0() {
        return Pattern.compile("[-/ ]");
    }

    @JvmStatic
    @NotNull
    public static final BytesRange from(int from) {
        return Companion.from(from);
    }

    @JvmStatic
    @NotNull
    public static final BytesRange toMax(int to) {
        return Companion.toMax(to);
    }

    @JvmStatic
    @Nullable
    public static final BytesRange fromContentRangeHeader(@Nullable String header) throws IllegalArgumentException {
        return Companion.fromContentRangeHeader(header);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/facebook/imagepipeline/common/BytesRange$Companion;", "", "<init>", "()V", "TO_END_OF_CONTENT", "", "headerParsingRegEx", "Ljava/util/regex/Pattern;", "getHeaderParsingRegEx", "()Ljava/util/regex/Pattern;", "headerParsingRegEx$delegate", "Lkotlin/Lazy;", "valueOrEmpty", "", "n", "from", "Lcom/facebook/imagepipeline/common/BytesRange;", "toMax", "to", "fromContentRangeHeader", "header", "imagepipeline-base_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Pattern getHeaderParsingRegEx() {
            Lazy lazy = headerParsingRegEx$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Pattern)object;
        }

        private final String valueOrEmpty(int n) {
            return n == Integer.MAX_VALUE ? "" : String.valueOf(n);
        }

        @JvmStatic
        @NotNull
        public final BytesRange from(int from) {
            Preconditions.checkArgument((Boolean)(from >= 0 ? 1 : 0));
            return new BytesRange(from, Integer.MAX_VALUE);
        }

        @JvmStatic
        @NotNull
        public final BytesRange toMax(int to) {
            Preconditions.checkArgument((Boolean)(to > 0 ? 1 : 0));
            return new BytesRange(0, to);
        }

        @JvmStatic
        @Nullable
        public final BytesRange fromContentRangeHeader(@Nullable String header) throws IllegalArgumentException {
            if (header == null) {
                return null;
            }
            try {
                String[] headerParts = this.getHeaderParsingRegEx().split(header);
                Preconditions.checkArgument((Boolean)(headerParts.length == 4 ? 1 : 0));
                Preconditions.checkArgument((Boolean)Intrinsics.areEqual((Object)headerParts[0], (Object)"bytes"));
                String string = headerParts[1];
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                int from = Integer.parseInt(string);
                String string2 = headerParts[2];
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                int to = Integer.parseInt(string2);
                String string3 = headerParts[3];
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                int length = Integer.parseInt(string3);
                Preconditions.checkArgument((Boolean)(to > from ? 1 : 0));
                Preconditions.checkArgument((Boolean)(length > to ? 1 : 0));
                if (to < length - 1) {
                    return new BytesRange(from, to);
                }
                return new BytesRange(from, Integer.MAX_VALUE);
            }
            catch (IllegalArgumentException x) {
                Locale locale = null;
                String string = "Invalid Content-Range header value: \"%s\"";
                Object[] objectArray = new Object[]{header};
                String string4 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                throw new IllegalArgumentException(string4, x);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

