/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.internal.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.imagepipeline.cache.ValueDescriptor;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class AbstractAdaptiveCountingMemoryCache<K, V>
implements CountingMemoryCache<K, V> {
    private static final String TAG = "AbstractArcCountingMemoryCache";
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, CountingMemoryCache.Entry<K, V>> mLeastFrequentlyUsedExclusiveEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, CountingMemoryCache.Entry<K, V>> mMostFrequentlyUsedExclusiveEntries;
    @GuardedBy(value="this")
    @VisibleForTesting
    final CountingLruMap<K, CountingMemoryCache.Entry<K, V>> mCachedEntries;
    private final ValueDescriptor<V> mValueDescriptor;
    private final MemoryCache.CacheTrimStrategy mCacheTrimStrategy;
    private final Supplier<MemoryCacheParams> mMemoryCacheParamsSupplier;
    @GuardedBy(value="this")
    @VisibleForTesting
    int mLFUFractionPromil;
    static final int DEFAULT_LFU_FRACTION_PROMIL = 500;
    static final int TOTAL_PROMIL = 1000;
    @VisibleForTesting
    static final int MIN_FRACTION_PROMIL = 100;
    static final int MAX_FRACTION_PROMIL = 900;
    private final int mFrequentlyUsedThreshold;
    @GuardedBy(value="this")
    @VisibleForTesting
    final int mAdaptiveRatePromil;
    static final int DEFAULT_ADAPTIVE_RATE_PROMIL = 10;
    @GuardedBy(value="this")
    @VisibleForTesting
    final IntMapArrayList<K> mLeastFrequentlyUsedKeysGhostList;
    @GuardedBy(value="this")
    @VisibleForTesting
    final ArrayList<K> mMostFrequentlyUsedKeysGhostList;
    @GuardedBy(value="this")
    @VisibleForTesting
    final int mGhostListMaxSize;
    @GuardedBy(value="this")
    protected MemoryCacheParams mMemoryCacheParams;
    @GuardedBy(value="this")
    private long mLastCacheParamsCheck;

    public AbstractAdaptiveCountingMemoryCache(Supplier<MemoryCacheParams> memoryCacheParamsSupplier, MemoryCache.CacheTrimStrategy cacheTrimStrategy, ValueDescriptor<V> valueDescriptor, int adaptiveRatePromil, int frequentlyUsedThreshold, int ghostListMaxSize, int lfuFractionPromil) {
        FLog.d((String)TAG, (String)"Create Adaptive Replacement Cache");
        this.mValueDescriptor = valueDescriptor;
        this.mLeastFrequentlyUsedExclusiveEntries = new CountingLruMap<K, CountingMemoryCache.Entry<K, CountingMemoryCache.Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mMostFrequentlyUsedExclusiveEntries = new CountingLruMap<K, CountingMemoryCache.Entry<K, CountingMemoryCache.Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCachedEntries = new CountingLruMap<K, CountingMemoryCache.Entry<K, CountingMemoryCache.Entry<K, V>>>(this.wrapValueDescriptor(valueDescriptor));
        this.mCacheTrimStrategy = cacheTrimStrategy;
        this.mMemoryCacheParamsSupplier = memoryCacheParamsSupplier;
        this.mMemoryCacheParams = (MemoryCacheParams)Preconditions.checkNotNull((Object)((MemoryCacheParams)this.mMemoryCacheParamsSupplier.get()), (Object)"mMemoryCacheParamsSupplier returned null");
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mFrequentlyUsedThreshold = frequentlyUsedThreshold;
        this.mGhostListMaxSize = ghostListMaxSize;
        this.mLeastFrequentlyUsedKeysGhostList = new IntMapArrayList(this.mGhostListMaxSize);
        this.mMostFrequentlyUsedKeysGhostList = new ArrayList(this.mGhostListMaxSize);
        if (lfuFractionPromil < 100 || lfuFractionPromil > 900) {
            this.mLFUFractionPromil = 500;
            this.logIllegalLfuFraction();
        } else {
            this.mLFUFractionPromil = lfuFractionPromil;
        }
        if (adaptiveRatePromil <= 0 || adaptiveRatePromil >= 1000) {
            this.mAdaptiveRatePromil = 10;
            this.logIllegalAdaptiveRate();
        } else {
            this.mAdaptiveRatePromil = adaptiveRatePromil;
        }
    }

    private ValueDescriptor<CountingMemoryCache.Entry<K, V>> wrapValueDescriptor(final ValueDescriptor<V> evictableValueDescriptor) {
        return new ValueDescriptor<CountingMemoryCache.Entry<K, V>>(){

            @Override
            public int getSizeInBytes(CountingMemoryCache.Entry<K, V> entry) {
                return evictableValueDescriptor.getSizeInBytes(entry.valueRef.get());
            }
        };
    }

    @Override
    @Nullable
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef) {
        return this.cache(key, valueRef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> cache(K key, CloseableReference<V> valueRef, @Nullable CountingMemoryCache.EntryStateObserver<K> observer) {
        CountingMemoryCache.Entry<K, V> oldMFUExclusive;
        CountingMemoryCache.Entry<K, V> oldLFUExclusive;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(valueRef);
        this.maybeUpdateCacheParams();
        CloseableReference<V> oldRefToClose = null;
        CloseableReference<V> clientRef = null;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            oldLFUExclusive = this.mLeastFrequentlyUsedExclusiveEntries.remove(key);
            oldMFUExclusive = this.mMostFrequentlyUsedExclusiveEntries.remove(key);
            boolean notPresentInBoth = oldLFUExclusive == null || oldMFUExclusive == null;
            Preconditions.checkState((boolean)notPresentInBoth);
            CountingMemoryCache.Entry<K, V> oldEntry = this.mCachedEntries.remove(key);
            if (oldEntry != null) {
                this.makeOrphan(oldEntry);
                oldRefToClose = this.referenceToClose(oldEntry);
            }
            if (this.canCacheNewValue(valueRef.get())) {
                CountingMemoryCache.Entry<K, V> newEntry = CountingMemoryCache.Entry.of(key, valueRef, observer);
                Integer storedAccessCount = this.mLeastFrequentlyUsedKeysGhostList.getValue(key);
                newEntry.accessCount = storedAccessCount != null ? storedAccessCount : 0;
                this.mCachedEntries.put(key, newEntry);
                clientRef = this.newClientReference(newEntry);
            }
        }
        CloseableReference.closeSafely(oldRefToClose);
        this.maybeNotifyExclusiveEntryRemoval(oldLFUExclusive, oldMFUExclusive);
        this.maybeEvictEntries();
        return clientRef;
    }

    private synchronized boolean canCacheNewValue(V value) {
        int newValueSize = this.mValueDescriptor.getSizeInBytes(value);
        return newValueSize <= this.mMemoryCacheParams.maxCacheEntrySize && this.getInUseCount() <= this.mMemoryCacheParams.maxCacheEntries - 1 && this.getInUseSizeInBytes() <= this.mMemoryCacheParams.maxCacheSize - newValueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> get(K key) {
        CountingMemoryCache.Entry<K, V> oldMFUExclusive;
        CountingMemoryCache.Entry<K, V> oldLFUExclusive;
        Preconditions.checkNotNull(key);
        CloseableReference<V> clientRef = null;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            oldLFUExclusive = this.mLeastFrequentlyUsedExclusiveEntries.remove(key);
            oldMFUExclusive = this.mMostFrequentlyUsedExclusiveEntries.remove(key);
            CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.get(key);
            if (entry != null) {
                clientRef = this.newClientReference(entry);
            } else {
                this.maybeUpdateCacheFraction(key);
            }
        }
        this.maybeNotifyExclusiveEntryRemoval(oldLFUExclusive, oldMFUExclusive);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return clientRef;
    }

    @Override
    @Nullable
    public V inspect(K key) {
        CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.get(key);
        if (entry == null) {
            return null;
        }
        return (V)entry.valueRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void probe(K key) {
        Preconditions.checkNotNull(key);
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            CountingMemoryCache.Entry<K, V> oldExclusive = this.mLeastFrequentlyUsedExclusiveEntries.remove(key);
            if (oldExclusive == null) {
                oldExclusive = this.mMostFrequentlyUsedExclusiveEntries.remove(key);
            }
            if (oldExclusive != null) {
                this.increaseAccessCount(oldExclusive);
                this.maybeAddToExclusives(oldExclusive);
            }
        }
    }

    private synchronized void maybeUpdateCacheFraction(K key) {
        if (this.mLeastFrequentlyUsedKeysGhostList.contains(key)) {
            if (this.mLFUFractionPromil + this.mAdaptiveRatePromil <= 900) {
                this.mLFUFractionPromil += this.mAdaptiveRatePromil;
            }
            this.mLeastFrequentlyUsedKeysGhostList.increaseValueIfExists(key);
        } else if (this.mLFUFractionPromil - this.mAdaptiveRatePromil >= 100 && this.mMostFrequentlyUsedKeysGhostList.contains(key)) {
            this.mLFUFractionPromil -= this.mAdaptiveRatePromil;
        }
    }

    private synchronized CloseableReference<V> newClientReference(final CountingMemoryCache.Entry<K, V> entry) {
        this.increaseCounters(entry);
        return CloseableReference.of((Object)entry.valueRef.get(), (ResourceReleaser)new ResourceReleaser<V>(){

            public void release(V unused) {
                AbstractAdaptiveCountingMemoryCache.this.releaseClientReference(entry);
            }
        });
    }

    private synchronized void addElementToGhostList(K key, int accessCount, ArrayListType evictionType) {
        if (evictionType == ArrayListType.LFU) {
            this.mLeastFrequentlyUsedKeysGhostList.addPair(key, accessCount);
        } else {
            if (this.mMostFrequentlyUsedKeysGhostList.size() == this.mGhostListMaxSize) {
                this.mMostFrequentlyUsedKeysGhostList.remove(0);
            }
            this.mMostFrequentlyUsedKeysGhostList.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseClientReference(CountingMemoryCache.Entry<K, V> entry) {
        CloseableReference<V> oldRefToClose;
        boolean isExclusiveAdded;
        Preconditions.checkNotNull(entry);
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            this.decreaseClientCount(entry);
            isExclusiveAdded = this.maybeAddToExclusives(entry);
            oldRefToClose = this.referenceToClose(entry);
        }
        CloseableReference.closeSafely(oldRefToClose);
        AbstractAdaptiveCountingMemoryCache.maybeNotifyExclusiveEntryInsertion(isExclusiveAdded ? entry : null);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized boolean maybeAddToExclusives(CountingMemoryCache.Entry<K, V> entry) {
        if (!entry.isOrphan && entry.clientCount == 0) {
            if (entry.accessCount > this.mFrequentlyUsedThreshold) {
                this.mMostFrequentlyUsedExclusiveEntries.put(entry.key, entry);
            } else {
                this.mLeastFrequentlyUsedExclusiveEntries.put(entry.key, entry);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CloseableReference<V> reuse(K key) {
        Preconditions.checkNotNull(key);
        CloseableReference clientRef = null;
        boolean removed = false;
        CountingMemoryCache.Entry<K, V> oldExclusive = null;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            oldExclusive = this.mLeastFrequentlyUsedExclusiveEntries.remove(key);
            if (oldExclusive == null) {
                oldExclusive = this.mMostFrequentlyUsedExclusiveEntries.remove(key);
            }
            if (oldExclusive != null) {
                CountingMemoryCache.Entry<K, V> entry = this.mCachedEntries.remove(key);
                Preconditions.checkNotNull(entry);
                Preconditions.checkState((entry.clientCount == 0 ? 1 : 0) != 0);
                clientRef = entry.valueRef;
                removed = true;
            }
        }
        if (removed) {
            AbstractAdaptiveCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(oldExclusive);
        }
        return clientRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(Predicate<K> predicate) {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldMFUExclusives;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldLFUExclusives;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            oldLFUExclusives = this.mLeastFrequentlyUsedExclusiveEntries.removeAll(predicate);
            oldMFUExclusives = this.mMostFrequentlyUsedExclusiveEntries.removeAll(predicate);
            oldEntries = this.mCachedEntries.removeAll(predicate);
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntriesRemoval(oldLFUExclusives, oldMFUExclusives);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
        return oldEntries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldMFUExclusives;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldLFUExclusives;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            oldLFUExclusives = this.mLeastFrequentlyUsedExclusiveEntries.clear();
            oldMFUExclusives = this.mMostFrequentlyUsedExclusiveEntries.clear();
            oldEntries = this.mCachedEntries.clear();
            this.makeOrphans(oldEntries);
        }
        this.maybeClose(oldEntries);
        this.maybeNotifyExclusiveEntriesRemoval(oldLFUExclusives, oldMFUExclusives);
        this.maybeUpdateCacheParams();
    }

    @Override
    public synchronized boolean contains(Predicate<K> predicate) {
        return !this.mCachedEntries.getMatchingEntries(predicate).isEmpty();
    }

    @Override
    public synchronized boolean contains(K key) {
        return this.mCachedEntries.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trim(MemoryTrimType trimType) {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldMFUEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldLFUEntries;
        double trimRatio = this.mCacheTrimStrategy.getTrimRatio(trimType);
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            int targetCacheSize = (int)((double)this.mCachedEntries.getSizeInBytes() * (1.0 - trimRatio));
            int targetEvictionQueueSize = Math.max(0, targetCacheSize - this.getInUseSizeInBytes());
            int MFUTargetEvictionQueueSize = this.mMostFrequentlyUsedExclusiveEntries.getSizeInBytes();
            int LFUTargetEvictionQueueSize = Math.max(0, targetEvictionQueueSize - MFUTargetEvictionQueueSize);
            if (targetEvictionQueueSize <= MFUTargetEvictionQueueSize) {
                MFUTargetEvictionQueueSize = targetEvictionQueueSize;
                LFUTargetEvictionQueueSize = 0;
            }
            oldLFUEntries = this.trimExclusivelyOwnedEntries(Integer.MAX_VALUE, LFUTargetEvictionQueueSize, this.mLeastFrequentlyUsedExclusiveEntries, ArrayListType.LFU);
            oldMFUEntries = this.trimExclusivelyOwnedEntries(Integer.MAX_VALUE, MFUTargetEvictionQueueSize, this.mMostFrequentlyUsedExclusiveEntries, ArrayListType.MFU);
            this.makeOrphans(oldLFUEntries, oldMFUEntries);
        }
        this.maybeClose(oldLFUEntries, oldMFUEntries);
        this.maybeNotifyExclusiveEntriesRemoval(oldLFUEntries, oldMFUEntries);
        this.maybeUpdateCacheParams();
        this.maybeEvictEntries();
    }

    private synchronized void maybeUpdateCacheParams() {
        if (this.mLastCacheParamsCheck + this.mMemoryCacheParams.paramsCheckIntervalMs > SystemClock.uptimeMillis()) {
            return;
        }
        this.mLastCacheParamsCheck = SystemClock.uptimeMillis();
        this.mMemoryCacheParams = (MemoryCacheParams)Preconditions.checkNotNull((Object)((MemoryCacheParams)this.mMemoryCacheParamsSupplier.get()), (Object)"mMemoryCacheParamsSupplier returned null");
    }

    @Override
    public MemoryCacheParams getMemoryCacheParams() {
        return this.mMemoryCacheParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeEvictEntries() {
        ArrayList<CountingMemoryCache.Entry<K, V>> oldMFUEntries;
        ArrayList<CountingMemoryCache.Entry<K, V>> oldLFUEntries;
        AbstractAdaptiveCountingMemoryCache abstractAdaptiveCountingMemoryCache = this;
        synchronized (abstractAdaptiveCountingMemoryCache) {
            int maxCount = Math.min(this.mMemoryCacheParams.maxEvictionQueueEntries, this.mMemoryCacheParams.maxCacheEntries - this.getInUseCount());
            int maxSize = Math.min(this.mMemoryCacheParams.maxEvictionQueueSize, this.mMemoryCacheParams.maxCacheSize - this.getInUseSizeInBytes());
            int LFUMaxCount = (int)((long)maxCount * (long)this.mLFUFractionPromil / 1000L);
            int LFUMaxSize = (int)((long)maxSize * (long)this.mLFUFractionPromil / 1000L);
            oldLFUEntries = this.trimExclusivelyOwnedEntries(LFUMaxCount, LFUMaxSize, this.mLeastFrequentlyUsedExclusiveEntries, ArrayListType.LFU);
            oldMFUEntries = this.trimExclusivelyOwnedEntries(maxCount - LFUMaxCount, maxSize - LFUMaxSize, this.mMostFrequentlyUsedExclusiveEntries, ArrayListType.MFU);
            this.makeOrphans(oldLFUEntries, oldMFUEntries);
        }
        this.maybeClose(oldLFUEntries, oldMFUEntries);
        this.maybeNotifyExclusiveEntriesRemoval(oldLFUEntries, oldMFUEntries);
    }

    @Nullable
    private synchronized ArrayList<CountingMemoryCache.Entry<K, V>> trimExclusivelyOwnedEntries(int count, int size, CountingLruMap<K, CountingMemoryCache.Entry<K, V>> ExclusixeEntries, ArrayListType evictionType) {
        count = Math.max(count, 0);
        size = Math.max(size, 0);
        if (ExclusixeEntries.getCount() <= count && ExclusixeEntries.getSizeInBytes() <= size) {
            return null;
        }
        ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries = new ArrayList<CountingMemoryCache.Entry<K, V>>();
        while (ExclusixeEntries.getCount() > count || ExclusixeEntries.getSizeInBytes() > size) {
            Object key = Preconditions.checkNotNull(ExclusixeEntries.getFirstKey());
            this.addElementToGhostList(key, ((CountingMemoryCache.Entry)Preconditions.checkNotNull(ExclusixeEntries.get(key))).accessCount, evictionType);
            ExclusixeEntries.remove(key);
            oldEntries.add(this.mCachedEntries.remove(key));
        }
        return oldEntries;
    }

    private void maybeClose(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries1, @Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries2) {
        this.maybeClose(oldEntries1);
        this.maybeClose(oldEntries2);
    }

    private void maybeClose(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (CountingMemoryCache.Entry<K, V> oldEntry : oldEntries) {
                CloseableReference.closeSafely(this.referenceToClose(oldEntry));
            }
        }
    }

    private void maybeNotifyExclusiveEntriesRemoval(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> entries1, @Nullable ArrayList<CountingMemoryCache.Entry<K, V>> entries2) {
        this.maybeNotifyExclusiveEntryRemoval(entries1);
        this.maybeNotifyExclusiveEntryRemoval(entries2);
    }

    private void maybeNotifyExclusiveEntryRemoval(@Nullable CountingMemoryCache.Entry<K, V> entry1, @Nullable CountingMemoryCache.Entry<K, V> entry2) {
        AbstractAdaptiveCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(entry1);
        AbstractAdaptiveCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(entry2);
    }

    private void maybeNotifyExclusiveEntryRemoval(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> entries) {
        if (entries != null) {
            for (CountingMemoryCache.Entry<K, V> entry : entries) {
                AbstractAdaptiveCountingMemoryCache.maybeNotifyExclusiveEntryRemoval(entry);
            }
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryRemoval(@Nullable CountingMemoryCache.Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, false);
        }
    }

    private static <K, V> void maybeNotifyExclusiveEntryInsertion(@Nullable CountingMemoryCache.Entry<K, V> entry) {
        if (entry != null && entry.observer != null) {
            entry.observer.onExclusivityChanged(entry.key, true);
        }
    }

    private synchronized void makeOrphans(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries1, @Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries2) {
        this.makeOrphans(oldEntries1);
        this.makeOrphans(oldEntries2);
    }

    private synchronized void makeOrphans(@Nullable ArrayList<CountingMemoryCache.Entry<K, V>> oldEntries) {
        if (oldEntries != null) {
            for (CountingMemoryCache.Entry<K, V> oldEntry : oldEntries) {
                this.makeOrphan(oldEntry);
            }
        }
    }

    private synchronized void makeOrphan(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        entry.isOrphan = true;
    }

    private synchronized void increaseCounters(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        ++entry.clientCount;
        this.increaseAccessCount(entry);
    }

    private synchronized void increaseAccessCount(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((!entry.isOrphan ? 1 : 0) != 0);
        ++entry.accessCount;
    }

    private synchronized void decreaseClientCount(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        Preconditions.checkState((entry.clientCount > 0 ? 1 : 0) != 0);
        --entry.clientCount;
    }

    @Nullable
    private synchronized CloseableReference<V> referenceToClose(CountingMemoryCache.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return entry.isOrphan && entry.clientCount == 0 ? entry.valueRef : null;
    }

    @Override
    public synchronized int getCount() {
        return this.mCachedEntries.getCount();
    }

    @Override
    public synchronized int getSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes();
    }

    public synchronized int getInUseCount() {
        return this.mCachedEntries.getCount() - this.mLeastFrequentlyUsedExclusiveEntries.getCount() - this.mMostFrequentlyUsedExclusiveEntries.getCount();
    }

    @Override
    public synchronized int getInUseSizeInBytes() {
        return this.mCachedEntries.getSizeInBytes() - this.mLeastFrequentlyUsedExclusiveEntries.getSizeInBytes() - this.mMostFrequentlyUsedExclusiveEntries.getSizeInBytes();
    }

    @Override
    public synchronized int getEvictionQueueCount() {
        return this.mLeastFrequentlyUsedExclusiveEntries.getCount() + this.mMostFrequentlyUsedExclusiveEntries.getCount();
    }

    @Override
    public synchronized int getEvictionQueueSizeInBytes() {
        return this.mLeastFrequentlyUsedExclusiveEntries.getSizeInBytes() + this.mMostFrequentlyUsedExclusiveEntries.getSizeInBytes();
    }

    public String reportData() {
        return Objects.toStringHelper((String)"CountingMemoryCache").add("cached_entries_count:", this.mCachedEntries.getCount()).add("exclusive_entries_count", this.getEvictionQueueCount()).toString();
    }

    protected abstract void logIllegalLfuFraction();

    protected abstract void logIllegalAdaptiveRate();

    @Override
    public CountingLruMap getCachedEntries() {
        return this.mCachedEntries;
    }

    @Override
    public Map<Bitmap, Object> getOtherEntries() {
        return Collections.emptyMap();
    }

    @VisibleForTesting
    class IntMapArrayList<E> {
        private final ArrayList<E> mFirstList;
        private final ArrayList<Integer> mSecondList;
        private final int mMaxCapacity;

        public IntMapArrayList(int maxCapacity) {
            this.mFirstList = new ArrayList(maxCapacity);
            this.mSecondList = new ArrayList(maxCapacity);
            this.mMaxCapacity = maxCapacity;
        }

        public void addPair(E element, Integer second) {
            if (this.mFirstList.size() == this.mMaxCapacity) {
                this.mFirstList.remove(0);
                this.mSecondList.remove(0);
            }
            this.mFirstList.add(element);
            this.mSecondList.add(second);
        }

        public void increaseValueIfExists(E element) {
            int index = this.mFirstList.indexOf(element);
            if (index < 0) {
                return;
            }
            Integer newInt = this.mSecondList.get(index) + 1;
            if (index == this.mMaxCapacity - 1) {
                this.mSecondList.set(this.mMaxCapacity - 1, newInt);
                return;
            }
            this.mFirstList.remove(index);
            this.mSecondList.remove(index);
            this.mFirstList.add(element);
            this.mSecondList.add(newInt);
        }

        @Nullable
        public Integer getValue(E element) {
            int index = this.mFirstList.indexOf(element);
            if (index < 0) {
                return null;
            }
            return this.mSecondList.get(index);
        }

        public boolean contains(E element) {
            return this.mFirstList.contains(element);
        }

        public int size() {
            return this.mFirstList.size();
        }
    }

    static enum ArrayListType {
        LFU,
        MFU;

    }
}

