/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.common;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class SimpleCacheKey
implements CacheKey {
    final String mKey;
    final boolean mIsResourceIdForDebugging;

    public SimpleCacheKey(String key) {
        this(key, false);
    }

    public SimpleCacheKey(String key, boolean isResourceIdForDebugging) {
        this.mKey = (String)Preconditions.checkNotNull((Object)key);
        this.mIsResourceIdForDebugging = isResourceIdForDebugging;
    }

    @Override
    public String toString() {
        return this.mKey;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleCacheKey) {
            SimpleCacheKey otherKey = (SimpleCacheKey)o;
            return this.mKey.equals(otherKey.mKey);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mKey.hashCode();
    }

    @Override
    public boolean containsUri(Uri uri) {
        return this.mKey.contains(uri.toString());
    }

    @Override
    public String getUriString() {
        return this.mKey;
    }

    @Override
    public boolean isResourceIdForDebugging() {
        return this.mIsResourceIdForDebugging;
    }
}

