/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.common;

import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.common.util.SecureHashUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/facebook/cache/common/CacheKeyUtil;", "", "<init>", "()V", "getResourceIds", "", "", "key", "Lcom/facebook/cache/common/CacheKey;", "getFirstResourceId", "secureHashKey", "imagepipeline-base_release"})
public final class CacheKeyUtil {
    @NotNull
    public static final CacheKeyUtil INSTANCE = new CacheKeyUtil();

    private CacheKeyUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> getResourceIds(@NotNull CacheKey key) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            List ids = null;
            if (key instanceof MultiCacheKey) {
                List<CacheKey> list = ((MultiCacheKey)key).getCacheKeys();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCacheKeys(...)");
                List<CacheKey> keys = list;
                ids = new ArrayList(keys.size());
                int n = ((Collection)keys).size();
                for (int i = 0; i < n; ++i) {
                    ArrayList arrayList = (ArrayList)ids;
                    CacheKey cacheKey = keys.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"get(...)");
                    arrayList.add(INSTANCE.secureHashKey(cacheKey));
                }
            } else {
                ids = new ArrayList(1);
                ((ArrayList)ids).add(key.isResourceIdForDebugging() ? key.getUriString() : INSTANCE.secureHashKey(key));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return var1_1;
    }

    @JvmStatic
    @NotNull
    public static final String getFirstResourceId(@NotNull CacheKey key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String string2;
            if (key instanceof MultiCacheKey) {
                List<CacheKey> list = ((MultiCacheKey)key).getCacheKeys();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCacheKeys(...)");
                List<CacheKey> keys = list;
                CacheKey cacheKey = keys.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)cacheKey, (String)"get(...)");
                string2 = INSTANCE.secureHashKey(cacheKey);
            } else {
                string2 = INSTANCE.secureHashKey(key);
            }
            string = string2;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    private final String secureHashKey(CacheKey key) throws UnsupportedEncodingException {
        String string = key.getUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUriString(...)");
        String string2 = string;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string3 = SecureHashUtil.makeSHA1HashBase64((byte[])byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"makeSHA1HashBase64(...)");
        return string3;
    }
}

