/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.imageformat.ImageFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/imageformat/DefaultImageFormats;", "", "()V", "BMP", "Lcom/facebook/imageformat/ImageFormat;", "DNG", "GIF", "HEIF", "ICO", "JPEG", "PNG", "WEBP_ANIMATED", "WEBP_EXTENDED", "WEBP_EXTENDED_WITH_ALPHA", "WEBP_LOSSLESS", "WEBP_SIMPLE", "defaultFormats", "", "isStaticWebpFormat", "", "imageFormat", "isWebpFormat", "imagepipeline-base_release"})
public final class DefaultImageFormats {
    @NotNull
    public static final DefaultImageFormats INSTANCE = new DefaultImageFormats();
    @JvmField
    @NotNull
    public static final ImageFormat JPEG = new ImageFormat("JPEG", "jpeg");
    @JvmField
    @NotNull
    public static final ImageFormat PNG = new ImageFormat("PNG", "png");
    @JvmField
    @NotNull
    public static final ImageFormat GIF = new ImageFormat("GIF", "gif");
    @JvmField
    @NotNull
    public static final ImageFormat BMP = new ImageFormat("BMP", "bmp");
    @JvmField
    @NotNull
    public static final ImageFormat ICO = new ImageFormat("ICO", "ico");
    @JvmField
    @NotNull
    public static final ImageFormat WEBP_SIMPLE = new ImageFormat("WEBP_SIMPLE", "webp");
    @JvmField
    @NotNull
    public static final ImageFormat WEBP_LOSSLESS = new ImageFormat("WEBP_LOSSLESS", "webp");
    @JvmField
    @NotNull
    public static final ImageFormat WEBP_EXTENDED = new ImageFormat("WEBP_EXTENDED", "webp");
    @JvmField
    @NotNull
    public static final ImageFormat WEBP_EXTENDED_WITH_ALPHA = new ImageFormat("WEBP_EXTENDED_WITH_ALPHA", "webp");
    @JvmField
    @NotNull
    public static final ImageFormat WEBP_ANIMATED = new ImageFormat("WEBP_ANIMATED", "webp");
    @JvmField
    @NotNull
    public static final ImageFormat HEIF = new ImageFormat("HEIF", "heif");
    @JvmField
    @NotNull
    public static final ImageFormat DNG = new ImageFormat("DNG", "dng");
    @JvmField
    @NotNull
    public static final List<ImageFormat> defaultFormats;

    private DefaultImageFormats() {
    }

    @JvmStatic
    public static final boolean isWebpFormat(@NotNull ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        return DefaultImageFormats.isStaticWebpFormat(imageFormat) || imageFormat == WEBP_ANIMATED;
    }

    @JvmStatic
    public static final boolean isStaticWebpFormat(@NotNull ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        return imageFormat == WEBP_SIMPLE || imageFormat == WEBP_LOSSLESS || imageFormat == WEBP_EXTENDED || imageFormat == WEBP_EXTENDED_WITH_ALPHA;
    }

    static {
        Object[] objectArray = new ImageFormat[]{JPEG, PNG, GIF, BMP, ICO, WEBP_SIMPLE, WEBP_LOSSLESS, WEBP_EXTENDED, WEBP_EXTENDED_WITH_ALPHA, WEBP_ANIMATED, HEIF};
        defaultFormats = CollectionsKt.listOf((Object[])objectArray);
    }
}

