/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import android.graphics.Matrix;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableList;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J*\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0004H\u0007J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0004H\u0007J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0007R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/facebook/imagepipeline/transcoder/JpegTranscoderUtils;", "", "()V", "DEFAULT_JPEG_QUALITY", "", "getDEFAULT_JPEG_QUALITY$annotations", "FULL_ROUND", "INVERTED_EXIF_ORIENTATIONS", "Lcom/facebook/common/internal/ImmutableList;", "kotlin.jvm.PlatformType", "MAX_QUALITY", "MAX_SCALE_NUMERATOR", "MIN_QUALITY", "MIN_SCALE_NUMERATOR", "SCALE_DENOMINATOR", "calculateDownsampleNumerator", "downsampleRatio", "determineResizeRatio", "", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "width", "height", "extractOrientationFromMetadata", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "getForceRotatedInvertedExifOrientation", "rotationOptions", "Lcom/facebook/imagepipeline/common/RotationOptions;", "getRotationAngle", "getSoftwareNumerator", "resizingEnabled", "", "getTransformationMatrix", "Landroid/graphics/Matrix;", "getTransformationMatrixFromInvertedExif", "orientation", "isExifOrientationAllowed", "exifOrientation", "isRotationAngleAllowed", "degrees", "roundNumerator", "maxRatio", "roundUpFraction", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nJpegTranscoderUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpegTranscoderUtils.kt\ncom/facebook/imagepipeline/transcoder/JpegTranscoderUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class JpegTranscoderUtils {
    @NotNull
    public static final JpegTranscoderUtils INSTANCE = new JpegTranscoderUtils();
    private static final int FULL_ROUND = 360;
    public static final int MIN_QUALITY = 0;
    public static final int MAX_QUALITY = 100;
    public static final int MIN_SCALE_NUMERATOR = 1;
    public static final int MAX_SCALE_NUMERATOR = 16;
    public static final int SCALE_DENOMINATOR = 8;
    @JvmField
    @NotNull
    public static final ImmutableList<Integer> INVERTED_EXIF_ORIENTATIONS;
    public static final int DEFAULT_JPEG_QUALITY = 85;

    private JpegTranscoderUtils() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getDEFAULT_JPEG_QUALITY$annotations() {
    }

    @JvmStatic
    public static final boolean isRotationAngleAllowed(int degrees) {
        return degrees >= 0 && degrees <= 270 && degrees % 90 == 0;
    }

    @JvmStatic
    public static final boolean isExifOrientationAllowed(int exifOrientation) {
        boolean bl;
        switch (exifOrientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    public static final int getSoftwareNumerator(@NotNull RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @NotNull EncodedImage encodedImage, boolean resizingEnabled) {
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        if (!resizingEnabled) {
            return 8;
        }
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = JpegTranscoderUtils.getRotationAngle(rotationOptions, encodedImage);
        int exifOrientation = 0;
        if (INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation())) {
            exifOrientation = JpegTranscoderUtils.getForceRotatedInvertedExifOrientation(rotationOptions, encodedImage);
        }
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270 || exifOrientation == 5 || exifOrientation == 7;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        int heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight();
        float ratio = JpegTranscoderUtils.determineResizeRatio(resizeOptions, widthAfterRotation, heightAfterRotation);
        int numerator = JpegTranscoderUtils.roundNumerator(ratio, resizeOptions.roundUpFraction);
        if (numerator > 8) {
            return 8;
        }
        return numerator < 1 ? 1 : numerator;
    }

    @JvmStatic
    public static final int getRotationAngle(@NotNull RotationOptions rotationOptions, @NotNull EncodedImage encodedImage) {
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        if (!rotationOptions.rotationEnabled()) {
            return 0;
        }
        int rotationFromMetadata = INSTANCE.extractOrientationFromMetadata(encodedImage);
        return rotationOptions.useImageMetadata() ? rotationFromMetadata : (rotationFromMetadata + rotationOptions.getForcedAngle()) % 360;
    }

    @JvmStatic
    public static final int getForceRotatedInvertedExifOrientation(@NotNull RotationOptions rotationOptions, @NotNull EncodedImage encodedImage) {
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        int exifOrientation = encodedImage.getExifOrientation();
        int index = INVERTED_EXIF_ORIENTATIONS.indexOf((Object)exifOrientation);
        if (!(index >= 0)) {
            boolean $i$a$-require-JpegTranscoderUtils$getForceRotatedInvertedExifOrientation$22 = false;
            String $i$a$-require-JpegTranscoderUtils$getForceRotatedInvertedExifOrientation$22 = "Only accepts inverted exif orientations";
            throw new IllegalArgumentException($i$a$-require-JpegTranscoderUtils$getForceRotatedInvertedExifOrientation$22.toString());
        }
        int forcedAngle = 0;
        if (!rotationOptions.useImageMetadata()) {
            forcedAngle = rotationOptions.getForcedAngle();
        }
        int timesToRotate = forcedAngle / 90;
        Object object = INVERTED_EXIF_ORIENTATIONS.get((index + timesToRotate) % INVERTED_EXIF_ORIENTATIONS.size());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"INVERTED_EXIF_ORIENTATIO\u2026D_EXIF_ORIENTATIONS.size]");
        return ((Number)object).intValue();
    }

    @JvmStatic
    @VisibleForTesting
    public static final float determineResizeRatio(@Nullable ResizeOptions resizeOptions, int width, int height) {
        if (resizeOptions == null) {
            return 1.0f;
        }
        float widthRatio = (float)resizeOptions.width / (float)width;
        float heightRatio = (float)resizeOptions.height / (float)height;
        float ratio = Math.max(widthRatio, heightRatio);
        if ((float)width * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)width;
        }
        if ((float)height * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)height;
        }
        return ratio;
    }

    @JvmStatic
    @VisibleForTesting
    public static final int roundNumerator(float maxRatio, float roundUpFraction) {
        return (int)(roundUpFraction + maxRatio * (float)8);
    }

    @JvmStatic
    @VisibleForTesting
    public static final int calculateDownsampleNumerator(int downsampleRatio) {
        return Math.max(1, 8 / downsampleRatio);
    }

    @JvmStatic
    @Nullable
    public static final Matrix getTransformationMatrix(@NotNull EncodedImage encodedImage, @NotNull RotationOptions rotationOptions) {
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Matrix transformationMatrix = null;
        if (INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation())) {
            int exifOrientation = JpegTranscoderUtils.getForceRotatedInvertedExifOrientation(rotationOptions, encodedImage);
            transformationMatrix = INSTANCE.getTransformationMatrixFromInvertedExif(exifOrientation);
        } else {
            int rotationAngle = JpegTranscoderUtils.getRotationAngle(rotationOptions, encodedImage);
            if (rotationAngle != 0) {
                transformationMatrix = new Matrix();
                transformationMatrix.setRotate((float)rotationAngle);
            }
        }
        return transformationMatrix;
    }

    private final Matrix getTransformationMatrixFromInvertedExif(int orientation) {
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return matrix;
    }

    private final int extractOrientationFromMetadata(EncodedImage encodedImage) {
        int n;
        switch (encodedImage.getRotationAngle()) {
            case 90: 
            case 180: 
            case 270: {
                n = encodedImage.getRotationAngle();
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    static {
        Object[] objectArray = new Integer[]{2, 7, 4, 5};
        ImmutableList immutableList = ImmutableList.of((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(\n          ExifInterf\u2026ce.ORIENTATION_TRANSPOSE)");
        INVERTED_EXIF_ORIENTATIONS = immutableList;
    }
}

