/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageutils.BitmapUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0004J\u0012\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R6\u0010\t\u001a*\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u000b*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/facebook/imagepipeline/cache/AnimationFrames;", "Ljava/io/Closeable;", "bitmapsByFrame", "", "", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "realToCompressIndexMap", "(Ljava/util/Map;Ljava/util/Map;)V", "concurrentFrames", "Ljava/util/concurrent/ConcurrentHashMap;", "kotlin.jvm.PlatformType", "frames", "getFrames", "()Ljava/util/Map;", "sizeBytes", "getSizeBytes", "()I", "close", "", "getFrame", "frameIndex", "isValidBitmap", "", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nAnimatedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedCache.kt\ncom/facebook/imagepipeline/cache/AnimationFrames\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n515#2:123\n500#2,6:124\n1855#3,2:130\n*S KotlinDebug\n*F\n+ 1 AnimatedCache.kt\ncom/facebook/imagepipeline/cache/AnimationFrames\n*L\n86#1:123\n86#1:124,6\n116#1:130,2\n*E\n"})
public final class AnimationFrames
implements Closeable {
    @NotNull
    private final Map<Integer, Integer> realToCompressIndexMap;
    @NotNull
    private final ConcurrentHashMap<Integer, CloseableReference<Bitmap>> concurrentFrames;
    private final int sizeBytes;

    /*
     * WARNING - void declaration
     */
    public AnimationFrames(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> bitmapsByFrame, @NotNull Map<Integer, Integer> realToCompressIndexMap) {
        int n;
        Intrinsics.checkNotNullParameter(bitmapsByFrame, (String)"bitmapsByFrame");
        Intrinsics.checkNotNullParameter(realToCompressIndexMap, (String)"realToCompressIndexMap");
        this.realToCompressIndexMap = realToCompressIndexMap;
        this.concurrentFrames = new ConcurrentHashMap<Integer, CloseableReference<Bitmap>>(bitmapsByFrame);
        Iterable iterable = bitmapsByFrame.values();
        AnimationFrames animationFrames = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            CloseableReference closeableReference = (CloseableReference)t;
            n = n2;
            boolean bl = false;
            int n3 = it.isValid() ? BitmapUtil.getSizeInBytes((Bitmap)it.get()) : 0;
            n2 = n + n3;
        }
        animationFrames.sizeBytes = n = n2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, CloseableReference<Bitmap>> getFrames() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.concurrentFrames;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            CloseableReference frame = (CloseableReference)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)frame, (String)"frame");
            if (!this.isValidBitmap((CloseableReference<Bitmap>)frame)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final int getSizeBytes() {
        return this.sizeBytes;
    }

    @Nullable
    public final CloseableReference<Bitmap> getFrame(int frameIndex) {
        CloseableReference<Bitmap> frame;
        CloseableReference<Bitmap> closeableReference;
        if (this.realToCompressIndexMap.isEmpty()) {
            closeableReference = this.concurrentFrames.get(frameIndex);
        } else {
            Integer n = this.realToCompressIndexMap.get(frameIndex);
            if (n == null) {
                return null;
            }
            int reducedIndex = n;
            closeableReference = this.concurrentFrames.get(reducedIndex);
        }
        CloseableReference<Bitmap> closeableReference2 = frame = closeableReference;
        return (closeableReference2 != null ? this.isValidBitmap(closeableReference2) : false) ? frame : null;
    }

    @Override
    public void close() {
        Collection<CloseableReference<Bitmap>> collection = this.concurrentFrames.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"concurrentFrames.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloseableReference it = (CloseableReference)element$iv;
            boolean bl = false;
            it.close();
        }
        this.concurrentFrames.clear();
    }

    private final boolean isValidBitmap(CloseableReference<Bitmap> $this$isValidBitmap) {
        return $this$isValidBitmap.isValid() && !((Bitmap)$this$isValidBitmap.get()).isRecycled();
    }
}

