/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.net.Uri;
import android.os.Build;
import android.util.Pair;
import androidx.core.util.Pools;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.DecodeBufferHelper;
import com.facebook.imageutils.ImageMetaData;
import com.facebook.infer.annotation.Nullsafe;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public final class BitmapUtil {
    private static final int POOL_SIZE = 12;
    private static Pools.SynchronizedPool<ByteBuffer> DECODE_BUFFERS;
    public static final int ALPHA_8_BYTES_PER_PIXEL = 1;
    public static final int ARGB_4444_BYTES_PER_PIXEL = 2;
    public static final int ARGB_8888_BYTES_PER_PIXEL = 4;
    public static final int RGB_565_BYTES_PER_PIXEL = 2;
    public static final int RGBA_F16_BYTES_PER_PIXEL = 8;
    public static final float MAX_BITMAP_SIZE = 2048.0f;
    private static boolean sUseDecodeBufferHelper;

    @SuppressLint(value={"NewApi"})
    public static int getSizeInBytes(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bitmap.getByteCount();
    }

    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(byte[] bytes) {
        return BitmapUtil.decodeDimensions(new ByteArrayInputStream(bytes));
    }

    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(Uri uri) {
        Preconditions.checkNotNull((Object)uri);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
        return options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<Integer, Integer> decodeDimensions(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        ByteBuffer byteBuffer = BitmapUtil.acquireByteBuffer();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(DecodeBufferHelper.getRecommendedDecodeBufferSize());
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            Pair pair = options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
            return pair;
        }
        finally {
            BitmapUtil.releaseByteBuffer(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageMetaData decodeDimensionsAndColorSpace(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        ByteBuffer byteBuffer = BitmapUtil.acquireByteBuffer();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(DecodeBufferHelper.getRecommendedDecodeBufferSize());
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            ColorSpace colorSpace = null;
            if (Build.VERSION.SDK_INT >= 26) {
                colorSpace = options.outColorSpace;
            }
            ImageMetaData imageMetaData = new ImageMetaData(options.outWidth, options.outHeight, colorSpace);
            return imageMetaData;
        }
        finally {
            BitmapUtil.releaseByteBuffer(byteBuffer);
        }
    }

    public static int getPixelSizeForBitmapConfig(Bitmap.Config bitmapConfig) {
        switch (bitmapConfig) {
            case ARGB_8888: {
                return 4;
            }
            case ALPHA_8: {
                return 1;
            }
            case ARGB_4444: {
                return 2;
            }
            case RGB_565: {
                return 2;
            }
            case RGBA_F16: {
                return 8;
            }
            case HARDWARE: {
                return 4;
            }
        }
        throw new UnsupportedOperationException("The provided Bitmap.Config is not supported");
    }

    public static int getSizeInByteForBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        return width * height * BitmapUtil.getPixelSizeForBitmapConfig(bitmapConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ByteBuffer acquireByteBuffer() {
        if (sUseDecodeBufferHelper) {
            return DecodeBufferHelper.INSTANCE.acquire();
        }
        if (DECODE_BUFFERS != null) return (ByteBuffer)DECODE_BUFFERS.acquire();
        Class<BitmapUtil> clazz = BitmapUtil.class;
        synchronized (BitmapUtil.class) {
            if (DECODE_BUFFERS != null) return (ByteBuffer)DECODE_BUFFERS.acquire();
            DECODE_BUFFERS = new Pools.SynchronizedPool(12);
            // ** MonitorExit[var0] (shouldn't be in output)
            return (ByteBuffer)DECODE_BUFFERS.acquire();
        }
    }

    private static void releaseByteBuffer(ByteBuffer byteBuffer) {
        if (!sUseDecodeBufferHelper) {
            DECODE_BUFFERS.release((Object)byteBuffer);
        }
    }

    public static void setUseDecodeBufferHelper(boolean useDecodeBufferHelper) {
        sUseDecodeBufferHelper = useDecodeBufferHelper;
    }
}

