/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import android.graphics.Matrix;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableList;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class JpegTranscoderUtils {
    private static final int FULL_ROUND = 360;
    public static final int MIN_QUALITY = 0;
    public static final int MAX_QUALITY = 100;
    public static final int MIN_SCALE_NUMERATOR = 1;
    public static final int MAX_SCALE_NUMERATOR = 16;
    public static final int SCALE_DENOMINATOR = 8;
    public static final ImmutableList<Integer> INVERTED_EXIF_ORIENTATIONS = ImmutableList.of((Object[])new Integer[]{2, 7, 4, 5});
    @VisibleForTesting
    public static final int DEFAULT_JPEG_QUALITY = 85;

    public static boolean isRotationAngleAllowed(int degrees) {
        return degrees >= 0 && degrees <= 270 && degrees % 90 == 0;
    }

    public static boolean isExifOrientationAllowed(int exifOrientation) {
        switch (exifOrientation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int getSoftwareNumerator(RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, EncodedImage encodedImage, boolean resizingEnabled) {
        int heightAfterRotation;
        boolean swapDimensions;
        int widthAfterRotation;
        float ratio;
        int numerator;
        if (!resizingEnabled) {
            return 8;
        }
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = JpegTranscoderUtils.getRotationAngle(rotationOptions, encodedImage);
        int exifOrientation = 0;
        if (INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation())) {
            exifOrientation = JpegTranscoderUtils.getForceRotatedInvertedExifOrientation(rotationOptions, encodedImage);
        }
        if ((numerator = JpegTranscoderUtils.roundNumerator(ratio = JpegTranscoderUtils.determineResizeRatio(resizeOptions, widthAfterRotation = (swapDimensions = rotationAngle == 90 || rotationAngle == 270 || exifOrientation == 5 || exifOrientation == 7) ? encodedImage.getHeight() : encodedImage.getWidth(), heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight()), resizeOptions.roundUpFraction)) > 8) {
            return 8;
        }
        return numerator < 1 ? 1 : numerator;
    }

    public static int getRotationAngle(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.rotationEnabled()) {
            return 0;
        }
        int rotationFromMetadata = JpegTranscoderUtils.extractOrientationFromMetadata(encodedImage);
        if (rotationOptions.useImageMetadata()) {
            return rotationFromMetadata;
        }
        return (rotationFromMetadata + rotationOptions.getForcedAngle()) % 360;
    }

    public static int getForceRotatedInvertedExifOrientation(RotationOptions rotationOptions, EncodedImage encodedImage) {
        int exifOrientation = encodedImage.getExifOrientation();
        int index = INVERTED_EXIF_ORIENTATIONS.indexOf((Object)exifOrientation);
        if (index < 0) {
            throw new IllegalArgumentException("Only accepts inverted exif orientations");
        }
        int forcedAngle = 0;
        if (!rotationOptions.useImageMetadata()) {
            forcedAngle = rotationOptions.getForcedAngle();
        }
        int timesToRotate = forcedAngle / 90;
        return (Integer)INVERTED_EXIF_ORIENTATIONS.get((index + timesToRotate) % INVERTED_EXIF_ORIENTATIONS.size());
    }

    @VisibleForTesting
    public static float determineResizeRatio(ResizeOptions resizeOptions, int width, int height) {
        if (resizeOptions == null) {
            return 1.0f;
        }
        float widthRatio = (float)resizeOptions.width / (float)width;
        float heightRatio = (float)resizeOptions.height / (float)height;
        float ratio = Math.max(widthRatio, heightRatio);
        if ((float)width * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)width;
        }
        if ((float)height * ratio > resizeOptions.maxBitmapSize) {
            ratio = resizeOptions.maxBitmapSize / (float)height;
        }
        return ratio;
    }

    @VisibleForTesting
    public static int roundNumerator(float maxRatio, float roundUpFraction) {
        return (int)(roundUpFraction + maxRatio * 8.0f);
    }

    @VisibleForTesting
    public static int calculateDownsampleNumerator(int downsampleRatio) {
        return Math.max(1, 8 / downsampleRatio);
    }

    @Nullable
    public static Matrix getTransformationMatrix(EncodedImage encodedImage, RotationOptions rotationOptions) {
        Matrix transformationMatrix = null;
        if (INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation())) {
            int exifOrientation = JpegTranscoderUtils.getForceRotatedInvertedExifOrientation(rotationOptions, encodedImage);
            transformationMatrix = JpegTranscoderUtils.getTransformationMatrixFromInvertedExif(exifOrientation);
        } else {
            int rotationAngle = JpegTranscoderUtils.getRotationAngle(rotationOptions, encodedImage);
            if (rotationAngle != 0) {
                transformationMatrix = new Matrix();
                transformationMatrix.setRotate((float)rotationAngle);
            }
        }
        return transformationMatrix;
    }

    @Nullable
    private static Matrix getTransformationMatrixFromInvertedExif(int orientation) {
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            default: {
                return null;
            }
        }
        return matrix;
    }

    private static int extractOrientationFromMetadata(EncodedImage encodedImage) {
        switch (encodedImage.getRotationAngle()) {
            case 90: 
            case 180: 
            case 270: {
                return encodedImage.getRotationAngle();
            }
        }
        return 0;
    }
}

