/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.util.Pair;
import com.facebook.infer.annotation.Nullsafe;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class WebpUtil {
    private static final String VP8_HEADER = "VP8 ";
    private static final String VP8L_HEADER = "VP8L";
    private static final String VP8X_HEADER = "VP8X";

    private WebpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<Integer, Integer> getSize(InputStream is) {
        Object result = null;
        byte[] headerBuffer = new byte[4];
        try {
            is.read(headerBuffer);
            if (!WebpUtil.compare(headerBuffer, "RIFF")) {
                Pair<Integer, Integer> pair = null;
                return pair;
            }
            WebpUtil.getInt(is);
            is.read(headerBuffer);
            if (!WebpUtil.compare(headerBuffer, "WEBP")) {
                Pair<Integer, Integer> pair = null;
                return pair;
            }
            is.read(headerBuffer);
            String headerAsString = WebpUtil.getHeader(headerBuffer);
            if (VP8_HEADER.equals(headerAsString)) {
                Pair<Integer, Integer> pair = WebpUtil.getVP8Dimension(is);
                return pair;
            }
            if (VP8L_HEADER.equals(headerAsString)) {
                Pair<Integer, Integer> pair = WebpUtil.getVP8LDimension(is);
                return pair;
            }
            if (VP8X_HEADER.equals(headerAsString)) {
                Pair<Integer, Integer> pair = WebpUtil.getVP8XDimension(is);
                return pair;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Nullable
    private static Pair<Integer, Integer> getVP8Dimension(InputStream is) throws IOException {
        is.skip(7L);
        short sign1 = WebpUtil.getShort(is);
        short sign2 = WebpUtil.getShort(is);
        short sign3 = WebpUtil.getShort(is);
        if (sign1 != 157 || sign2 != 1 || sign3 != 42) {
            return null;
        }
        return new Pair((Object)WebpUtil.get2BytesAsInt(is), (Object)WebpUtil.get2BytesAsInt(is));
    }

    @Nullable
    private static Pair<Integer, Integer> getVP8LDimension(InputStream is) throws IOException {
        WebpUtil.getInt(is);
        byte check = WebpUtil.getByte(is);
        if (check != 47) {
            return null;
        }
        int data1 = (byte)is.read() & 0xFF;
        int data2 = (byte)is.read() & 0xFF;
        int data3 = (byte)is.read() & 0xFF;
        int data4 = (byte)is.read() & 0xFF;
        int width = ((data2 & 0x3F) << 8 | data1) + 1;
        int height = ((data4 & 0xF) << 10 | data3 << 2 | (data2 & 0xC0) >> 6) + 1;
        return new Pair((Object)width, (Object)height);
    }

    private static Pair<Integer, Integer> getVP8XDimension(InputStream is) throws IOException {
        is.skip(8L);
        return new Pair((Object)(WebpUtil.read3Bytes(is) + 1), (Object)(WebpUtil.read3Bytes(is) + 1));
    }

    private static boolean compare(byte[] what, String with) {
        if (what.length != with.length()) {
            return false;
        }
        for (int i = 0; i < what.length; ++i) {
            if (with.charAt(i) == what[i]) continue;
            return false;
        }
        return true;
    }

    private static String getHeader(byte[] header) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < header.length; ++i) {
            str.append((char)header[i]);
        }
        return str.toString();
    }

    private static int getInt(InputStream is) throws IOException {
        byte byte1 = (byte)is.read();
        byte byte2 = (byte)is.read();
        byte byte3 = (byte)is.read();
        byte byte4 = (byte)is.read();
        return byte4 << 24 & 0xFF000000 | byte3 << 16 & 0xFF0000 | byte2 << 8 & 0xFF00 | byte1 & 0xFF;
    }

    public static int get2BytesAsInt(InputStream is) throws IOException {
        byte byte1 = (byte)is.read();
        byte byte2 = (byte)is.read();
        return byte2 << 8 & 0xFF00 | byte1 & 0xFF;
    }

    private static int read3Bytes(InputStream is) throws IOException {
        byte byte1 = WebpUtil.getByte(is);
        byte byte2 = WebpUtil.getByte(is);
        byte byte3 = WebpUtil.getByte(is);
        return byte3 << 16 & 0xFF0000 | byte2 << 8 & 0xFF00 | byte1 & 0xFF;
    }

    private static short getShort(InputStream is) throws IOException {
        return (short)(is.read() & 0xFF);
    }

    private static byte getByte(InputStream is) throws IOException {
        return (byte)(is.read() & 0xFF);
    }

    private static boolean isBitOne(byte input, int bitIndex) {
        return (input >> bitIndex % 8 & 1) == 1;
    }
}

