/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DownsampleUtil {
    public static final int DEFAULT_SAMPLE_SIZE = 1;
    private static final float INTERVAL_ROUNDING = 0.33333334f;

    private DownsampleUtil() {
    }

    public static int determineSampleSize(RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, EncodedImage encodedImage, int maxBitmapSize) {
        float computedMaxBitmapSize;
        if (!EncodedImage.isMetaDataAvailable(encodedImage)) {
            return 1;
        }
        float ratio = DownsampleUtil.determineDownsampleRatio(rotationOptions, resizeOptions, encodedImage);
        int sampleSize = encodedImage.getImageFormat() == DefaultImageFormats.JPEG ? DownsampleUtil.ratioToSampleSizeJPEG(ratio) : DownsampleUtil.ratioToSampleSize(ratio);
        int maxDimension = Math.max(encodedImage.getHeight(), encodedImage.getWidth());
        float f = computedMaxBitmapSize = resizeOptions != null ? resizeOptions.maxBitmapSize : (float)maxBitmapSize;
        while ((float)(maxDimension / sampleSize) > computedMaxBitmapSize) {
            if (encodedImage.getImageFormat() == DefaultImageFormats.JPEG) {
                sampleSize *= 2;
                continue;
            }
            ++sampleSize;
        }
        return sampleSize;
    }

    public static int determineSampleSizeJPEG(EncodedImage encodedImage, int pixelSize, int maxBitmapSizeInBytes) {
        int sampleSize = encodedImage.getSampleSize();
        int base = encodedImage.getWidth() * encodedImage.getHeight() * pixelSize;
        while (base / sampleSize / sampleSize > maxBitmapSizeInBytes) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    @VisibleForTesting
    public static float determineDownsampleRatio(RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, EncodedImage encodedImage) {
        Preconditions.checkArgument((Boolean)EncodedImage.isMetaDataAvailable(encodedImage));
        if (resizeOptions == null || resizeOptions.height <= 0 || resizeOptions.width <= 0 || encodedImage.getWidth() == 0 || encodedImage.getHeight() == 0) {
            return 1.0f;
        }
        int rotationAngle = DownsampleUtil.getRotationAngle(rotationOptions, encodedImage);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        int heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight();
        float widthRatio = (float)resizeOptions.width / (float)widthAfterRotation;
        float heightRatio = (float)resizeOptions.height / (float)heightAfterRotation;
        float ratio = Math.max(widthRatio, heightRatio);
        FLog.v((String)"DownsampleUtil", (String)"Downsample - Specified size: %dx%d, image size: %dx%d ratio: %.1f x %.1f, ratio: %.3f", (Object[])new Object[]{resizeOptions.width, resizeOptions.height, widthAfterRotation, heightAfterRotation, Float.valueOf(widthRatio), Float.valueOf(heightRatio), Float.valueOf(ratio)});
        return ratio;
    }

    @VisibleForTesting
    public static int ratioToSampleSize(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)sampleSize + (intervalLength = 1.0 / (Math.pow(sampleSize, 2.0) - (double)sampleSize)) * 0.3333333432674408) <= (double)ratio)) {
            ++sampleSize;
        }
        return sampleSize - 1;
    }

    @VisibleForTesting
    public static int ratioToSampleSizeJPEG(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)(2 * sampleSize) + (intervalLength = 1.0 / (double)(2 * sampleSize)) * 0.3333333432674408) <= (double)ratio)) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    private static int getRotationAngle(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.useImageMetadata()) {
            return 0;
        }
        int rotationAngle = encodedImage.getRotationAngle();
        Preconditions.checkArgument((Boolean)(rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270 ? 1 : 0));
        return rotationAngle;
    }

    @VisibleForTesting
    public static int roundToPowerOfTwo(int sampleSize) {
        int compare = 1;
        while (compare < sampleSize) {
            compare *= 2;
        }
        return compare;
    }
}

