/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.core.PriorityThreadFactory;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DefaultExecutorSupplier
implements ExecutorSupplier {
    private static final int NUM_IO_BOUND_THREADS = 2;
    private static final int NUM_LIGHTWEIGHT_BACKGROUND_THREADS = 1;
    private final Executor mIoBoundExecutor = Executors.newFixedThreadPool(2, new PriorityThreadFactory(10, "FrescoIoBoundExecutor", true));
    private final Executor mDecodeExecutor;
    private final Executor mBackgroundExecutor;
    private final Executor mLightWeightBackgroundExecutor;
    private final ScheduledExecutorService mBackgroundScheduledExecutorService;

    public DefaultExecutorSupplier(int numCpuBoundThreads) {
        this.mDecodeExecutor = Executors.newFixedThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoDecodeExecutor", true));
        this.mBackgroundExecutor = Executors.newFixedThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoBackgroundExecutor", true));
        this.mBackgroundScheduledExecutorService = Executors.newScheduledThreadPool(numCpuBoundThreads, new PriorityThreadFactory(10, "FrescoBackgroundExecutor", true));
        this.mLightWeightBackgroundExecutor = Executors.newFixedThreadPool(1, new PriorityThreadFactory(10, "FrescoLightWeightBackgroundExecutor", true));
    }

    @Override
    public Executor forLocalStorageRead() {
        return this.mIoBoundExecutor;
    }

    @Override
    public Executor forLocalStorageWrite() {
        return this.mIoBoundExecutor;
    }

    @Override
    public Executor forDecode() {
        return this.mDecodeExecutor;
    }

    @Override
    public Executor forBackgroundTasks() {
        return this.mBackgroundExecutor;
    }

    @Override
    public ScheduledExecutorService scheduledExecutorServiceForBackgroundTasks() {
        return this.mBackgroundScheduledExecutorService;
    }

    @Override
    public Executor forLightweightBackgroundTasks() {
        return this.mLightWeightBackgroundExecutor;
    }

    @Override
    public Executor forThumbnailProducer() {
        return this.mIoBoundExecutor;
    }
}

