/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.common;

import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.common.util.SecureHashUtil;
import com.facebook.infer.annotation.Nullsafe;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public final class CacheKeyUtil {
    public static List<String> getResourceIds(CacheKey key) {
        try {
            ArrayList<String> ids;
            if (key instanceof MultiCacheKey) {
                List<CacheKey> keys = ((MultiCacheKey)key).getCacheKeys();
                ids = new ArrayList(keys.size());
                for (int i = 0; i < keys.size(); ++i) {
                    ids.add(CacheKeyUtil.secureHashKey(keys.get(i)));
                }
            } else {
                ids = new ArrayList<String>(1);
                ids.add(key.isResourceIdForDebugging() ? key.getUriString() : CacheKeyUtil.secureHashKey(key));
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFirstResourceId(CacheKey key) {
        try {
            if (key instanceof MultiCacheKey) {
                List<CacheKey> keys = ((MultiCacheKey)key).getCacheKeys();
                return CacheKeyUtil.secureHashKey(keys.get(0));
            }
            return CacheKeyUtil.secureHashKey(key);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String secureHashKey(CacheKey key) throws UnsupportedEncodingException {
        return SecureHashUtil.makeSHA1HashBase64((byte[])key.getUriString().getBytes("UTF-8"));
    }
}

