/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.transformation.BitmapTransformation;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageDecodeOptions {
    private static final ImageDecodeOptions DEFAULTS = ImageDecodeOptions.newBuilder().build();
    public final int minDecodeIntervalMs;
    public final boolean decodePreviewFrame;
    public final boolean useLastFrameForPreview;
    public final boolean decodeAllFrames;
    public final boolean forceStaticImage;
    public final Bitmap.Config bitmapConfig;
    @Nullable
    public final ImageDecoder customImageDecoder;
    @Nullable
    public final BitmapTransformation bitmapTransformation;
    @Nullable
    public final ColorSpace colorSpace;

    public ImageDecodeOptions(ImageDecodeOptionsBuilder b) {
        this.minDecodeIntervalMs = b.getMinDecodeIntervalMs();
        this.decodePreviewFrame = b.getDecodePreviewFrame();
        this.useLastFrameForPreview = b.getUseLastFrameForPreview();
        this.decodeAllFrames = b.getDecodeAllFrames();
        this.forceStaticImage = b.getForceStaticImage();
        this.bitmapConfig = b.getBitmapConfig();
        this.customImageDecoder = b.getCustomImageDecoder();
        this.bitmapTransformation = b.getBitmapTransformation();
        this.colorSpace = b.getColorSpace();
    }

    public static ImageDecodeOptions defaults() {
        return DEFAULTS;
    }

    public static ImageDecodeOptionsBuilder newBuilder() {
        return new ImageDecodeOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDecodeOptions that = (ImageDecodeOptions)o;
        if (this.decodePreviewFrame != that.decodePreviewFrame) {
            return false;
        }
        if (this.useLastFrameForPreview != that.useLastFrameForPreview) {
            return false;
        }
        if (this.decodeAllFrames != that.decodeAllFrames) {
            return false;
        }
        if (this.forceStaticImage != that.forceStaticImage) {
            return false;
        }
        if (this.bitmapConfig != that.bitmapConfig) {
            return false;
        }
        if (this.customImageDecoder != that.customImageDecoder) {
            return false;
        }
        if (this.bitmapTransformation != that.bitmapTransformation) {
            return false;
        }
        return this.colorSpace == that.colorSpace;
    }

    public int hashCode() {
        int result = this.minDecodeIntervalMs;
        result = 31 * result + (this.decodePreviewFrame ? 1 : 0);
        result = 31 * result + (this.useLastFrameForPreview ? 1 : 0);
        result = 31 * result + (this.decodeAllFrames ? 1 : 0);
        result = 31 * result + (this.forceStaticImage ? 1 : 0);
        result = 31 * result + this.bitmapConfig.ordinal();
        result = 31 * result + (this.customImageDecoder != null ? this.customImageDecoder.hashCode() : 0);
        result = 31 * result + (this.bitmapTransformation != null ? this.bitmapTransformation.hashCode() : 0);
        result = 31 * result + (this.colorSpace != null ? this.colorSpace.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format((Locale)null, "%d-%b-%b-%b-%b-%b-%s-%s-%s", this.minDecodeIntervalMs, this.decodePreviewFrame, this.useLastFrameForPreview, this.decodeAllFrames, this.forceStaticImage, this.bitmapConfig.name(), this.customImageDecoder, this.bitmapTransformation, this.colorSpace);
    }
}

