/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.common.CacheEventListener;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.EntryEvictionComparatorSupplier;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.disk.DiskTrimmable;
import com.facebook.common.disk.DiskTrimmableRegistry;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.statfs.StatFsHelper;
import com.facebook.common.time.Clock;
import com.facebook.common.time.SystemClock;
import com.facebook.common.util.SecureHashUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DiskStorageCache
implements FileCache,
DiskTrimmable {
    private static final Class<?> TAG = DiskStorageCache.class;
    public static final int START_OF_VERSIONING = 1;
    private static final long FUTURE_TIMESTAMP_THRESHOLD_MS = TimeUnit.HOURS.toMillis(2L);
    private static final long FILECACHE_SIZE_UPDATE_PERIOD_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final double TRIMMING_LOWER_BOUND = 0.02;
    private static final long UNINITIALIZED = -1L;
    private final long mLowDiskSpaceCacheSizeLimit;
    private final long mDefaultCacheSizeLimit;
    private long mCacheSizeLimit;
    private final CacheEventListener mCacheEventListener;
    @GuardedBy(value="mLock")
    @VisibleForTesting
    final Map<CacheKey, String> mIndex;
    @GuardedBy(value="mLock")
    private long mCacheSizeLastUpdateTime;
    private final long mCacheSizeLimitMinimum;
    private final StatFsHelper mStatFsHelper;
    private final DiskStorage mStorage;
    private final EntryEvictionComparatorSupplier mEntryEvictionComparatorSupplier;
    private final CacheErrorLogger mCacheErrorLogger;
    private final CacheStats mCacheStats;
    private final Clock mClock;
    private final Object mLock = new Object();

    public DiskStorageCache(DiskStorage diskStorage, EntryEvictionComparatorSupplier entryEvictionComparatorSupplier, Params params, CacheEventListener cacheEventListener, CacheErrorLogger cacheErrorLogger, @Nullable DiskTrimmableRegistry diskTrimmableRegistry) {
        this.mLowDiskSpaceCacheSizeLimit = params.mLowDiskSpaceCacheSizeLimit;
        this.mDefaultCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mStatFsHelper = StatFsHelper.getInstance();
        this.mStorage = diskStorage;
        this.mEntryEvictionComparatorSupplier = entryEvictionComparatorSupplier;
        this.mCacheSizeLastUpdateTime = -1L;
        this.mCacheEventListener = cacheEventListener;
        this.mCacheSizeLimitMinimum = params.mCacheSizeLimitMinimum;
        this.mCacheErrorLogger = cacheErrorLogger;
        this.mCacheStats = new CacheStats();
        if (diskTrimmableRegistry != null) {
            diskTrimmableRegistry.registerDiskTrimmable((DiskTrimmable)this);
        }
        this.mClock = SystemClock.get();
        this.mIndex = new HashMap<CacheKey, String>();
    }

    @Override
    public DiskStorage.DiskDumpInfo getDumpInfo() throws IOException {
        return this.mStorage.getDumpInfo();
    }

    @Override
    public boolean isEnabled() {
        return this.mStorage.isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource getResource(CacheKey key) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                String resourceId = null;
                BinaryResource resource = null;
                if (this.mIndex.containsKey(key)) {
                    resourceId = this.mIndex.get(key);
                    resource = this.mStorage.getResource(resourceId, key);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size() && (resource = this.mStorage.getResource(resourceId = resourceIds.get(i), key)) == null; ++i) {
                    }
                }
                if (resource == null) {
                    this.mCacheEventListener.onMiss();
                    this.mIndex.remove(key);
                } else {
                    this.mCacheEventListener.onHit();
                    this.mIndex.put(key, resourceId);
                }
                return resource;
            }
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "getResource", ioe);
            this.mCacheEventListener.onReadException();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probe(CacheKey key) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                String resourceId = null;
                boolean retval = false;
                if (this.mIndex.containsKey(key)) {
                    resourceId = this.mIndex.get(key);
                    retval = this.mStorage.touch(resourceId, key);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size() && !(retval = this.mStorage.touch(resourceId = resourceIds.get(i), key)); ++i) {
                    }
                }
                if (retval) {
                    this.mIndex.put(key, resourceId);
                }
                return retval;
            }
        }
        catch (IOException e) {
            this.mCacheEventListener.onReadException();
            return false;
        }
    }

    private DiskStorage.Inserter startInsert(String resourceId, CacheKey key) throws IOException {
        this.maybeEvictFilesInCacheDir();
        return this.mStorage.insert(resourceId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryResource endInsert(DiskStorage.Inserter inserter, CacheKey key, String resourceId) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            BinaryResource resource = inserter.commit(key);
            this.mCacheStats.increment(resource.size(), 1L);
            this.mIndex.put(key, resourceId);
            return resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource insert(CacheKey key, WriterCallback callback) throws IOException {
        BinaryResource binaryResource;
        block9: {
            String resourceId;
            this.mCacheEventListener.onWriteAttempt();
            Object object = this.mLock;
            synchronized (object) {
                resourceId = this.mIndex.containsKey(key) ? this.mIndex.get(key) : DiskStorageCache.getResourceIds(key).get(0);
            }
            DiskStorage.Inserter inserter = this.startInsert(resourceId, key);
            try {
                inserter.writeData(callback, key);
                binaryResource = this.endInsert(inserter, key, resourceId);
                if (inserter.cleanUp()) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (!inserter.cleanUp()) {
                        FLog.e(TAG, (String)"Failed to delete temp file");
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.mCacheEventListener.onWriteException();
                    FLog.e(TAG, (String)"Failed inserting a file into the cache", (Throwable)ioe);
                    throw ioe;
                }
            }
            FLog.e(TAG, (String)"Failed to delete temp file");
        }
        return binaryResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                String resourceId = null;
                if (this.mIndex.containsKey(key)) {
                    resourceId = this.mIndex.get(key);
                    this.mStorage.remove(resourceId);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size(); ++i) {
                        resourceId = resourceIds.get(i);
                        this.mStorage.remove(resourceId);
                    }
                }
                this.mIndex.remove(key);
            }
            catch (IOException e) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.DELETE_FILE, TAG, "delete: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clearOldEntries(long cacheExpirationMs) {
        long oldestRemainingEntryAgeMs = 0L;
        Object object = this.mLock;
        synchronized (object) {
            try {
                long now = this.mClock.now();
                Collection<DiskStorage.Entry> allEntries = this.mStorage.getEntries();
                int itemsRemovedCount = 0;
                long itemsRemovedSize = 0L;
                for (DiskStorage.Entry entry : allEntries) {
                    long entryAgeMs = Math.max(1L, Math.abs(now - entry.getTimestamp()));
                    if (entryAgeMs >= cacheExpirationMs) {
                        long entryRemovedSize = this.mStorage.remove(entry);
                        this.mIndex.values().remove(entry.getId());
                        if (entryRemovedSize <= 0L) continue;
                        ++itemsRemovedCount;
                        itemsRemovedSize += entryRemovedSize;
                        continue;
                    }
                    oldestRemainingEntryAgeMs = Math.max(oldestRemainingEntryAgeMs, entryAgeMs);
                }
                this.mStorage.purgeUnexpectedResources();
                if (itemsRemovedCount > 0) {
                    this.maybeUpdateFileCacheSize();
                    this.mCacheStats.increment(-itemsRemovedSize, -itemsRemovedCount);
                    this.reportEviction(CacheEventListener.EvictionReason.CONTENT_STALE, itemsRemovedCount, itemsRemovedSize);
                }
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearOldEntries: " + ioe.getMessage(), ioe);
            }
        }
        return oldestRemainingEntryAgeMs;
    }

    private void reportEviction(CacheEventListener.EvictionReason reason, int itemCount, long itemSize) {
        this.mCacheEventListener.onEviction(reason, itemCount, itemSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictFilesInCacheDir() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            boolean calculatedRightNow = this.maybeUpdateFileCacheSize();
            this.updateFileCacheSizeLimit();
            long cacheSize = this.mCacheStats.getSize();
            if (cacheSize > this.mCacheSizeLimit && !calculatedRightNow) {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
            }
            if (cacheSize > this.mCacheSizeLimit) {
                this.evictAboveSize(this.mCacheSizeLimit * 9L / 10L, CacheEventListener.EvictionReason.CACHE_FULL);
            }
        }
    }

    @GuardedBy(value="mLock")
    private void evictAboveSize(long desiredSize, CacheEventListener.EvictionReason reason) throws IOException {
        Collection<DiskStorage.Entry> entries;
        try {
            entries = this.getSortedEntries(this.mStorage.getEntries());
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "evictAboveSize: " + ioe.getMessage(), ioe);
            throw ioe;
        }
        long deleteSize = this.mCacheStats.getSize() - desiredSize;
        int itemCount = 0;
        long sumItemSizes = 0L;
        for (DiskStorage.Entry entry : entries) {
            if (sumItemSizes > deleteSize) break;
            long deletedSize = this.mStorage.remove(entry);
            this.mIndex.values().remove(entry.getId());
            if (deletedSize <= 0L) continue;
            ++itemCount;
            sumItemSizes += deletedSize;
        }
        this.mCacheStats.increment(-sumItemSizes, -itemCount);
        this.mStorage.purgeUnexpectedResources();
        this.reportEviction(reason, itemCount, sumItemSizes);
    }

    private Collection<DiskStorage.Entry> getSortedEntries(Collection<DiskStorage.Entry> allEntries) {
        long threshold = this.mClock.now() + FUTURE_TIMESTAMP_THRESHOLD_MS;
        ArrayList<DiskStorage.Entry> sortedList = new ArrayList<DiskStorage.Entry>(allEntries.size());
        ArrayList<DiskStorage.Entry> listToSort = new ArrayList<DiskStorage.Entry>(allEntries.size());
        for (DiskStorage.Entry entry : allEntries) {
            if (entry.getTimestamp() > threshold) {
                sortedList.add(entry);
                continue;
            }
            listToSort.add(entry);
        }
        Collections.sort(listToSort, this.mEntryEvictionComparatorSupplier.get());
        sortedList.addAll(listToSort);
        return sortedList;
    }

    @GuardedBy(value="mLock")
    private void updateFileCacheSizeLimit() {
        boolean isAvailableSpaceLowerThanHighLimit = this.mStatFsHelper.testLowDiskSpace(StatFsHelper.StorageType.INTERNAL, this.mDefaultCacheSizeLimit - this.mCacheStats.getSize());
        this.mCacheSizeLimit = isAvailableSpaceLowerThanHighLimit ? this.mLowDiskSpaceCacheSizeLimit : this.mDefaultCacheSizeLimit;
    }

    @Override
    public long getSize() {
        return this.mCacheStats.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mStorage.clearAll();
                this.mIndex.clear();
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearAll: " + ioe.getMessage(), ioe);
            }
            this.mCacheStats.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKeySync(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIndex.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.hasKeySync(key)) {
                return true;
            }
            try {
                String resourceId = null;
                boolean retval = false;
                if (this.mIndex.containsKey(key)) {
                    resourceId = this.mIndex.get(key);
                    retval = this.mStorage.contains(resourceId, key);
                } else {
                    List<String> resourceIds = DiskStorageCache.getResourceIds(key);
                    for (int i = 0; i < resourceIds.size() && !(retval = this.mStorage.contains(resourceId = resourceIds.get(i), key)); ++i) {
                    }
                }
                if (retval) {
                    this.mIndex.put(key, resourceId);
                } else {
                    this.mIndex.remove(key);
                }
                return retval;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToMinimum() {
        Object object = this.mLock;
        synchronized (object) {
            this.maybeUpdateFileCacheSize();
            long cacheSize = this.mCacheStats.getSize();
            if (this.mCacheSizeLimitMinimum <= 0L || cacheSize <= 0L || cacheSize < this.mCacheSizeLimitMinimum) {
                return;
            }
            double trimRatio = 1.0 - (double)this.mCacheSizeLimitMinimum / (double)cacheSize;
            if (trimRatio > 0.02) {
                this.trimBy(trimRatio);
            }
        }
    }

    public void trimToNothing() {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimBy(double trimRatio) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
                long cacheSize = this.mCacheStats.getSize();
                long newMaxBytesInFiles = cacheSize - (long)(trimRatio * (double)cacheSize);
                this.evictAboveSize(newMaxBytesInFiles, CacheEventListener.EvictionReason.CACHE_MANAGER_TRIMMED);
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "trimBy: " + ioe.getMessage(), ioe);
            }
        }
    }

    @GuardedBy(value="mLock")
    private boolean maybeUpdateFileCacheSize() {
        boolean result = false;
        long now = this.mClock.now();
        if (!this.mCacheStats.isInitialized() || this.mCacheSizeLastUpdateTime == -1L || now - this.mCacheSizeLastUpdateTime > FILECACHE_SIZE_UPDATE_PERIOD_MS) {
            this.calcFileCacheSize();
            this.mCacheSizeLastUpdateTime = now;
            result = true;
        }
        return result;
    }

    @GuardedBy(value="mLock")
    private void calcFileCacheSize() {
        long size = 0L;
        int count = 0;
        boolean foundFutureTimestamp = false;
        int numFutureFiles = 0;
        int sizeFutureFiles = 0;
        long maxTimeDelta = -1L;
        long now = this.mClock.now();
        long timeThreshold = now + FUTURE_TIMESTAMP_THRESHOLD_MS;
        try {
            Collection<DiskStorage.Entry> entries = this.mStorage.getEntries();
            for (DiskStorage.Entry entry : entries) {
                ++count;
                size += entry.getSize();
                if (entry.getTimestamp() <= timeThreshold) continue;
                foundFutureTimestamp = true;
                ++numFutureFiles;
                sizeFutureFiles = (int)((long)sizeFutureFiles + entry.getSize());
                maxTimeDelta = Math.max(entry.getTimestamp() - now, maxTimeDelta);
            }
            if (foundFutureTimestamp) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.READ_INVALID_ENTRY, TAG, "Future timestamp found in " + numFutureFiles + " files , with a total size of " + sizeFutureFiles + " bytes, and a maximum time delta of " + maxTimeDelta + "ms", null);
            }
            this.mCacheStats.set(size, count);
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "calcFileCacheSize: " + ioe.getMessage(), ioe);
        }
    }

    @VisibleForTesting
    static List<String> getResourceIds(CacheKey key) {
        try {
            ArrayList<String> ids;
            if (key instanceof MultiCacheKey) {
                List<CacheKey> keys = ((MultiCacheKey)key).getCacheKeys();
                ids = new ArrayList(keys.size());
                for (int i = 0; i < keys.size(); ++i) {
                    ids.add(SecureHashUtil.makeSHA1HashBase64((byte[])keys.get(i).toString().getBytes("UTF-8")));
                }
            } else {
                ids = new ArrayList<String>(1);
                ids.add(SecureHashUtil.makeSHA1HashBase64((byte[])key.toString().getBytes("UTF-8")));
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Params {
        public final long mCacheSizeLimitMinimum;
        public final long mLowDiskSpaceCacheSizeLimit;
        public final long mDefaultCacheSizeLimit;

        public Params(long cacheSizeLimitMinimum, long lowDiskSpaceCacheSizeLimit, long defaultCacheSizeLimit) {
            this.mCacheSizeLimitMinimum = cacheSizeLimitMinimum;
            this.mLowDiskSpaceCacheSizeLimit = lowDiskSpaceCacheSizeLimit;
            this.mDefaultCacheSizeLimit = defaultCacheSizeLimit;
        }
    }

    @VisibleForTesting
    static class CacheStats {
        private boolean mInitialized = false;
        private long mSize = -1L;
        private long mCount = -1L;

        CacheStats() {
        }

        public synchronized boolean isInitialized() {
            return this.mInitialized;
        }

        public synchronized void reset() {
            this.mInitialized = false;
            this.mCount = -1L;
            this.mSize = -1L;
        }

        public synchronized void set(long size, long count) {
            this.mCount = count;
            this.mSize = size;
            this.mInitialized = true;
        }

        public synchronized void increment(long sizeIncrement, long countIncrement) {
            if (this.mInitialized) {
                this.mSize += sizeIncrement;
                this.mCount += countIncrement;
            }
        }

        public synchronized long getSize() {
            return this.mSize;
        }

        public synchronized long getCount() {
            return this.mCount;
        }
    }
}

