/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.debug;

import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.CacheKeyUtil;
import com.facebook.fresco.ui.common.ImageLoadStatus;
import com.facebook.fresco.ui.common.ImagePerfData;
import com.facebook.fresco.ui.common.ImagePerfDataListener;
import com.facebook.fresco.ui.common.VisibilityState;
import com.facebook.imagepipeline.debug.DebugImageTracker;
import com.facebook.imagepipeline.debug.LruMap;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u001a\u0010\u001e\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u001c\u0010\"\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/imagepipeline/debug/FlipperImageTracker;", "Lcom/facebook/imagepipeline/debug/DebugImageTracker;", "Lcom/facebook/fresco/ui/common/ImagePerfDataListener;", "()V", "imageDebugDataMap", "", "Lcom/facebook/cache/common/CacheKey;", "Lcom/facebook/imagepipeline/debug/FlipperImageTracker$ImageDebugData;", "imageRequestDebugDataMap", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getCacheKey", "imageId", "", "getDebugDataForRequestId", "requestId", "getDebugDataForResourceId", "resourceId", "getImageDebugData", "key", "getLocalPath", "getUriString", "onImageLoadStatusUpdated", "", "imagePerfData", "Lcom/facebook/fresco/ui/common/ImagePerfData;", "imageLoadStatus", "Lcom/facebook/fresco/ui/common/ImageLoadStatus;", "onImageVisibilityUpdated", "visibilityState", "Lcom/facebook/fresco/ui/common/VisibilityState;", "trackImage", "imageRequest", "cacheKey", "localPath", "trackImageRequest", "ImageDebugData", "flipper_release"})
public final class FlipperImageTracker
implements DebugImageTracker,
ImagePerfDataListener {
    @NotNull
    private final Map<ImageRequest, ImageDebugData> imageRequestDebugDataMap = new LruMap(1000);
    @NotNull
    private final Map<CacheKey, ImageDebugData> imageDebugDataMap = new LruMap(1000);

    @Override
    public synchronized void trackImage(@Nullable ImageRequest imageRequest, @NotNull CacheKey cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        ImageDebugData imageDebugData = this.imageRequestDebugDataMap.get(imageRequest);
        if (imageDebugData == null) {
            imageDebugData = new ImageDebugData(imageRequest, null, 2, null);
            this.imageDebugDataMap.put(cacheKey, imageDebugData);
            this.imageRequestDebugDataMap.put(imageRequest, imageDebugData);
        }
        imageDebugData.addCacheKey(cacheKey);
        imageDebugData.addResourceId(CacheKeyUtil.getFirstResourceId((CacheKey)cacheKey));
    }

    @Override
    public synchronized void trackImageRequest(@Nullable ImageRequest imageRequest, @Nullable String requestId) {
        ImageDebugData imageDebugData = this.imageRequestDebugDataMap.get(imageRequest);
        if (imageDebugData == null) {
            imageDebugData = new ImageDebugData(imageRequest, null, 2, null);
            this.imageRequestDebugDataMap.put(imageRequest, imageDebugData);
        }
        imageDebugData.addRequestId(requestId);
    }

    @NotNull
    public final synchronized ImageDebugData trackImage(@Nullable String localPath, @NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ImageDebugData data = new ImageDebugData(localPath);
        this.imageDebugDataMap.put(key, data);
        return data;
    }

    @NotNull
    public final synchronized ImageDebugData trackImage(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ImageDebugData data = new ImageDebugData(null, null, 3, null);
        this.imageDebugDataMap.put(key, data);
        return data;
    }

    @NotNull
    public final synchronized String getUriString(@NotNull CacheKey key) {
        ImageRequest imageRequest;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ImageDebugData imageDebugData = this.getImageDebugData(key);
        if (imageDebugData != null && (imageRequest = imageDebugData.getImageRequest()) != null) {
            String string = imageRequest.getSourceUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"imageRequest.sourceUri.toString()");
            return string;
        }
        String string = key.getUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.uriString");
        return string;
    }

    @Nullable
    public final synchronized String getLocalPath(@NotNull CacheKey key) {
        ImageDebugData imageDebugData;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ImageDebugData imageDebugData2 = imageDebugData = this.getImageDebugData(key);
        return imageDebugData2 != null ? imageDebugData2.getLocalPath() : null;
    }

    @Nullable
    public final synchronized ImageDebugData getImageDebugData(@NotNull CacheKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.imageDebugDataMap.get(key);
    }

    @Nullable
    public final synchronized ImageDebugData getDebugDataForRequestId(@Nullable String requestId) {
        for (ImageDebugData debugData : this.imageRequestDebugDataMap.values()) {
            Set<String> requestIds = debugData.getRequestIds();
            if (requestIds == null || !requestIds.contains(requestId)) continue;
            return debugData;
        }
        return null;
    }

    @Nullable
    public final synchronized ImageDebugData getDebugDataForResourceId(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        for (ImageDebugData debugData : this.imageRequestDebugDataMap.values()) {
            Set<String> ids = debugData.getResourceIds();
            if (ids == null || !ids.contains(resourceId)) continue;
            return debugData;
        }
        return null;
    }

    @Nullable
    public final synchronized CacheKey getCacheKey(@NotNull String imageId) {
        Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
        for (Map.Entry<CacheKey, ImageDebugData> entry : this.imageDebugDataMap.entrySet()) {
            CacheKey key = entry.getKey();
            ImageDebugData value = entry.getValue();
            if (!Intrinsics.areEqual((Object)value.getUniqueId(), (Object)imageId)) continue;
            return key;
        }
        return null;
    }

    public synchronized void onImageLoadStatusUpdated(@NotNull ImagePerfData imagePerfData, @NotNull ImageLoadStatus imageLoadStatus) {
        Intrinsics.checkNotNullParameter((Object)imagePerfData, (String)"imagePerfData");
        Intrinsics.checkNotNullParameter((Object)imageLoadStatus, (String)"imageLoadStatus");
        if (imagePerfData.getImageRequest() == null) {
            return;
        }
        ImageDebugData debugData = this.imageRequestDebugDataMap.get(imagePerfData.getImageRequest());
        if (debugData != null) {
            debugData.setImagePerfData(imagePerfData);
        } else {
            Object object = imagePerfData.getImageRequest();
            ImageRequest imageRequest = object instanceof ImageRequest ? (ImageRequest)object : null;
            ImageDebugData imageDebugData = new ImageDebugData(imageRequest, null, 2, null);
            imageDebugData.setImagePerfData(imagePerfData);
            this.imageRequestDebugDataMap.put(imageRequest, imageDebugData);
        }
    }

    public synchronized void onImageVisibilityUpdated(@NotNull ImagePerfData imagePerfData, @NotNull VisibilityState visibilityState) {
        Intrinsics.checkNotNullParameter((Object)imagePerfData, (String)"imagePerfData");
        Intrinsics.checkNotNullParameter((Object)visibilityState, (String)"visibilityState");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0007\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nJ\u0010\u0010$\u001a\u00020\"2\b\u0010%\u001a\u0004\u0018\u00010\u0003J\u0010\u0010&\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\u0003R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0019\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001a\u00a8\u0006("}, d2={"Lcom/facebook/imagepipeline/debug/FlipperImageTracker$ImageDebugData;", "", "localPath", "", "(Ljava/lang/String;)V", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "(Lcom/facebook/imagepipeline/request/ImageRequest;Ljava/lang/String;)V", "_cacheKeys", "", "Lcom/facebook/cache/common/CacheKey;", "_requestIds", "_resourceIds", "cacheKeys", "", "getCacheKeys", "()Ljava/util/Set;", "imagePerfData", "Lcom/facebook/fresco/ui/common/ImagePerfData;", "getImagePerfData", "()Lcom/facebook/fresco/ui/common/ImagePerfData;", "setImagePerfData", "(Lcom/facebook/fresco/ui/common/ImagePerfData;)V", "getImageRequest", "()Lcom/facebook/imagepipeline/request/ImageRequest;", "getLocalPath", "()Ljava/lang/String;", "requestIds", "getRequestIds", "resourceIds", "getResourceIds", "uniqueId", "getUniqueId", "addCacheKey", "", "cacheKey", "addRequestId", "requestId", "addResourceId", "resourceId", "flipper_release"})
    public static final class ImageDebugData {
        @Nullable
        private final ImageRequest imageRequest;
        @Nullable
        private final String localPath;
        @Nullable
        private ImagePerfData imagePerfData;
        @Nullable
        private Set<CacheKey> _cacheKeys;
        @Nullable
        private Set<String> _requestIds;
        @Nullable
        private Set<String> _resourceIds;

        @JvmOverloads
        public ImageDebugData(@Nullable ImageRequest imageRequest, @Nullable String localPath) {
            this.imageRequest = imageRequest;
            this.localPath = localPath;
        }

        public /* synthetic */ ImageDebugData(ImageRequest imageRequest, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                imageRequest = null;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            this(imageRequest, string);
        }

        @Nullable
        public final ImageRequest getImageRequest() {
            return this.imageRequest;
        }

        @Nullable
        public final String getLocalPath() {
            return this.localPath;
        }

        @Nullable
        public final ImagePerfData getImagePerfData() {
            return this.imagePerfData;
        }

        public final void setImagePerfData(@Nullable ImagePerfData imagePerfData) {
            this.imagePerfData = imagePerfData;
        }

        public ImageDebugData(@Nullable String localPath) {
            this(null, localPath);
        }

        @Nullable
        public final Set<CacheKey> getCacheKeys() {
            return this._cacheKeys;
        }

        public final void addCacheKey(@NotNull CacheKey cacheKey) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
                if (this._cacheKeys == null) {
                    this._cacheKeys = new HashSet();
                }
                Set<CacheKey> set = this._cacheKeys;
                if (set == null) break block1;
                set.add(cacheKey);
            }
        }

        @Nullable
        public final Set<String> getRequestIds() {
            return this._requestIds;
        }

        @NotNull
        public final String getUniqueId() {
            return String.valueOf(this.hashCode());
        }

        public final void addRequestId(@Nullable String requestId) {
            block1: {
                if (this._requestIds == null) {
                    this._requestIds = new HashSet();
                }
                Set<String> set = this._requestIds;
                if (set == null) break block1;
                set.add(requestId);
            }
        }

        public final void addResourceId(@Nullable String resourceId) {
            block2: {
                if (resourceId == null) {
                    return;
                }
                if (this._resourceIds == null) {
                    this._resourceIds = new HashSet();
                }
                Set<String> set = this._resourceIds;
                if (set == null) break block2;
                set.add(resourceId);
            }
        }

        @Nullable
        public final Set<String> getResourceIds() {
            return this._resourceIds;
        }

        @JvmOverloads
        public ImageDebugData(@Nullable ImageRequest imageRequest) {
            this(imageRequest, null, 2, null);
        }

        @JvmOverloads
        public ImageDebugData() {
            this(null, null, 3, null);
        }
    }
}

