/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.controller;

import android.graphics.drawable.Animatable;
import android.util.Log;
import com.facebook.drawee.controller.ControllerListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ForwardingControllerListener<INFO>
implements ControllerListener<INFO> {
    private static final String TAG = "FdingControllerListener";
    private final List<ControllerListener<? super INFO>> mListeners = new ArrayList<ControllerListener<? super INFO>>(2);

    public static <INFO> ForwardingControllerListener<INFO> create() {
        return new ForwardingControllerListener<INFO>();
    }

    public static <INFO> ForwardingControllerListener<INFO> of(ControllerListener<? super INFO> listener) {
        ForwardingControllerListener<? super INFO> forwarder = ForwardingControllerListener.create();
        forwarder.addListener(listener);
        return forwarder;
    }

    public static <INFO> ForwardingControllerListener<INFO> of(ControllerListener<? super INFO> listener1, ControllerListener<? super INFO> listener2) {
        ForwardingControllerListener<Object> forwarder = ForwardingControllerListener.create();
        forwarder.addListener(listener1);
        forwarder.addListener(listener2);
        return forwarder;
    }

    public synchronized void addListener(ControllerListener<? super INFO> listener) {
        this.mListeners.add(listener);
    }

    public synchronized void removeListener(ControllerListener<? super INFO> listener) {
        int index = this.mListeners.indexOf(listener);
        if (index != -1) {
            this.mListeners.set(index, null);
        }
    }

    public synchronized void clearListeners() {
        this.mListeners.clear();
    }

    private synchronized void onException(String message, Throwable t) {
        Log.e((String)TAG, (String)message, (Throwable)t);
    }

    @Override
    public synchronized void onSubmit(String id, Object callerContext) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onSubmit(id, callerContext);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onSubmit", exception);
            }
        }
    }

    @Override
    public synchronized void onFinalImageSet(String id, @Nullable INFO imageInfo, @Nullable Animatable animatable) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onFinalImageSet(id, imageInfo, animatable);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onFinalImageSet", exception);
            }
        }
    }

    @Override
    public void onIntermediateImageSet(String id, @Nullable INFO imageInfo) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onIntermediateImageSet(id, imageInfo);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onIntermediateImageSet", exception);
            }
        }
    }

    @Override
    public void onIntermediateImageFailed(String id, Throwable throwable) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onIntermediateImageFailed(id, throwable);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onIntermediateImageFailed", exception);
            }
        }
    }

    @Override
    public synchronized void onFailure(String id, Throwable throwable) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onFailure(id, throwable);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onFailure", exception);
            }
        }
    }

    @Override
    public synchronized void onRelease(String id) {
        int numberOfListeners = this.mListeners.size();
        for (int i = 0; i < numberOfListeners; ++i) {
            try {
                ControllerListener<INFO> listener = this.mListeners.get(i);
                if (listener == null) continue;
                listener.onRelease(id);
                continue;
            }
            catch (Exception exception) {
                this.onException("InternalListener exception in onRelease", exception);
            }
        }
    }
}

