/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.webp;

import android.graphics.Bitmap;
import com.facebook.animated.webp.WebPFrame;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.factory.AnimatedImageDecoder;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.nativecode.StaticWebpNativeLoader;
import com.facebook.infer.annotation.Nullsafe;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
@DoNotStrip
public class WebPImage
implements AnimatedImage,
AnimatedImageDecoder {
    @DoNotStrip
    private long mNativeContext;
    @Nullable
    private Bitmap.Config mDecodeBitmapConfig = null;

    @DoNotStrip
    public WebPImage() {
    }

    @DoNotStrip
    WebPImage(long nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public static WebPImage createFromByteArray(byte[] source, @Nullable ImageDecodeOptions options) {
        StaticWebpNativeLoader.ensure();
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        WebPImage image = WebPImage.nativeCreateFromDirectByteBuffer(byteBuffer);
        if (options != null) {
            image.mDecodeBitmapConfig = options.animatedBitmapConfig;
        }
        return image;
    }

    public static WebPImage createFromByteBuffer(ByteBuffer byteBuffer, @Nullable ImageDecodeOptions options) {
        StaticWebpNativeLoader.ensure();
        byteBuffer.rewind();
        WebPImage image = WebPImage.nativeCreateFromDirectByteBuffer(byteBuffer);
        if (options != null) {
            image.mDecodeBitmapConfig = options.animatedBitmapConfig;
        }
        return image;
    }

    public static WebPImage createFromNativeMemory(long nativePtr, int sizeInBytes, @Nullable ImageDecodeOptions options) {
        StaticWebpNativeLoader.ensure();
        Preconditions.checkArgument((Boolean)(nativePtr != 0L ? 1 : 0));
        WebPImage image = WebPImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes);
        if (options != null) {
            image.mDecodeBitmapConfig = options.animatedBitmapConfig;
        }
        return image;
    }

    public AnimatedImage decodeFromNativeMemory(long nativePtr, int sizeInBytes, ImageDecodeOptions options) {
        return WebPImage.createFromNativeMemory(nativePtr, sizeInBytes, options);
    }

    public AnimatedImage decodeFromByteBuffer(ByteBuffer byteBuffer, ImageDecodeOptions options) {
        return WebPImage.createFromByteBuffer(byteBuffer, options);
    }

    public int getWidth() {
        return this.nativeGetWidth();
    }

    public int getHeight() {
        return this.nativeGetHeight();
    }

    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    public int getDuration() {
        return this.nativeGetDuration();
    }

    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    public int getLoopCount() {
        return this.nativeGetLoopCount();
    }

    public WebPFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    public boolean doesRenderSupportScaling() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        WebPFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), frame.isBlendWithPreviousFrame() ? AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS : AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND, frame.shouldDisposeToBackgroundColor() ? AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND : AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT);
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    @Nullable
    public Bitmap.Config getAnimatedBitmapConfig() {
        return this.mDecodeBitmapConfig;
    }

    private static native WebPImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    private static native WebPImage nativeCreateFromNativeMemory(long var0, int var2);

    private native int nativeGetWidth();

    private native int nativeGetHeight();

    private native int nativeGetDuration();

    private native int nativeGetFrameCount();

    private native int[] nativeGetFrameDurations();

    private native int nativeGetLoopCount();

    private native WebPFrame nativeGetFrame(int var1);

    private native int nativeGetSizeInBytes();

    private native void nativeDispose();

    private native void nativeFinalize();
}

