/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.gif;

import android.graphics.Bitmap;
import com.facebook.animated.gif.GifFrame;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.factory.AnimatedImageDecoder;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.soloader.nativeloader.NativeLoader;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
@DoNotStrip
public class GifImage
implements AnimatedImage,
AnimatedImageDecoder {
    private static final int LOOP_COUNT_FOREVER = 0;
    private static final int LOOP_COUNT_MISSING = -1;
    private static volatile boolean sInitialized;
    @DoNotStrip
    private long mNativeContext;
    @Nullable
    private Bitmap.Config mDecodeBitmapConfig = null;

    private static synchronized void ensure() {
        if (!sInitialized) {
            sInitialized = true;
            NativeLoader.loadLibrary((String)"gifimage");
        }
    }

    public static GifImage createFromByteArray(byte[] source) {
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return GifImage.createFromByteBuffer(byteBuffer, ImageDecodeOptions.defaults());
    }

    public static GifImage createFromByteBuffer(ByteBuffer byteBuffer) {
        return GifImage.createFromByteBuffer(byteBuffer, ImageDecodeOptions.defaults());
    }

    public static GifImage createFromByteBuffer(ByteBuffer byteBuffer, ImageDecodeOptions options) {
        GifImage.ensure();
        byteBuffer.rewind();
        GifImage image = GifImage.nativeCreateFromDirectByteBuffer(byteBuffer, options.maxDimensionPx, options.forceStaticImage);
        image.mDecodeBitmapConfig = options.animatedBitmapConfig;
        return image;
    }

    public static GifImage createFromNativeMemory(long nativePtr, int sizeInBytes, ImageDecodeOptions options) {
        GifImage.ensure();
        Preconditions.checkArgument((Boolean)(nativePtr != 0L ? 1 : 0));
        GifImage image = GifImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes, options.maxDimensionPx, options.forceStaticImage);
        image.mDecodeBitmapConfig = options.animatedBitmapConfig;
        return image;
    }

    public static GifImage createFromFileDescriptor(int fileDescriptor, ImageDecodeOptions options) {
        GifImage.ensure();
        return GifImage.nativeCreateFromFileDescriptor(fileDescriptor, options.maxDimensionPx, options.forceStaticImage);
    }

    public AnimatedImage decodeFromNativeMemory(long nativePtr, int sizeInBytes, ImageDecodeOptions options) {
        return GifImage.createFromNativeMemory(nativePtr, sizeInBytes, options);
    }

    public AnimatedImage decodeFromByteBuffer(ByteBuffer byteBuffer, ImageDecodeOptions options) {
        return GifImage.createFromByteBuffer(byteBuffer, options);
    }

    @DoNotStrip
    public GifImage() {
    }

    @DoNotStrip
    GifImage(long nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public int getWidth() {
        return this.nativeGetWidth();
    }

    public int getHeight() {
        return this.nativeGetHeight();
    }

    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    public int getDuration() {
        return this.nativeGetDuration();
    }

    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    public int getLoopCount() {
        int loopCount = this.nativeGetLoopCount();
        switch (loopCount) {
            case 0: {
                return 0;
            }
            case -1: {
                return 1;
            }
        }
        return loopCount + 1;
    }

    public GifFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    public boolean doesRenderSupportScaling() {
        return false;
    }

    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    public boolean isAnimated() {
        return this.nativeIsAnimated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        GifFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS, GifImage.fromGifDisposalMethod(frame.getDisposalMode()));
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    @Nullable
    public Bitmap.Config getAnimatedBitmapConfig() {
        return this.mDecodeBitmapConfig;
    }

    private static AnimatedDrawableFrameInfo.DisposalMethod fromGifDisposalMethod(int disposalMode) {
        if (disposalMode == 0) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 1) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 2) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND;
        }
        if (disposalMode == 3) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS;
        }
        return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
    }

    @DoNotStrip
    private static native GifImage nativeCreateFromDirectByteBuffer(ByteBuffer var0, int var1, boolean var2);

    @DoNotStrip
    private static native GifImage nativeCreateFromNativeMemory(long var0, int var2, int var3, boolean var4);

    @DoNotStrip
    private static native GifImage nativeCreateFromFileDescriptor(int var0, int var1, boolean var2);

    @DoNotStrip
    private native int nativeGetWidth();

    @DoNotStrip
    private native int nativeGetHeight();

    @DoNotStrip
    private native int nativeGetDuration();

    @DoNotStrip
    private native int nativeGetFrameCount();

    @DoNotStrip
    private native int[] nativeGetFrameDurations();

    @DoNotStrip
    private native int nativeGetLoopCount();

    @DoNotStrip
    private native GifFrame nativeGetFrame(int var1);

    @DoNotStrip
    private native int nativeGetSizeInBytes();

    @DoNotStrip
    private native boolean nativeIsAnimated();

    @DoNotStrip
    private native void nativeDispose();

    @DoNotStrip
    private native void nativeFinalize();
}

