/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable;

import com.facebook.common.logging.FLog;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.fresco.animation.frame.FrameScheduler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jh\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2DebugDrawListener;", "Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2$DrawListener;", "<init>", "()V", "lastFrameNumber", "", "skippedFrames", "duplicateFrames", "drawCalls", "onDraw", "", "animatedDrawable", "Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2;", "frameScheduler", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "frameNumberToDraw", "frameDrawn", "", "isAnimationRunning", "animationStartTimeMs", "", "animationTimeMs", "lastFrameAnimationTimeMs", "actualRenderTimeStartMs", "actualRenderTimeEndMs", "startRenderTimeForNextFrameMs", "scheduledRenderTimeForNextFrameMs", "Companion", "animated-drawable_release"})
public final class AnimatedDrawable2DebugDrawListener
implements AnimatedDrawable2.DrawListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int lastFrameNumber = -1;
    private int skippedFrames;
    private int duplicateFrames;
    private int drawCalls;
    @NotNull
    private static final Class<?> TAG = AnimatedDrawable2DebugDrawListener.class;

    @Override
    public void onDraw(@NotNull AnimatedDrawable2 animatedDrawable, @NotNull FrameScheduler frameScheduler, int frameNumberToDraw, boolean frameDrawn, boolean isAnimationRunning, long animationStartTimeMs, long animationTimeMs, long lastFrameAnimationTimeMs, long actualRenderTimeStartMs, long actualRenderTimeEndMs, long startRenderTimeForNextFrameMs, long scheduledRenderTimeForNextFrameMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)animatedDrawable), (String)"animatedDrawable");
        Intrinsics.checkNotNullParameter((Object)frameScheduler, (String)"frameScheduler");
        AnimationBackend animationBackend = animatedDrawable.getAnimationBackend();
        if (animationBackend == null) {
            return;
        }
        int frameCount = animationBackend.getFrameCount();
        long animationTimeDifference = animationTimeMs - lastFrameAnimationTimeMs;
        int n = this.drawCalls;
        this.drawCalls = n + 1;
        int expectedNextFrameNumber = (this.lastFrameNumber + 1) % frameCount;
        if (expectedNextFrameNumber != frameNumberToDraw) {
            if (this.lastFrameNumber == frameNumberToDraw) {
                int n2 = this.duplicateFrames;
                this.duplicateFrames = n2 + 1;
            } else {
                int skippedFrameCount = (frameNumberToDraw - expectedNextFrameNumber) % frameCount;
                if (skippedFrameCount < 0) {
                    skippedFrameCount += frameCount;
                }
                this.skippedFrames += skippedFrameCount;
            }
        }
        this.lastFrameNumber = frameNumberToDraw;
        Object[] objectArray = new Object[]{frameNumberToDraw, frameDrawn, animationTimeMs % frameScheduler.getLoopDurationMs() - frameScheduler.getTargetRenderTimeMs(frameNumberToDraw), actualRenderTimeEndMs - actualRenderTimeStartMs, animationTimeDifference, this.duplicateFrames, this.skippedFrames, this.drawCalls, animationTimeMs, startRenderTimeForNextFrameMs, scheduledRenderTimeForNextFrameMs};
        FLog.d(TAG, (String)"draw: frame: %2d, drawn: %b, delay: %3d ms, rendering: %3d ms, prev: %3d ms ago, duplicates: %3d, skipped: %3d, draw calls: %4d, anim time: %6d ms, next start: %6d ms, next scheduled: %6d ms", (Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2DebugDrawListener$Companion;", "", "<init>", "()V", "TAG", "Ljava/lang/Class;", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

