/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.facebook.common.logging.FLog;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.drawable.AnimationListener;
import com.facebook.fresco.animation.drawable.BaseAnimationListener;
import com.facebook.fresco.animation.frame.DropFramesFrameScheduler;
import com.facebook.fresco.animation.frame.FrameScheduler;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b#\u0018\u0000 W2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002VWB\u0015\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010%\u001a\u00020\u0014H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020\u000bH\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020(2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u0014H\u0016J\u0012\u00103\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u00020\u0014H\u0016J\u0006\u00107\u001a\u00020(J\u000e\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020\u0014J\u000e\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u0014J\u000e\u0010K\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010L\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\rJ\u0010\u0010M\u001a\u00020(2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010N\u001a\u00020(2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020\rH\u0002J\b\u0010Q\u001a\u00020(H\u0002J\b\u0010R\u001a\u00020\rH\u0002J\u0010\u0010S\u001a\u00020\u000b2\u0006\u0010T\u001a\u00020\u0014H\u0014J\b\u0010U\u001a\u00020(H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00108\u001a\u0004\u0018\u00010\u00052\b\u00108\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010\u0007R\u0011\u0010<\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0010R\u0011\u0010>\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010B\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u0010R\u0011\u0010D\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0011\u0010I\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010F\u00a8\u0006X"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "Lcom/facebook/drawable/base/DrawableWithCaches;", "_animationBackend", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "<init>", "(Lcom/facebook/fresco/animation/backend/AnimationBackend;)V", "frameScheduler", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "_isRunning", "", "value", "", "startTimeMs", "getStartTimeMs", "()J", "lastFrameAnimationTimeMs", "expectedRenderTimeMs", "lastDrawnFrameNumber", "", "pausedStartTimeMsDifference", "pausedLastFrameAnimationTimeMsDifference", "pausedLastDrawnFrameNumber", "frameSchedulingDelayMs", "frameSchedulingOffsetMs", "_droppedFrames", "animationListener", "Lcom/facebook/fresco/animation/drawable/AnimationListener;", "drawListener", "Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2$DrawListener;", "animationBackendListener", "Lcom/facebook/fresco/animation/backend/AnimationBackend$Listener;", "drawableProperties", "Lcom/facebook/drawee/drawable/DrawableProperties;", "invalidateRunnable", "Ljava/lang/Runnable;", "getIntrinsicWidth", "getIntrinsicHeight", "start", "", "stop", "isRunning", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "draw", "canvas", "Landroid/graphics/Canvas;", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "preloadAnimation", "animationBackend", "getAnimationBackend", "()Lcom/facebook/fresco/animation/backend/AnimationBackend;", "setAnimationBackend", "droppedFrames", "getDroppedFrames", "isInfiniteAnimation", "()Z", "jumpToFrame", "targetFrameNumber", "loopDurationMs", "getLoopDurationMs", "frameCount", "getFrameCount", "()I", "getFrameDurationMs", "frameNumber", "loopCount", "getLoopCount", "setFrameSchedulingDelayMs", "setFrameSchedulingOffsetMs", "setAnimationListener", "setDrawListener", "scheduleNextFrame", "targetAnimationTimeMs", "onFrameDropped", "now", "onLevelChange", "level", "dropCaches", "DrawListener", "Companion", "animated-drawable_release"})
public final class AnimatedDrawable2
extends Drawable
implements Animatable,
DrawableWithCaches {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AnimationBackend _animationBackend;
    @Nullable
    private FrameScheduler frameScheduler;
    private volatile boolean _isRunning;
    private long startTimeMs;
    private long lastFrameAnimationTimeMs;
    private long expectedRenderTimeMs;
    private int lastDrawnFrameNumber;
    private long pausedStartTimeMsDifference;
    private long pausedLastFrameAnimationTimeMsDifference;
    private int pausedLastDrawnFrameNumber;
    private long frameSchedulingDelayMs;
    private long frameSchedulingOffsetMs;
    private int _droppedFrames;
    @NotNull
    private volatile AnimationListener animationListener;
    @Nullable
    private volatile DrawListener drawListener;
    @NotNull
    private final AnimationBackend.Listener animationBackendListener;
    @Nullable
    private DrawableProperties drawableProperties;
    @NotNull
    private final Runnable invalidateRunnable;
    @NotNull
    private static final Class<?> TAG = AnimatedDrawable2.class;
    @NotNull
    private static final AnimationListener NO_OP_LISTENER = new BaseAnimationListener();
    private static final int DEFAULT_FRAME_SCHEDULING_DELAY_MS = 8;
    private static final int DEFAULT_FRAME_SCHEDULING_OFFSET_MS = 0;

    @JvmOverloads
    public AnimatedDrawable2(@Nullable AnimationBackend _animationBackend) {
        block0: {
            this._animationBackend = _animationBackend;
            this.frameSchedulingDelayMs = 8L;
            this.animationListener = NO_OP_LISTENER;
            this.animationBackendListener = () -> AnimatedDrawable2.animationBackendListener$lambda$0(this);
            this.invalidateRunnable = new Runnable(this){
                final /* synthetic */ AnimatedDrawable2 this$0;
                {
                    this.this$0 = $receiver;
                }

                public void run() {
                    this.this$0.unscheduleSelf(this);
                    this.this$0.invalidateSelf();
                }
            };
            this.frameScheduler = AnimatedDrawable2.Companion.createSchedulerForBackendAndDelayMethod(this._animationBackend);
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block0;
            animationBackend.setAnimationListener(this.animationBackendListener);
        }
    }

    public /* synthetic */ AnimatedDrawable2(AnimationBackend animationBackend, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            animationBackend = null;
        }
        this(animationBackend);
    }

    public final long getStartTimeMs() {
        return this.startTimeMs;
    }

    public int getIntrinsicWidth() {
        AnimationBackend animationBackend = this._animationBackend;
        return animationBackend != null ? animationBackend.getIntrinsicWidth() : super.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        AnimationBackend animationBackend = this._animationBackend;
        return animationBackend != null ? animationBackend.getIntrinsicHeight() : super.getIntrinsicHeight();
    }

    public void start() {
        block3: {
            block2: {
                if (this._isRunning || this._animationBackend == null) break block2;
                AnimationBackend animationBackend = this._animationBackend;
                Intrinsics.checkNotNull((Object)animationBackend);
                if (animationBackend.getFrameCount() > 1) break block3;
            }
            return;
        }
        this._isRunning = true;
        long now = this.now();
        this.expectedRenderTimeMs = this.startTimeMs = now - this.pausedStartTimeMsDifference;
        this.lastFrameAnimationTimeMs = now - this.pausedLastFrameAnimationTimeMsDifference;
        this.lastDrawnFrameNumber = this.pausedLastDrawnFrameNumber;
        this.invalidateSelf();
        this.animationListener.onAnimationStart(this);
    }

    public void stop() {
        if (!this._isRunning) {
            return;
        }
        long now = this.now();
        this.pausedStartTimeMsDifference = now - this.startTimeMs;
        this.pausedLastFrameAnimationTimeMsDifference = now - this.lastFrameAnimationTimeMs;
        this.pausedLastDrawnFrameNumber = this.lastDrawnFrameNumber;
        this._isRunning = false;
        this.expectedRenderTimeMs = this.startTimeMs = 0L;
        this.lastFrameAnimationTimeMs = -1L;
        this.lastDrawnFrameNumber = -1;
        this.unscheduleSelf(this.invalidateRunnable);
        this.animationListener.onAnimationStop(this);
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            super.onBoundsChange(bounds);
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block0;
            animationBackend.setBounds(bounds);
        }
    }

    public void draw(@NotNull Canvas canvas) {
        DrawListener listener;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this._animationBackend == null || this.frameScheduler == null) {
            return;
        }
        long actualRenderTimeStartMs = this.now();
        long animationTimeMs = this._isRunning ? actualRenderTimeStartMs - this.startTimeMs + this.frameSchedulingOffsetMs : (long)Math.max((double)this.lastFrameAnimationTimeMs, 0.0);
        FrameScheduler frameScheduler = this.frameScheduler;
        Intrinsics.checkNotNull((Object)frameScheduler);
        int frameNumberToDraw = frameScheduler.getFrameNumberToRender(animationTimeMs, this.lastFrameAnimationTimeMs);
        switch (frameNumberToDraw) {
            case -1: {
                AnimationBackend animationBackend = this._animationBackend;
                Intrinsics.checkNotNull((Object)animationBackend);
                frameNumberToDraw = animationBackend.getFrameCount() - 1;
                this.animationListener.onAnimationStop(this);
                this._isRunning = false;
                break;
            }
            case 0: {
                if (this.lastDrawnFrameNumber == -1 || actualRenderTimeStartMs < this.expectedRenderTimeMs) break;
                this.animationListener.onAnimationRepeat(this);
            }
        }
        AnimationBackend animationBackend = this._animationBackend;
        Intrinsics.checkNotNull((Object)animationBackend);
        boolean frameDrawn = animationBackend.drawFrame(this, canvas, frameNumberToDraw);
        if (frameDrawn) {
            this.animationListener.onAnimationFrame(this, frameNumberToDraw);
            this.lastDrawnFrameNumber = frameNumberToDraw;
        }
        if (!frameDrawn) {
            this.onFrameDropped();
        }
        long targetRenderTimeForNextFrameMs = -1L;
        long scheduledRenderTimeForNextFrameMs = -1L;
        long actualRenderTimeEnd = this.now();
        if (this._isRunning) {
            FrameScheduler frameScheduler2 = this.frameScheduler;
            Intrinsics.checkNotNull((Object)frameScheduler2);
            targetRenderTimeForNextFrameMs = frameScheduler2.getTargetRenderTimeForNextFrameMs(actualRenderTimeEnd - this.startTimeMs);
            if (targetRenderTimeForNextFrameMs != -1L) {
                scheduledRenderTimeForNextFrameMs = targetRenderTimeForNextFrameMs + this.frameSchedulingDelayMs;
                this.scheduleNextFrame(scheduledRenderTimeForNextFrameMs);
            } else {
                this.animationListener.onAnimationStop(this);
                this._isRunning = false;
            }
        }
        DrawListener drawListener = listener = this.drawListener;
        if (drawListener != null) {
            FrameScheduler frameScheduler3 = this.frameScheduler;
            if (frameScheduler3 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            drawListener.onDraw(this, frameScheduler3, frameNumberToDraw, frameDrawn, this._isRunning, this.startTimeMs, animationTimeMs, this.lastFrameAnimationTimeMs, actualRenderTimeStartMs, actualRenderTimeEnd, targetRenderTimeForNextFrameMs, scheduledRenderTimeForNextFrameMs);
        }
        this.lastFrameAnimationTimeMs = animationTimeMs;
    }

    public void setAlpha(int alpha) {
        block1: {
            if (this.drawableProperties == null) {
                this.drawableProperties = new DrawableProperties();
            }
            DrawableProperties drawableProperties = this.drawableProperties;
            Intrinsics.checkNotNull((Object)drawableProperties);
            drawableProperties.setAlpha(alpha);
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block1;
            animationBackend.setAlpha(alpha);
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        block1: {
            if (this.drawableProperties == null) {
                this.drawableProperties = new DrawableProperties();
            }
            DrawableProperties drawableProperties = this.drawableProperties;
            Intrinsics.checkNotNull((Object)drawableProperties);
            drawableProperties.setColorFilter(colorFilter);
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block1;
            animationBackend.setColorFilter(colorFilter);
        }
    }

    public int getOpacity() {
        return -3;
    }

    public final void preloadAnimation() {
        block0: {
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block0;
            animationBackend.preloadAnimation();
        }
    }

    @Nullable
    public final AnimationBackend getAnimationBackend() {
        return this._animationBackend;
    }

    public final void setAnimationBackend(@Nullable AnimationBackend animationBackend) {
        if (this._animationBackend != null) {
            AnimationBackend animationBackend2 = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend2);
            animationBackend2.setAnimationListener(null);
        }
        this._animationBackend = animationBackend;
        if (this._animationBackend != null) {
            AnimationBackend animationBackend3 = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend3);
            this.frameScheduler = new DropFramesFrameScheduler(animationBackend3);
            AnimationBackend animationBackend4 = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend4);
            animationBackend4.setAnimationListener(this.animationBackendListener);
            AnimationBackend animationBackend5 = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend5);
            animationBackend5.setBounds(this.getBounds());
            DrawableProperties drawableProperties = this.drawableProperties;
            if (drawableProperties != null) {
                drawableProperties.applyTo((Drawable)this);
            }
        }
        this.frameScheduler = AnimatedDrawable2.Companion.createSchedulerForBackendAndDelayMethod(this._animationBackend);
        this.stop();
    }

    public final long getDroppedFrames() {
        return this._droppedFrames;
    }

    public final boolean isInfiniteAnimation() {
        FrameScheduler frameScheduler = this.frameScheduler;
        return frameScheduler != null ? frameScheduler.isInfiniteAnimation() : false;
    }

    public final void jumpToFrame(int targetFrameNumber) {
        if (this._animationBackend == null || this.frameScheduler == null) {
            return;
        }
        FrameScheduler frameScheduler = this.frameScheduler;
        Intrinsics.checkNotNull((Object)frameScheduler);
        this.lastFrameAnimationTimeMs = frameScheduler.getTargetRenderTimeMs(targetFrameNumber);
        this.pausedLastDrawnFrameNumber = targetFrameNumber;
        this.pausedStartTimeMsDifference = 0L;
        this.pausedLastFrameAnimationTimeMsDifference = 0L;
        this.expectedRenderTimeMs = this.startTimeMs = this.now() - this.lastFrameAnimationTimeMs;
        this.invalidateSelf();
    }

    public final long getLoopDurationMs() {
        if (this._animationBackend == null) {
            return 0L;
        }
        if (this.frameScheduler != null) {
            FrameScheduler frameScheduler = this.frameScheduler;
            Intrinsics.checkNotNull((Object)frameScheduler);
            return frameScheduler.getLoopDurationMs();
        }
        int loopDurationMs = 0;
        AnimationBackend animationBackend = this._animationBackend;
        Intrinsics.checkNotNull((Object)animationBackend);
        int n = animationBackend.getFrameCount();
        for (int i = 0; i < n; ++i) {
            AnimationBackend animationBackend2 = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend2);
            loopDurationMs += animationBackend2.getFrameDurationMs(i);
        }
        return loopDurationMs;
    }

    public final int getFrameCount() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            AnimationBackend animationBackend = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend);
            n = animationBackend.getFrameCount();
        }
        return n;
    }

    public final int getFrameDurationMs(int frameNumber) {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            AnimationBackend animationBackend = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend);
            n = animationBackend.getFrameDurationMs(frameNumber);
        }
        return n;
    }

    public final int getLoopCount() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            AnimationBackend animationBackend = this._animationBackend;
            Intrinsics.checkNotNull((Object)animationBackend);
            n = animationBackend.getLoopCount();
        }
        return n;
    }

    public final void setFrameSchedulingDelayMs(long frameSchedulingDelayMs) {
        this.frameSchedulingDelayMs = frameSchedulingDelayMs;
    }

    public final void setFrameSchedulingOffsetMs(long frameSchedulingOffsetMs) {
        this.frameSchedulingOffsetMs = frameSchedulingOffsetMs;
    }

    public final void setAnimationListener(@Nullable AnimationListener animationListener) {
        AnimationListener animationListener2 = animationListener;
        if (animationListener2 == null) {
            animationListener2 = NO_OP_LISTENER;
        }
        this.animationListener = animationListener2;
    }

    public final void setDrawListener(@Nullable DrawListener drawListener) {
        this.drawListener = drawListener;
    }

    private final void scheduleNextFrame(long targetAnimationTimeMs) {
        this.expectedRenderTimeMs = this.startTimeMs + targetAnimationTimeMs;
        this.scheduleSelf(this.invalidateRunnable, this.expectedRenderTimeMs);
    }

    private final void onFrameDropped() {
        int n = this._droppedFrames;
        this._droppedFrames = n + 1;
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"Dropped a frame. Count: %s", (Object)this._droppedFrames);
        }
    }

    private final long now() {
        return SystemClock.uptimeMillis();
    }

    protected boolean onLevelChange(int level) {
        if (this._isRunning) {
            return false;
        }
        if (this.lastFrameAnimationTimeMs != (long)level) {
            this.lastFrameAnimationTimeMs = level;
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public void dropCaches() {
        block0: {
            AnimationBackend animationBackend = this._animationBackend;
            if (animationBackend == null) break block0;
            animationBackend.clear();
        }
    }

    @JvmOverloads
    public AnimatedDrawable2() {
        this(null, 1, null);
    }

    private static final void animationBackendListener$lambda$0(AnimatedDrawable2 this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.animationListener.onAnimationLoaded();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2$Companion;", "", "<init>", "()V", "TAG", "Ljava/lang/Class;", "NO_OP_LISTENER", "Lcom/facebook/fresco/animation/drawable/AnimationListener;", "DEFAULT_FRAME_SCHEDULING_DELAY_MS", "", "DEFAULT_FRAME_SCHEDULING_OFFSET_MS", "createSchedulerForBackendAndDelayMethod", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "animationBackend", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        private final FrameScheduler createSchedulerForBackendAndDelayMethod(AnimationBackend animationBackend) {
            if (animationBackend == null) {
                return null;
            }
            return new DropFramesFrameScheduler(animationBackend);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001Jh\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH&\u00a8\u0006\u0015"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2$DrawListener;", "", "onDraw", "", "animatedDrawable", "Lcom/facebook/fresco/animation/drawable/AnimatedDrawable2;", "frameScheduler", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "frameNumberToDraw", "", "frameDrawn", "", "isAnimationRunning", "animationStartTimeMs", "", "animationTimeMs", "lastFrameAnimationTimeMs", "actualRenderTimeStartMs", "actualRenderTimeEndMs", "startRenderTimeForNextFrameMs", "scheduledRenderTimeForNextFrameMs", "animated-drawable_release"})
    public static interface DrawListener {
        public void onDraw(@NotNull AnimatedDrawable2 var1, @NotNull FrameScheduler var2, int var3, boolean var4, boolean var5, long var6, long var8, long var10, long var12, long var14, long var16, long var18);
    }
}

