/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.backend;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationInformation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 ,*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0002:\u0001,B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u001c\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0012\u0010!\u001a\u00020\u001b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0002H\u0003R\u0012\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010&\u001a\u0004\u0018\u00018\u00002\b\u0010&\u001a\u0004\u0018\u00018\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010\u0005\u00a8\u0006-"}, d2={"Lcom/facebook/fresco/animation/backend/AnimationBackendDelegate;", "T", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "_animationBackend", "<init>", "(Lcom/facebook/fresco/animation/backend/AnimationBackend;)V", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "alpha", "", "colorFilter", "Landroid/graphics/ColorFilter;", "bounds", "Landroid/graphics/Rect;", "getFrameCount", "getFrameDurationMs", "frameNumber", "getLoopDurationMs", "width", "height", "getLoopCount", "drawFrame", "", "parent", "Landroid/graphics/drawable/Drawable;", "canvas", "Landroid/graphics/Canvas;", "setAlpha", "", "setColorFilter", "setBounds", "getSizeInBytes", "clear", "preloadAnimation", "setAnimationListener", "listener", "Lcom/facebook/fresco/animation/backend/AnimationBackend$Listener;", "getIntrinsicWidth", "getIntrinsicHeight", "animationBackend", "getAnimationBackend", "()Lcom/facebook/fresco/animation/backend/AnimationBackend;", "setAnimationBackend", "applyBackendProperties", "backend", "Companion", "animated-drawable_release"})
public class AnimationBackendDelegate<T extends AnimationBackend>
implements AnimationBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private T _animationBackend;
    @IntRange(from=-1L, to=255L)
    private int alpha;
    @Nullable
    private ColorFilter colorFilter;
    @Nullable
    private Rect bounds;
    private static final int ALPHA_UNSET = -1;

    public AnimationBackendDelegate(@Nullable T _animationBackend) {
        this._animationBackend = _animationBackend;
        this.alpha = -1;
    }

    @Override
    public int getFrameCount() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).getFrameCount();
        }
        return n;
    }

    @Override
    public int getFrameDurationMs(int frameNumber) {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).getFrameDurationMs(frameNumber);
        }
        return n;
    }

    @Override
    public int getLoopDurationMs() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).getLoopDurationMs();
        }
        return n;
    }

    @Override
    public int width() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).width();
        }
        return n;
    }

    @Override
    public int height() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).height();
        }
        return n;
    }

    @Override
    public int getLoopCount() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = ((AnimationInformation)t).getLoopCount();
        }
        return n;
    }

    @Override
    public boolean drawFrame(@NotNull Drawable parent, @NotNull Canvas canvas, int frameNumber) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        T t = this._animationBackend;
        return t != null ? t.drawFrame(parent, canvas, frameNumber) : false;
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        T t = this._animationBackend;
        if (t != null) {
            t.setAlpha(alpha);
        }
        this.alpha = alpha;
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        T t = this._animationBackend;
        if (t != null) {
            t.setColorFilter(colorFilter);
        }
        this.colorFilter = colorFilter;
    }

    @Override
    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        T t = this._animationBackend;
        if (t != null) {
            t.setBounds(bounds);
        }
        this.bounds = bounds;
    }

    @Override
    public int getSizeInBytes() {
        int n;
        if (this._animationBackend == null) {
            n = 0;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = t.getSizeInBytes();
        }
        return n;
    }

    @Override
    public void clear() {
        block0: {
            T t = this._animationBackend;
            if (t == null) break block0;
            t.clear();
        }
    }

    @Override
    public void preloadAnimation() {
        block0: {
            T t = this._animationBackend;
            if (t == null) break block0;
            t.preloadAnimation();
        }
    }

    @Override
    public void setAnimationListener(@Nullable AnimationBackend.Listener listener) {
        block0: {
            T t = this._animationBackend;
            if (t == null) break block0;
            t.setAnimationListener(listener);
        }
    }

    @Override
    public int getIntrinsicWidth() {
        int n;
        if (this._animationBackend == null) {
            n = -1;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = t.getIntrinsicWidth();
        }
        return n;
    }

    @Override
    public int getIntrinsicHeight() {
        int n;
        if (this._animationBackend == null) {
            n = -1;
        } else {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            n = t.getIntrinsicHeight();
        }
        return n;
    }

    @Nullable
    public final T getAnimationBackend() {
        return this._animationBackend;
    }

    public final void setAnimationBackend(@Nullable T animationBackend) {
        this._animationBackend = animationBackend;
        if (this._animationBackend != null) {
            T t = this._animationBackend;
            Intrinsics.checkNotNull(t);
            this.applyBackendProperties((AnimationBackend)t);
        }
    }

    @SuppressLint(value={"Range"})
    private final void applyBackendProperties(AnimationBackend backend) {
        if (this.bounds != null) {
            backend.setBounds(this.bounds);
        }
        if (this.alpha >= 0 && this.alpha <= 255) {
            backend.setAlpha(this.alpha);
        }
        if (this.colorFilter != null) {
            backend.setColorFilter(this.colorFilter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/fresco/animation/backend/AnimationBackendDelegate$Companion;", "", "<init>", "()V", "ALPHA_UNSET", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

