/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.drawable.AnimationFrameScheduler;
import com.facebook.fresco.animation.drawable.AnimationListener;
import com.facebook.fresco.animation.drawable.BaseAnimationListener;
import com.facebook.fresco.animation.drawable.KAnimatedDrawable2;
import com.facebook.fresco.animation.frame.DropFramesFrameScheduler;
import com.facebook.fresco.animation.frame.FrameScheduler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0013\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\u0006\u0010%\u001a\u00020\u0018J\u0006\u0010&\u001a\u00020\u0018J\u0006\u0010'\u001a\u00020\u0018J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020*J\u0010\u0010-\u001a\u00020\u00162\b\u0010.\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010/\u001a\u00020\u00162\b\u0010.\u001a\u0004\u0018\u00010\rJ\u0010\u00100\u001a\u00020\u00162\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0010\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u00065"}, d2={"Lcom/facebook/fresco/animation/drawable/KAnimatedDrawable2;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "Lcom/facebook/drawable/base/DrawableWithCaches;", "animationBackend", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "<init>", "(Lcom/facebook/fresco/animation/backend/AnimationBackend;)V", "animatedFrameScheduler", "Lcom/facebook/fresco/animation/drawable/AnimationFrameScheduler;", "animationListener", "Lcom/facebook/fresco/animation/drawable/AnimationListener;", "drawListener", "Lcom/facebook/fresco/animation/drawable/KAnimatedDrawable2$DrawListener;", "drawableProperties", "Lcom/facebook/drawee/drawable/DrawableProperties;", "isRunning", "", "invalidateRunnable", "com/facebook/fresco/animation/drawable/KAnimatedDrawable2$invalidateRunnable$1", "Lcom/facebook/fresco/animation/drawable/KAnimatedDrawable2$invalidateRunnable$1;", "setAlpha", "", "alpha", "", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "start", "stop", "dropCaches", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "getIntrinsicWidth", "getIntrinsicHeight", "loopDurationMs", "getFrameCount", "loopCount", "setFrameSchedulingDelayMs", "delayMs", "", "setFrameSchedulingOffsetMs", "offsetMs", "setAnimationListener", "listener", "setDrawListener", "setAnimationBackend", "draw", "canvas", "Landroid/graphics/Canvas;", "DrawListener", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nKAnimatedDrawable2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KAnimatedDrawable2.kt\ncom/facebook/fresco/animation/drawable/KAnimatedDrawable2\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,222:1\n1#2:223\n*E\n"})
public final class KAnimatedDrawable2
extends Drawable
implements Animatable,
DrawableWithCaches {
    @NotNull
    private AnimationBackend animationBackend;
    @NotNull
    private final AnimationFrameScheduler animatedFrameScheduler;
    @NotNull
    private AnimationListener animationListener;
    @Nullable
    private DrawListener drawListener;
    @NotNull
    private final DrawableProperties drawableProperties;
    private volatile boolean isRunning;
    @NotNull
    private final invalidateRunnable.1 invalidateRunnable;

    /*
     * WARNING - void declaration
     */
    public KAnimatedDrawable2(@NotNull AnimationBackend animationBackend) {
        void $this$drawableProperties_u24lambda_u240;
        DrawableProperties drawableProperties;
        Intrinsics.checkNotNullParameter((Object)animationBackend, (String)"animationBackend");
        this.animationBackend = animationBackend;
        this.animatedFrameScheduler = new AnimationFrameScheduler(new DropFramesFrameScheduler(this.animationBackend));
        this.animationListener = new BaseAnimationListener();
        DrawableProperties drawableProperties2 = drawableProperties = new DrawableProperties();
        KAnimatedDrawable2 kAnimatedDrawable2 = this;
        boolean bl = false;
        $this$drawableProperties_u24lambda_u240.applyTo((Drawable)this);
        kAnimatedDrawable2.drawableProperties = drawableProperties;
        this.invalidateRunnable = new Runnable(this){
            final /* synthetic */ KAnimatedDrawable2 this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                this.this$0.unscheduleSelf(this);
                this.this$0.invalidateSelf();
            }
        };
    }

    public void setAlpha(int alpha) {
        this.drawableProperties.setAlpha(alpha);
        this.animationBackend.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.drawableProperties.setColorFilter(colorFilter);
        this.animationBackend.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void start() {
        if (this.animationBackend.getFrameCount() <= 0) {
            return;
        }
        this.animatedFrameScheduler.start();
        this.animationListener.onAnimationStart(this);
        this.invalidateSelf();
    }

    public void stop() {
        this.animatedFrameScheduler.stop();
        this.animationListener.onAnimationStop(this);
        this.unscheduleSelf(this.invalidateRunnable);
    }

    public boolean isRunning() {
        return this.animatedFrameScheduler.getRunning();
    }

    public void dropCaches() {
        this.animationBackend.clear();
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.animationBackend.setBounds(bounds);
    }

    public int getIntrinsicWidth() {
        return this.animationBackend.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.animationBackend.getIntrinsicHeight();
    }

    public final int loopDurationMs() {
        return this.animationBackend.getLoopDurationMs();
    }

    public final int getFrameCount() {
        return this.animationBackend.getFrameCount();
    }

    public final int loopCount() {
        return this.animationBackend.getLoopCount();
    }

    public final void setFrameSchedulingDelayMs(long delayMs) {
        this.animatedFrameScheduler.setFrameSchedulingDelayMs(delayMs);
    }

    public final void setFrameSchedulingOffsetMs(long offsetMs) {
        this.animatedFrameScheduler.setFrameSchedulingOffsetMs(offsetMs);
    }

    public final void setAnimationListener(@Nullable AnimationListener listener) {
        AnimationListener animationListener = listener;
        if (animationListener == null) {
            animationListener = this.animationListener;
        }
        this.animationListener = animationListener;
    }

    public final void setDrawListener(@Nullable DrawListener listener) {
        this.drawListener = listener;
    }

    public final void setAnimationBackend(@Nullable AnimationBackend animationBackend) {
        if (animationBackend == null) {
            return;
        }
        this.stop();
        animationBackend.setBounds(this.getBounds());
        this.drawableProperties.applyTo((Drawable)this);
        this.animationBackend = animationBackend;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int frameNumber = this.animatedFrameScheduler.frameToDraw();
        if (frameNumber == -1) {
            frameNumber = this.animationBackend.getFrameCount() - 1;
            this.animatedFrameScheduler.setRunning(false);
            this.animationListener.onAnimationStop(this);
        } else if (frameNumber == 0 && this.animatedFrameScheduler.shouldRepeatAnimation()) {
            this.animationListener.onAnimationRepeat(this);
        }
        boolean frameDrawn = this.animationBackend.drawFrame(this, canvas, frameNumber);
        if (frameDrawn) {
            this.animationListener.onAnimationFrame(this, frameNumber);
            this.animatedFrameScheduler.setLastDrawnFrameNumber(frameNumber);
        } else {
            this.animatedFrameScheduler.onFrameDropped();
        }
        long nextFrameTime = this.animatedFrameScheduler.nextRenderTime();
        if (nextFrameTime != -1L) {
            this.scheduleSelf(this.invalidateRunnable, nextFrameTime);
        } else {
            this.animationListener.onAnimationStop(this);
            this.animatedFrameScheduler.setRunning(false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001Jh\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH&\u00a8\u0006\u0015"}, d2={"Lcom/facebook/fresco/animation/drawable/KAnimatedDrawable2$DrawListener;", "", "onDraw", "", "animatedDrawable", "Lcom/facebook/fresco/animation/drawable/KAnimatedDrawable2;", "frameScheduler", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "frameNumberToDraw", "", "frameDrawn", "", "isAnimationRunning", "animationStartTimeMs", "", "animationTimeMs", "lastFrameAnimationTimeMs", "actualRenderTimeStartMs", "actualRenderTimeEndMs", "startRenderTimeForNextFrameMs", "scheduledRenderTimeForNextFrameMs", "animated-drawable_release"})
    public static interface DrawListener {
        public void onDraw(@NotNull KAnimatedDrawable2 var1, @NotNull FrameScheduler var2, int var3, boolean var4, boolean var5, long var6, long var8, long var10, long var12, long var14, long var16, long var18);
    }
}

