/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.backend;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.time.MonotonicClock;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationBackendDelegate;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimationBackendDelegateWithInactivityCheck<T extends AnimationBackend>
extends AnimationBackendDelegate<T> {
    @VisibleForTesting
    static final long INACTIVITY_THRESHOLD_MS = 2000L;
    @VisibleForTesting
    static final long INACTIVITY_CHECK_POLLING_TIME_MS = 1000L;
    private final MonotonicClock mMonotonicClock;
    private final ScheduledExecutorService mScheduledExecutorServiceForUiThread;
    private boolean mInactivityCheckScheduled = false;
    private long mLastDrawnTimeMs;
    private long mInactivityThresholdMs = 2000L;
    private long mInactivityCheckPollingTimeMs = 1000L;
    @Nullable
    private InactivityListener mInactivityListener;
    private final Runnable mIsInactiveCheck = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AnimationBackendDelegateWithInactivityCheck animationBackendDelegateWithInactivityCheck = AnimationBackendDelegateWithInactivityCheck.this;
            synchronized (animationBackendDelegateWithInactivityCheck) {
                AnimationBackendDelegateWithInactivityCheck.this.mInactivityCheckScheduled = false;
                if (AnimationBackendDelegateWithInactivityCheck.this.isInactive()) {
                    if (AnimationBackendDelegateWithInactivityCheck.this.mInactivityListener != null) {
                        AnimationBackendDelegateWithInactivityCheck.this.mInactivityListener.onInactive();
                    }
                } else {
                    AnimationBackendDelegateWithInactivityCheck.this.maybeScheduleInactivityCheck();
                }
            }
        }
    };

    public static <T extends AnimationBackend & InactivityListener> AnimationBackendDelegate<T> createForBackend(T backend, MonotonicClock monotonicClock, ScheduledExecutorService scheduledExecutorServiceForUiThread) {
        return AnimationBackendDelegateWithInactivityCheck.createForBackend(backend, backend, monotonicClock, scheduledExecutorServiceForUiThread);
    }

    public static <T extends AnimationBackend> AnimationBackendDelegate<T> createForBackend(T backend, InactivityListener inactivityListener, MonotonicClock monotonicClock, ScheduledExecutorService scheduledExecutorServiceForUiThread) {
        return new AnimationBackendDelegateWithInactivityCheck<T>(backend, inactivityListener, monotonicClock, scheduledExecutorServiceForUiThread);
    }

    private AnimationBackendDelegateWithInactivityCheck(@Nullable T animationBackend, @Nullable InactivityListener inactivityListener, MonotonicClock monotonicClock, ScheduledExecutorService scheduledExecutorServiceForUiThread) {
        super(animationBackend);
        this.mInactivityListener = inactivityListener;
        this.mMonotonicClock = monotonicClock;
        this.mScheduledExecutorServiceForUiThread = scheduledExecutorServiceForUiThread;
    }

    @Override
    public boolean drawFrame(Drawable parent, Canvas canvas, int frameNumber) {
        this.mLastDrawnTimeMs = this.mMonotonicClock.now();
        boolean result = super.drawFrame(parent, canvas, frameNumber);
        this.maybeScheduleInactivityCheck();
        return result;
    }

    public void setInactivityListener(@Nullable InactivityListener inactivityListener) {
        this.mInactivityListener = inactivityListener;
    }

    public long getInactivityCheckPollingTimeMs() {
        return this.mInactivityCheckPollingTimeMs;
    }

    public void setInactivityCheckPollingTimeMs(long inactivityCheckPollingTimeMs) {
        this.mInactivityCheckPollingTimeMs = inactivityCheckPollingTimeMs;
    }

    public long getInactivityThresholdMs() {
        return this.mInactivityThresholdMs;
    }

    public void setInactivityThresholdMs(long inactivityThresholdMs) {
        this.mInactivityThresholdMs = inactivityThresholdMs;
    }

    private boolean isInactive() {
        return this.mMonotonicClock.now() - this.mLastDrawnTimeMs > this.mInactivityThresholdMs;
    }

    private synchronized void maybeScheduleInactivityCheck() {
        if (!this.mInactivityCheckScheduled) {
            this.mInactivityCheckScheduled = true;
            this.mScheduledExecutorServiceForUiThread.schedule(this.mIsInactiveCheck, this.mInactivityCheckPollingTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    public static interface InactivityListener {
        public void onInactive();
    }
}

