/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation;

import android.graphics.Bitmap;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/FixedNumberBitmapFramePreparationStrategy;", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparationStrategy;", "framesToPrepare", "", "(I)V", "TAG", "Ljava/lang/Class;", "prepareFrames", "", "bitmapFramePreparer", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparer;", "bitmapFrameCache", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "animationBackend", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "lastDrawnFrameNumber", "onAnimationLoaded", "Lkotlin/Function0;", "animated-drawable_release"})
public final class FixedNumberBitmapFramePreparationStrategy
implements BitmapFramePreparationStrategy {
    private final int framesToPrepare;
    @NotNull
    private final Class<FixedNumberBitmapFramePreparationStrategy> TAG;

    @JvmOverloads
    public FixedNumberBitmapFramePreparationStrategy(int framesToPrepare) {
        this.framesToPrepare = framesToPrepare;
        this.TAG = FixedNumberBitmapFramePreparationStrategy.class;
    }

    public /* synthetic */ FixedNumberBitmapFramePreparationStrategy(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        this(n);
    }

    @Override
    public void prepareFrames(@NotNull BitmapFramePreparer bitmapFramePreparer, @NotNull BitmapFrameCache bitmapFrameCache, @NotNull AnimationBackend animationBackend, int lastDrawnFrameNumber, @Nullable Function0<Unit> onAnimationLoaded) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)bitmapFramePreparer, (String)"bitmapFramePreparer");
            Intrinsics.checkNotNullParameter((Object)bitmapFrameCache, (String)"bitmapFrameCache");
            Intrinsics.checkNotNullParameter((Object)animationBackend, (String)"animationBackend");
            int i = 1;
            int n = this.framesToPrepare;
            if (i <= n) {
                while (true) {
                    int nextFrameNumber = (lastDrawnFrameNumber + i) % animationBackend.getFrameCount();
                    if (FLog.isLoggable((int)2)) {
                        FLog.v(this.TAG, (String)"Preparing frame %d, last drawn: %d", (Object)nextFrameNumber, (Object)lastDrawnFrameNumber);
                    }
                    if (!bitmapFramePreparer.prepareFrame(bitmapFrameCache, animationBackend, nextFrameNumber)) {
                        return;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            Function0<Unit> function0 = onAnimationLoaded;
            if (function0 == null) break block4;
            function0.invoke();
        }
    }

    @Override
    public void prepareFrames(int canvasWidth, int canvasHeight, @Nullable Function0<Unit> onAnimationLoaded) {
        BitmapFramePreparationStrategy.DefaultImpls.prepareFrames(this, canvasWidth, canvasHeight, onAnimationLoaded);
    }

    @Override
    public void onStop() {
        BitmapFramePreparationStrategy.DefaultImpls.onStop(this);
    }

    @Override
    public void clearFrames() {
        BitmapFramePreparationStrategy.DefaultImpls.clearFrames(this);
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> getBitmapFrame(int frameNumber, int canvasWidth, int canvasHeight) {
        return BitmapFramePreparationStrategy.DefaultImpls.getBitmapFrame(this, frameNumber, canvasWidth, canvasHeight);
    }

    @JvmOverloads
    public FixedNumberBitmapFramePreparationStrategy() {
        this(0, 1, null);
    }
}

