/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation;

import android.graphics.Bitmap;
import android.os.SystemClock;
import androidx.annotation.UiThread;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.preparation.BalancedAnimationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.OnDemandFrame;
import com.facebook.fresco.animation.bitmap.preparation.Size;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.AnimationLoaderExecutor;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFrameOutput;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFrameTask;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFrameTaskFactory;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadOnDemandFrameTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0017\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010(\u001a\u00020\u0005H\u0003\u00a2\u0006\u0002\u0010)J(\u0010*\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0017J\b\u0010,\u001a\u00020\u000bH\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0005H\u0002J \u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001e2\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u000102H\u0002J\b\u00103\u001a\u00020\"H\u0016J(\u00104\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u000e\u00105\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u000102H\u0017J\u0010\u00106\u001a\u00020\"2\u0006\u00107\u001a\u00020\u0005H\u0002R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/BalancedAnimationStrategy;", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparationStrategy;", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "onDemandPreparationMs", "", "loadFrameTaskFactory", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTaskFactory;", "bitmapCache", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "downscaleFrameToDrawableDimensions", "", "(Lcom/facebook/fresco/animation/backend/AnimationInformation;ILcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTaskFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;Z)V", "animationHeight", "animationWidth", "fetchingFrames", "Ljava/util/concurrent/atomic/AtomicBoolean;", "fetchingOnDemand", "frameCount", "framesCached", "getFramesCached", "()Z", "nextPrepareFrames", "", "onDemandBitmap", "Lcom/facebook/fresco/animation/bitmap/preparation/OnDemandFrame;", "onDemandFrames", "Ljava/util/SortedSet;", "onDemandRatio", "calculateFrameSize", "Lcom/facebook/fresco/animation/bitmap/preparation/Size;", "canvasWidth", "canvasHeight", "clearFrames", "", "findNearestFrame", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "fromFrame", "findNextOnDemandFrame", "from", "(I)Ljava/lang/Integer;", "getBitmapFrame", "frameNumber", "isFirstFrameReady", "isOnDemandFrame", "loadAllFrames", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask;", "frameSize", "notifyOnLoad", "Lkotlin/Function0;", "onStop", "prepareFrames", "onAnimationLoaded", "prepareNextOnDemandFrame", "lastFrameRendered", "Companion", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nBalancedAnimationStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalancedAnimationStrategy.kt\ncom/facebook/fresco/animation/bitmap/preparation/BalancedAnimationStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n288#2,2:271\n*S KotlinDebug\n*F\n+ 1 BalancedAnimationStrategy.kt\ncom/facebook/fresco/animation/bitmap/preparation/BalancedAnimationStrategy\n*L\n228#1:271,2\n*E\n"})
public final class BalancedAnimationStrategy
implements BitmapFramePreparationStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadFrameTaskFactory loadFrameTaskFactory;
    @NotNull
    private final BitmapFrameCache bitmapCache;
    private final boolean downscaleFrameToDrawableDimensions;
    @NotNull
    private final AtomicBoolean fetchingFrames;
    @NotNull
    private final AtomicBoolean fetchingOnDemand;
    @NotNull
    private final SortedSet<Integer> onDemandFrames;
    private long nextPrepareFrames;
    private final int frameCount;
    private final int animationWidth;
    private final int animationHeight;
    private final int onDemandRatio;
    @Nullable
    private OnDemandFrame onDemandBitmap;
    private static final int FETCH_FIRST_CACHE_DELAY_MS = 500;
    private static final long FETCH_FULL_ANIMATION_CACHE_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);

    public BalancedAnimationStrategy(@NotNull AnimationInformation animationInformation, int onDemandPreparationMs, @NotNull LoadFrameTaskFactory loadFrameTaskFactory, @NotNull BitmapFrameCache bitmapCache, boolean downscaleFrameToDrawableDimensions) {
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        Intrinsics.checkNotNullParameter((Object)loadFrameTaskFactory, (String)"loadFrameTaskFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapCache, (String)"bitmapCache");
        this.loadFrameTaskFactory = loadFrameTaskFactory;
        this.bitmapCache = bitmapCache;
        this.downscaleFrameToDrawableDimensions = downscaleFrameToDrawableDimensions;
        this.fetchingFrames = new AtomicBoolean(false);
        this.fetchingOnDemand = new AtomicBoolean(false);
        this.onDemandFrames = SetsKt.sortedSetOf((Object[])new Integer[0]);
        this.nextPrepareFrames = SystemClock.uptimeMillis();
        this.frameCount = animationInformation.getFrameCount();
        this.animationWidth = animationInformation.width();
        this.animationHeight = animationInformation.height();
        int avgFrameDurationMs = animationInformation.getLoopDurationMs() / this.frameCount;
        int optimisticRatio = (int)Math.ceil((float)onDemandPreparationMs / (float)avgFrameDurationMs);
        this.onDemandRatio = RangesKt.coerceAtLeast((int)optimisticRatio, (int)2);
    }

    private final boolean getFramesCached() {
        return this.bitmapCache.isAnimationReady();
    }

    private final boolean isFirstFrameReady() {
        CloseableReference<Bitmap> closeableReference = this.bitmapCache.getCachedFrame(0);
        return closeableReference != null ? closeableReference.isValid() : false;
    }

    @Override
    @UiThread
    public void prepareFrames(int canvasWidth, int canvasHeight, @Nullable Function0<Unit> onAnimationLoaded) {
        if (canvasWidth <= 0 || canvasHeight <= 0 || this.animationWidth <= 0 || this.animationHeight <= 0) {
            return;
        }
        if (this.getFramesCached() || this.fetchingFrames.get() || SystemClock.uptimeMillis() < this.nextPrepareFrames) {
            if (this.getFramesCached()) {
                Function0<Unit> function0 = onAnimationLoaded;
                if (function0 != null) {
                    function0.invoke();
                }
            }
            return;
        }
        this.fetchingFrames.set(true);
        Size frameSize = this.calculateFrameSize(canvasWidth, canvasHeight);
        LoadFrameTask task2 = !this.isFirstFrameReady() ? this.loadFrameTaskFactory.createFirstFrameTask(frameSize.getWidth(), frameSize.getHeight(), new LoadFrameOutput(this, frameSize, onAnimationLoaded){
            final /* synthetic */ BalancedAnimationStrategy this$0;
            final /* synthetic */ Size $frameSize;
            final /* synthetic */ Function0<Unit> $onAnimationLoaded;
            {
                this.this$0 = $receiver;
                this.$frameSize = $frameSize;
                this.$onAnimationLoaded = $onAnimationLoaded;
            }

            public void onSuccess(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                boolean cachedSucceed = BalancedAnimationStrategy.access$getBitmapCache$p(this.this$0).onAnimationPrepared(frames);
                if (!cachedSucceed) {
                    BalancedAnimationStrategy.access$setNextPrepareFrames$p(this.this$0, SystemClock.uptimeMillis() + (long)BalancedAnimationStrategy.access$getFETCH_FIRST_CACHE_DELAY_MS$cp());
                }
                AnimationLoaderExecutor.INSTANCE.execute(BalancedAnimationStrategy.access$loadAllFrames(this.this$0, this.$frameSize, this.$onAnimationLoaded));
            }

            public void onFail() {
                BalancedAnimationStrategy.access$getBitmapCache$p(this.this$0).clear();
                BalancedAnimationStrategy.access$getFetchingFrames$p(this.this$0).set(false);
            }
        }) : this.loadAllFrames(frameSize, onAnimationLoaded);
        AnimationLoaderExecutor.INSTANCE.execute(task2);
    }

    private final LoadFrameTask loadAllFrames(Size frameSize, Function0<Unit> notifyOnLoad) {
        return this.loadFrameTaskFactory.createLoadFullAnimationTask(frameSize.getWidth(), frameSize.getHeight(), this.frameCount, new LoadFrameOutput(this, notifyOnLoad){
            final /* synthetic */ BalancedAnimationStrategy this$0;
            final /* synthetic */ Function0<Unit> $notifyOnLoad;
            {
                this.this$0 = $receiver;
                this.$notifyOnLoad = $notifyOnLoad;
            }

            /*
             * WARNING - void declaration
             */
            public void onSuccess(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frames) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map.Entry<K, V> element$iv$iv;
                void $this$filterTo$iv$iv2;
                Map $this$filter$iv2;
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                BalancedAnimationStrategy.access$getOnDemandFrames$p(this.this$0).clear();
                Map<Integer, ? extends CloseableReference<Bitmap>> map = frames;
                BalancedAnimationStrategy balancedAnimationStrategy = this.this$0;
                SortedSet sortedSet = BalancedAnimationStrategy.access$getOnDemandFrames$p(this.this$0);
                boolean $i$f$filter22 = false;
                void var5_10 = $this$filter$iv2;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> it = element$iv$iv = iterator.next();
                    boolean bl = false;
                    if (!BalancedAnimationStrategy.access$isOnDemandFrame(balancedAnimationStrategy, ((Number)it.getKey()).intValue())) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv2 = destination$iv$iv;
                boolean $i$f$map22 = false;
                void $i$f$filter22 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo22 = false;
                for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    void it;
                    element$iv$iv = item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Number)it.getKey()).intValue());
                }
                sortedSet.addAll((List)destination$iv$iv2);
                Map<Integer, ? extends CloseableReference<Bitmap>> $i$f$map22 = frames;
                BalancedAnimationStrategy balancedAnimationStrategy2 = this.this$0;
                boolean $i$f$filter = false;
                void $i$f$mapTo22 = $this$filter$iv;
                Map destination$iv$iv3 = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo2 = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv$iv2;
                    Map.Entry<K, V> it = element$iv$iv2 = iterator2.next();
                    boolean bl = false;
                    if (!(!BalancedAnimationStrategy.access$getOnDemandFrames$p(balancedAnimationStrategy2).contains(it.getKey()))) continue;
                    destination$iv$iv3.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
                }
                Map memoryFrames = destination$iv$iv3;
                boolean cachedSucceed = BalancedAnimationStrategy.access$getBitmapCache$p(this.this$0).onAnimationPrepared(memoryFrames);
                if (!cachedSucceed) {
                    BalancedAnimationStrategy.access$setNextPrepareFrames$p(this.this$0, SystemClock.uptimeMillis() + BalancedAnimationStrategy.access$getFETCH_FULL_ANIMATION_CACHE_DELAY_MS$cp());
                }
                Function0<Unit> function0 = this.$notifyOnLoad;
                if (function0 != null) {
                    function0.invoke();
                }
                BalancedAnimationStrategy.access$getFetchingFrames$p(this.this$0).set(false);
            }

            public void onFail() {
                BalancedAnimationStrategy.access$getBitmapCache$p(this.this$0).clear();
                BalancedAnimationStrategy.access$getFetchingFrames$p(this.this$0).set(false);
            }
        });
    }

    @Override
    @UiThread
    @Nullable
    public CloseableReference<Bitmap> getBitmapFrame(int frameNumber, int canvasWidth, int canvasHeight) {
        CloseableReference<Bitmap> cache;
        CloseableReference<Bitmap> closeableReference = cache = this.bitmapCache.getCachedFrame(frameNumber);
        boolean bl = closeableReference != null ? closeableReference.isValid() : false;
        if (bl) {
            this.prepareNextOnDemandFrame(frameNumber);
            return cache;
        }
        if (!this.isOnDemandFrame(frameNumber)) {
            this.prepareFrames(canvasWidth, canvasHeight, (Function0<Unit>)((Function0)getBitmapFrame.1.INSTANCE));
        }
        OnDemandFrame onDemandFrame = this.onDemandBitmap;
        boolean bl2 = onDemandFrame != null ? onDemandFrame.isValidFor(frameNumber) : false;
        if (bl2) {
            OnDemandFrame onDemandFrame2 = this.onDemandBitmap;
            return onDemandFrame2 != null ? onDemandFrame2.getBitmap() : null;
        }
        return this.findNearestFrame(frameNumber);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void prepareNextOnDemandFrame(int lastFrameRendered) {
        if (this.fetchingOnDemand.getAndSet(true)) {
            return;
        }
        Integer nextFrame = this.findNextOnDemandFrame(lastFrameRendered);
        if (nextFrame != null) {
            OnDemandFrame onDemandFrame = this.onDemandBitmap;
            if (!(onDemandFrame != null ? onDemandFrame.isValidFor(nextFrame) : false)) {
                LoadOnDemandFrameTask onDemandTask2 = this.loadFrameTaskFactory.createOnDemandTask(nextFrame, (Function1<? super Integer, ? extends CloseableReference<Bitmap>>)((Function1)new Function1<Integer, CloseableReference<Bitmap>>(this){
                    final /* synthetic */ BalancedAnimationStrategy this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final CloseableReference<Bitmap> invoke(int it) {
                        return BalancedAnimationStrategy.access$getBitmapCache$p(this.this$0).getCachedFrame(it);
                    }
                }), (Function1<? super CloseableReference<Bitmap>, Unit>)((Function1)new Function1<CloseableReference<Bitmap>, Unit>(this, nextFrame){
                    final /* synthetic */ BalancedAnimationStrategy this$0;
                    final /* synthetic */ Integer $nextFrame;
                    {
                        this.this$0 = $receiver;
                        this.$nextFrame = $nextFrame;
                        super(1);
                    }

                    public final void invoke(@Nullable CloseableReference<Bitmap> bitmap) {
                        if (bitmap != null) {
                            BalancedAnimationStrategy.access$setOnDemandBitmap$p(this.this$0, new OnDemandFrame(this.$nextFrame, bitmap));
                        }
                        BalancedAnimationStrategy.access$getFetchingOnDemand$p(this.this$0).set(false);
                    }
                }));
                AnimationLoaderExecutor.INSTANCE.execute(onDemandTask2);
                return;
            }
        }
        this.fetchingOnDemand.set(false);
    }

    private final boolean isOnDemandFrame(int frameNumber) {
        if (this.onDemandRatio > this.frameCount) {
            return false;
        }
        return frameNumber % this.onDemandRatio == 1;
    }

    private final CloseableReference<Bitmap> findNearestFrame(int fromFrame) {
        CloseableReference<Bitmap> closeableReference;
        block1: {
            Iterator iterator = CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.downTo((int)fromFrame, (int)0))).iterator();
            while (iterator.hasNext()) {
                CloseableReference<Bitmap> frame;
                int it = ((Number)iterator.next()).intValue();
                boolean bl = false;
                CloseableReference<Bitmap> closeableReference2 = frame = this.bitmapCache.getCachedFrame(it);
                Object object = (closeableReference2 != null ? closeableReference2.isValid() : false) ? frame : null;
                if (object == null) continue;
                closeableReference = object;
                break block1;
            }
            closeableReference = null;
        }
        return closeableReference;
    }

    @Override
    public void onStop() {
        OnDemandFrame onDemandFrame = this.onDemandBitmap;
        if (onDemandFrame != null) {
            onDemandFrame.close();
        }
        this.bitmapCache.clear();
    }

    @Override
    public void clearFrames() {
        this.bitmapCache.clear();
    }

    @UiThread
    private final Integer findNextOnDemandFrame(int from) {
        Integer n;
        Object v0;
        block3: {
            if (this.onDemandFrames.isEmpty()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.onDemandFrames;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Integer it = (Integer)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!(it > from)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((n = (Integer)v0) == null) {
            n = this.onDemandFrames.first();
        }
        return n;
    }

    private final Size calculateFrameSize(int canvasWidth, int canvasHeight) {
        if (!this.downscaleFrameToDrawableDimensions) {
            return new Size(this.animationWidth, this.animationHeight);
        }
        int bitmapWidth = this.animationWidth;
        int bitmapHeight = this.animationHeight;
        if (canvasWidth < this.animationWidth || canvasHeight < this.animationHeight) {
            double ratioW = (double)this.animationWidth / (double)this.animationHeight;
            if (canvasHeight > canvasWidth) {
                bitmapHeight = RangesKt.coerceAtMost((int)canvasHeight, (int)this.animationHeight);
                bitmapWidth = (int)((double)bitmapHeight * ratioW);
            } else {
                bitmapWidth = RangesKt.coerceAtMost((int)canvasWidth, (int)this.animationWidth);
                bitmapHeight = (int)((double)bitmapWidth / ratioW);
            }
        }
        return new Size(bitmapWidth, bitmapHeight);
    }

    @Override
    public void prepareFrames(@NotNull BitmapFramePreparer bitmapFramePreparer, @NotNull BitmapFrameCache bitmapFrameCache, @NotNull AnimationBackend animationBackend, int lastDrawnFrameNumber, @Nullable Function0<Unit> onAnimationLoaded) {
        BitmapFramePreparationStrategy.DefaultImpls.prepareFrames(this, bitmapFramePreparer, bitmapFrameCache, animationBackend, lastDrawnFrameNumber, onAnimationLoaded);
    }

    public static final /* synthetic */ BitmapFrameCache access$getBitmapCache$p(BalancedAnimationStrategy $this) {
        return $this.bitmapCache;
    }

    public static final /* synthetic */ void access$setNextPrepareFrames$p(BalancedAnimationStrategy $this, long l) {
        $this.nextPrepareFrames = l;
    }

    public static final /* synthetic */ int access$getFETCH_FIRST_CACHE_DELAY_MS$cp() {
        return FETCH_FIRST_CACHE_DELAY_MS;
    }

    public static final /* synthetic */ LoadFrameTask access$loadAllFrames(BalancedAnimationStrategy $this, Size frameSize, Function0 notifyOnLoad) {
        return $this.loadAllFrames(frameSize, (Function0<Unit>)notifyOnLoad);
    }

    public static final /* synthetic */ AtomicBoolean access$getFetchingFrames$p(BalancedAnimationStrategy $this) {
        return $this.fetchingFrames;
    }

    public static final /* synthetic */ SortedSet access$getOnDemandFrames$p(BalancedAnimationStrategy $this) {
        return $this.onDemandFrames;
    }

    public static final /* synthetic */ long access$getFETCH_FULL_ANIMATION_CACHE_DELAY_MS$cp() {
        return FETCH_FULL_ANIMATION_CACHE_DELAY_MS;
    }

    public static final /* synthetic */ boolean access$isOnDemandFrame(BalancedAnimationStrategy $this, int frameNumber) {
        return $this.isOnDemandFrame(frameNumber);
    }

    public static final /* synthetic */ void access$setOnDemandBitmap$p(BalancedAnimationStrategy $this, OnDemandFrame onDemandFrame) {
        $this.onDemandBitmap = onDemandFrame;
    }

    public static final /* synthetic */ AtomicBoolean access$getFetchingOnDemand$p(BalancedAnimationStrategy $this) {
        return $this.fetchingOnDemand;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/BalancedAnimationStrategy$Companion;", "", "()V", "FETCH_FIRST_CACHE_DELAY_MS", "", "FETCH_FULL_ANIMATION_CACHE_DELAY_MS", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

