/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable;

import android.os.SystemClock;
import com.facebook.fresco.animation.frame.FrameScheduler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020\u001bJ\u0006\u0010#\u001a\u00020\u0006J\u0006\u0010$\u001a\u00020\u0006J\b\u0010%\u001a\u00020\u0006H\u0002J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020'J\u0006\u0010*\u001a\u00020'R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/facebook/fresco/animation/drawable/AnimationFrameScheduler;", "", "frameScheduler", "Lcom/facebook/fresco/animation/frame/FrameScheduler;", "(Lcom/facebook/fresco/animation/frame/FrameScheduler;)V", "expectedRenderTimeMs", "", "frameSchedulingDelayMs", "getFrameSchedulingDelayMs", "()J", "setFrameSchedulingDelayMs", "(J)V", "frameSchedulingOffsetMs", "getFrameSchedulingOffsetMs", "setFrameSchedulingOffsetMs", "framesDropped", "", "lastDrawnFrameNumber", "getLastDrawnFrameNumber", "()I", "setLastDrawnFrameNumber", "(I)V", "lastFrameAnimationTimeDifferenceMs", "lastFrameAnimationTimeMs", "pauseTimeMs", "pausedLastDrawnFrameNumber", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "startMs", "frameToDraw", "infinite", "loopDuration", "nextRenderTime", "now", "onFrameDropped", "", "shouldRepeatAnimation", "start", "stop", "animated-drawable_release"})
public final class AnimationFrameScheduler {
    @NotNull
    private final FrameScheduler frameScheduler;
    private boolean running;
    private long frameSchedulingDelayMs;
    private long frameSchedulingOffsetMs;
    private long pauseTimeMs;
    private long startMs;
    private long expectedRenderTimeMs;
    private long lastFrameAnimationTimeMs;
    private long lastFrameAnimationTimeDifferenceMs;
    private int lastDrawnFrameNumber;
    private int pausedLastDrawnFrameNumber;
    private int framesDropped;

    public AnimationFrameScheduler(@NotNull FrameScheduler frameScheduler) {
        Intrinsics.checkNotNullParameter((Object)frameScheduler, (String)"frameScheduler");
        this.frameScheduler = frameScheduler;
        this.frameSchedulingDelayMs = 8L;
        this.lastDrawnFrameNumber = -1;
        this.pausedLastDrawnFrameNumber = -1;
    }

    public final boolean getRunning() {
        return this.running;
    }

    public final void setRunning(boolean bl) {
        this.running = bl;
    }

    public final long getFrameSchedulingDelayMs() {
        return this.frameSchedulingDelayMs;
    }

    public final void setFrameSchedulingDelayMs(long l) {
        this.frameSchedulingDelayMs = l;
    }

    public final long getFrameSchedulingOffsetMs() {
        return this.frameSchedulingOffsetMs;
    }

    public final void setFrameSchedulingOffsetMs(long l) {
        this.frameSchedulingOffsetMs = l;
    }

    public final int getLastDrawnFrameNumber() {
        return this.lastDrawnFrameNumber;
    }

    public final void setLastDrawnFrameNumber(int n) {
        this.lastDrawnFrameNumber = n;
    }

    private final long now() {
        return SystemClock.uptimeMillis();
    }

    public final void start() {
        if (!this.running) {
            long now = this.now();
            this.expectedRenderTimeMs = this.startMs = now - this.pauseTimeMs;
            this.lastFrameAnimationTimeMs = now - this.lastFrameAnimationTimeDifferenceMs;
            this.lastDrawnFrameNumber = this.pausedLastDrawnFrameNumber;
            this.running = true;
        }
    }

    public final void stop() {
        if (this.running) {
            long now = this.now();
            this.pauseTimeMs = now - this.startMs;
            this.lastFrameAnimationTimeDifferenceMs = now - this.lastFrameAnimationTimeMs;
            this.startMs = 0L;
            this.expectedRenderTimeMs = 0L;
            this.lastFrameAnimationTimeMs = -1L;
            this.lastDrawnFrameNumber = -1;
            this.running = false;
        }
    }

    public final int frameToDraw() {
        long renderTimeMillis = this.now();
        long animationTimeMillis = this.running ? renderTimeMillis - this.startMs + this.frameSchedulingOffsetMs : Math.max(this.lastFrameAnimationTimeMs, 0L);
        int frameNumberToDraw = this.frameScheduler.getFrameNumberToRender(animationTimeMillis, this.lastFrameAnimationTimeMs);
        this.lastFrameAnimationTimeMs = animationTimeMillis;
        return frameNumberToDraw;
    }

    public final long nextRenderTime() {
        if (!this.running) {
            return -1L;
        }
        long actualRenderTimeEnd = this.now();
        long targetRenderTimeForNextFrameMs = this.frameScheduler.getTargetRenderTimeForNextFrameMs(actualRenderTimeEnd - this.startMs);
        if (targetRenderTimeForNextFrameMs != -1L) {
            long nextFrameTime = targetRenderTimeForNextFrameMs + this.frameSchedulingDelayMs;
            this.expectedRenderTimeMs = this.startMs + nextFrameTime;
            return nextFrameTime;
        }
        this.running = false;
        return -1L;
    }

    public final boolean shouldRepeatAnimation() {
        return this.lastDrawnFrameNumber != -1 && this.now() >= this.expectedRenderTimeMs;
    }

    public final void onFrameDropped() {
        int n = this.framesDropped;
        this.framesDropped = n + 1;
    }

    public final boolean infinite() {
        return this.frameScheduler.isInfiniteAnimation();
    }

    public final long loopDuration() {
        return this.frameScheduler.getLoopDurationMs();
    }
}

