/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.loadframe;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFrameOutput;
import com.facebook.fresco.animation.bitmap.preparation.loadframe.LoadFramePriorityTask;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask;", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFramePriorityTask;", "width", "", "height", "untilFrame", "priority", "output", "Lcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameOutput;", "platformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "(IIIILcom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameOutput;Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;)V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "getPriority", "()I", "run", "", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nLoadFrameTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadFrameTask.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1855#2:56\n1855#2,2:57\n1856#2:59\n*S KotlinDebug\n*F\n+ 1 LoadFrameTask.kt\ncom/facebook/fresco/animation/bitmap/preparation/loadframe/LoadFrameTask\n*L\n36#1:56\n41#1:57,2\n36#1:59\n*E\n"})
public final class LoadFrameTask
implements LoadFramePriorityTask {
    private final int width;
    private final int height;
    private final int untilFrame;
    private final int priority;
    @NotNull
    private final LoadFrameOutput output;
    @NotNull
    private final PlatformBitmapFactory platformBitmapFactory;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    @NotNull
    private final Bitmap.Config bitmapConfig;

    public LoadFrameTask(int width, int height, int untilFrame, int priority, @NotNull LoadFrameOutput output, @NotNull PlatformBitmapFactory platformBitmapFactory, @NotNull BitmapFrameRenderer bitmapFrameRenderer) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)platformBitmapFactory, (String)"platformBitmapFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        this.width = width;
        this.height = height;
        this.untilFrame = untilFrame;
        this.priority = priority;
        this.output = output;
        this.platformBitmapFactory = platformBitmapFactory;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void run() {
        Map frameCollection = new LinkedHashMap();
        CloseableReference closeableReference = this.platformBitmapFactory.createBitmap(this.width, this.height, this.bitmapConfig);
        Intrinsics.checkNotNullExpressionValue((Object)closeableReference, (String)"platformBitmapFactory.cr\u2026th, height, bitmapConfig)");
        CloseableReference canvasBitmapFrame = closeableReference;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.untilFrame);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            CloseableReference copyFrame;
            int element$iv;
            int frameNumber = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Object object = canvasBitmapFrame.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"canvasBitmapFrame.get()");
            boolean renderSucceed = this.bitmapFrameRenderer.renderFrame(frameNumber, (Bitmap)object);
            if (!renderSucceed) {
                canvasBitmapFrame.close();
                Iterable $this$forEach$iv2 = frameCollection.values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    CloseableReference it = (CloseableReference)element$iv2;
                    boolean bl2 = false;
                    it.close();
                }
                this.output.onFail();
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)this.platformBitmapFactory.createBitmap((Bitmap)canvasBitmapFrame.get()), (String)"platformBitmapFactory.cr\u2026(canvasBitmapFrame.get())");
            Integer n = frameNumber;
            frameCollection.put(n, copyFrame);
        }
        canvasBitmapFrame.close();
        this.output.onSuccess(frameCollection);
    }

    @Override
    public int compareTo(@NotNull LoadFramePriorityTask other) {
        return LoadFramePriorityTask.DefaultImpls.compareTo(this, other);
    }
}

