/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationBackendDelegateWithInactivityCheck;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.fresco.vito.options.RoundingOptions;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u0000 P2\u00020\u00012\u00020\u0002:\u0003PQRBM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J0\u00100\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00172\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020-\u0018\u0001022\u0006\u0010.\u001a\u00020/2\u0006\u00103\u001a\u00020\u0017H\u0002J \u00104\u001a\u00020\f2\u0006\u00105\u001a\u0002062\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0017H\u0016J \u00107\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u0017H\u0002J\b\u00108\u001a\u00020\u0017H\u0016J\u0010\u00109\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0017H\u0016J\b\u0010:\u001a\u00020\u0017H\u0016J\b\u0010;\u001a\u00020\u0017H\u0016J\b\u0010<\u001a\u00020\u0017H\u0016J\b\u0010=\u001a\u00020\u0017H\u0016J\b\u0010>\u001a\u00020\u0017H\u0016J\b\u0010?\u001a\u00020\u0017H\u0016J\b\u0010@\u001a\u00020)H\u0016J \u0010A\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00172\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020-\u0018\u000102H\u0002J\u0012\u0010C\u001a\u00020)2\b\b\u0001\u0010D\u001a\u00020\u0017H\u0016J\u0012\u0010E\u001a\u00020)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010F\u001a\u00020)2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010I\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010J\u001a\u00020)H\u0002J(\u0010K\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MH\u0002J\b\u0010O\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend;", "Lcom/facebook/fresco/animation/backend/AnimationBackend;", "Lcom/facebook/fresco/animation/backend/AnimationBackendDelegateWithInactivityCheck$InactivityListener;", "platformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapFrameCache", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "isNewRenderImplementation", "", "bitmapFramePreparationStrategy", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparationStrategy;", "bitmapFramePreparer", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparer;", "roundingOptions", "Lcom/facebook/fresco/vito/options/RoundingOptions;", "(Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;Lcom/facebook/fresco/animation/backend/AnimationInformation;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;ZLcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparationStrategy;Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparer;Lcom/facebook/fresco/vito/options/RoundingOptions;)V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "bitmapHeight", "", "bitmapWidth", "bounds", "Landroid/graphics/Rect;", "cornerRadii", "", "getCornerRadii", "()[F", "frameListener", "Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend$FrameListener;", "matrix", "Landroid/graphics/Matrix;", "paint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "pathFrameNumber", "clear", "", "drawBitmap", "frameNumber", "bitmap", "Landroid/graphics/Bitmap;", "canvas", "Landroid/graphics/Canvas;", "drawBitmapAndCache", "bitmapReference", "Lcom/facebook/common/references/CloseableReference;", "frameType", "drawFrame", "parent", "Landroid/graphics/drawable/Drawable;", "drawFrameOrFallback", "getFrameCount", "getFrameDurationMs", "getIntrinsicHeight", "getIntrinsicWidth", "getLoopCount", "getLoopDurationMs", "getSizeInBytes", "height", "onInactive", "renderFrameInBitmap", "targetBitmap", "setAlpha", "alpha", "setBounds", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setFrameListener", "updateBitmapDimensions", "updatePath", "currentBoundsWidth", "", "currentBoundsHeight", "width", "Companion", "FrameListener", "FrameType", "animated-drawable_release"})
public final class BitmapAnimationBackend
implements AnimationBackend,
AnimationBackendDelegateWithInactivityCheck.InactivityListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlatformBitmapFactory platformBitmapFactory;
    @NotNull
    private final BitmapFrameCache bitmapFrameCache;
    @NotNull
    private final AnimationInformation animationInformation;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    private final boolean isNewRenderImplementation;
    @Nullable
    private final BitmapFramePreparationStrategy bitmapFramePreparationStrategy;
    @Nullable
    private final BitmapFramePreparer bitmapFramePreparer;
    @Nullable
    private final float[] cornerRadii;
    @NotNull
    private final Bitmap.Config bitmapConfig;
    @NotNull
    private final Paint paint;
    @Nullable
    private Rect bounds;
    private int bitmapWidth;
    private int bitmapHeight;
    @NotNull
    private final Path path;
    @NotNull
    private final Matrix matrix;
    private int pathFrameNumber;
    @Nullable
    private FrameListener frameListener;
    public static final int FRAME_TYPE_UNKNOWN = -1;
    public static final int FRAME_TYPE_CACHED = 0;
    public static final int FRAME_TYPE_REUSED = 1;
    public static final int FRAME_TYPE_CREATED = 2;
    public static final int FRAME_TYPE_FALLBACK = 3;
    @NotNull
    private static final Class<BitmapAnimationBackend> TAG = BitmapAnimationBackend.class;

    /*
     * WARNING - void declaration
     */
    public BitmapAnimationBackend(@NotNull PlatformBitmapFactory platformBitmapFactory, @NotNull BitmapFrameCache bitmapFrameCache, @NotNull AnimationInformation animationInformation, @NotNull BitmapFrameRenderer bitmapFrameRenderer, boolean isNewRenderImplementation, @Nullable BitmapFramePreparationStrategy bitmapFramePreparationStrategy, @Nullable BitmapFramePreparer bitmapFramePreparer, @Nullable RoundingOptions roundingOptions) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)platformBitmapFactory, (String)"platformBitmapFactory");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameCache, (String)"bitmapFrameCache");
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        this.platformBitmapFactory = platformBitmapFactory;
        this.bitmapFrameCache = bitmapFrameCache;
        this.animationInformation = animationInformation;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.isNewRenderImplementation = isNewRenderImplementation;
        this.bitmapFramePreparationStrategy = bitmapFramePreparationStrategy;
        this.bitmapFramePreparer = bitmapFramePreparer;
        BitmapAnimationBackend bitmapAnimationBackend = this;
        RoundingOptions roundingOptions2 = roundingOptions;
        if (roundingOptions2 != null) {
            float[] fArray2;
            void roundingOptions3;
            RoundingOptions roundingOptions4 = roundingOptions2;
            BitmapAnimationBackend bitmapAnimationBackend2 = bitmapAnimationBackend;
            boolean bl = false;
            if (!(roundingOptions3.getCornerRadius() == 0.0f)) {
                float[] corners = new float[8];
                ArraysKt.fill$default((float[])corners, (float)roundingOptions3.getCornerRadius(), (int)0, (int)0, (int)6, null);
                fArray2 = corners;
            } else {
                fArray2 = roundingOptions3.getCornerRadii();
            }
            fArray = fArray2;
            bitmapAnimationBackend = bitmapAnimationBackend2;
        } else {
            fArray = null;
        }
        bitmapAnimationBackend.cornerRadii = fArray;
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
        this.paint = new Paint(6);
        this.path = new Path();
        this.matrix = new Matrix();
        this.pathFrameNumber = -1;
        this.updateBitmapDimensions();
    }

    public /* synthetic */ BitmapAnimationBackend(PlatformBitmapFactory platformBitmapFactory, BitmapFrameCache bitmapFrameCache, AnimationInformation animationInformation, BitmapFrameRenderer bitmapFrameRenderer, boolean bl, BitmapFramePreparationStrategy bitmapFramePreparationStrategy, BitmapFramePreparer bitmapFramePreparer, RoundingOptions roundingOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            roundingOptions = null;
        }
        this(platformBitmapFactory, bitmapFrameCache, animationInformation, bitmapFrameRenderer, bl, bitmapFramePreparationStrategy, bitmapFramePreparer, roundingOptions);
    }

    @Nullable
    public final float[] getCornerRadii() {
        return this.cornerRadii;
    }

    public final void setFrameListener(@Nullable FrameListener frameListener) {
        this.frameListener = frameListener;
    }

    @Override
    public int getFrameCount() {
        return this.animationInformation.getFrameCount();
    }

    @Override
    public int getFrameDurationMs(int frameNumber) {
        return this.animationInformation.getFrameDurationMs(frameNumber);
    }

    @Override
    public int width() {
        return this.animationInformation.width();
    }

    @Override
    public int height() {
        return this.animationInformation.height();
    }

    @Override
    public int getLoopDurationMs() {
        return this.animationInformation.getLoopDurationMs();
    }

    @Override
    public int getLoopCount() {
        return this.animationInformation.getLoopCount();
    }

    @Override
    public boolean drawFrame(@NotNull Drawable parent, @NotNull Canvas canvas, int frameNumber) {
        boolean drawn;
        block4: {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            FrameListener frameListener = this.frameListener;
            if (frameListener != null) {
                frameListener.onDrawFrameStart(this, frameNumber);
            }
            drawn = this.drawFrameOrFallback(canvas, frameNumber, 0);
            if (!drawn) {
                FrameListener frameListener2 = this.frameListener;
                if (frameListener2 != null) {
                    frameListener2.onFrameDropped(this, frameNumber);
                }
            }
            if (this.isNewRenderImplementation || this.bitmapFramePreparer == null) break block4;
            BitmapFramePreparationStrategy bitmapFramePreparationStrategy = this.bitmapFramePreparationStrategy;
            if (bitmapFramePreparationStrategy != null) {
                bitmapFramePreparationStrategy.prepareFrames(this.bitmapFramePreparer, this.bitmapFrameCache, this, frameNumber);
            }
        }
        return drawn;
    }

    /*
     * Exception decompiling
     */
    private final boolean drawFrameOrFallback(Canvas canvas, int frameNumber, int frameType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    @Override
    public void setBounds(@Nullable Rect bounds) {
        this.bounds = bounds;
        this.bitmapFrameRenderer.setBounds(bounds);
        this.updateBitmapDimensions();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.bitmapWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.bitmapHeight;
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmapFrameCache.getSizeInBytes();
    }

    @Override
    public void clear() {
        if (this.isNewRenderImplementation) {
            BitmapFramePreparationStrategy bitmapFramePreparationStrategy = this.bitmapFramePreparationStrategy;
            if (bitmapFramePreparationStrategy != null) {
                bitmapFramePreparationStrategy.clearFrames();
            }
        } else {
            this.bitmapFrameCache.clear();
        }
    }

    @Override
    public void onInactive() {
        if (this.isNewRenderImplementation) {
            BitmapFramePreparationStrategy bitmapFramePreparationStrategy = this.bitmapFramePreparationStrategy;
            if (bitmapFramePreparationStrategy != null) {
                bitmapFramePreparationStrategy.onStop();
            }
        } else {
            this.clear();
        }
    }

    private final void updateBitmapDimensions() {
        this.bitmapWidth = this.bitmapFrameRenderer.getIntrinsicWidth();
        if (this.bitmapWidth == -1) {
            Rect rect = this.bounds;
            this.bitmapWidth = rect != null ? rect.width() : -1;
        }
        this.bitmapHeight = this.bitmapFrameRenderer.getIntrinsicHeight();
        if (this.bitmapHeight == -1) {
            Rect rect = this.bounds;
            this.bitmapHeight = rect != null ? rect.height() : -1;
        }
    }

    private final boolean renderFrameInBitmap(int frameNumber, CloseableReference<Bitmap> targetBitmap) {
        if (targetBitmap == null || !targetBitmap.isValid()) {
            return false;
        }
        Object object = targetBitmap.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"targetBitmap.get()");
        boolean frameRendered = this.bitmapFrameRenderer.renderFrame(frameNumber, (Bitmap)object);
        if (!frameRendered) {
            CloseableReference.closeSafely(targetBitmap);
        }
        return frameRendered;
    }

    private final boolean updatePath(int frameNumber, Bitmap bitmap, float currentBoundsWidth, float currentBoundsHeight) {
        if (this.cornerRadii == null) {
            return false;
        }
        if (frameNumber == this.pathFrameNumber) {
            return true;
        }
        BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        RectF src = new RectF(0.0f, 0.0f, (float)this.bitmapWidth, (float)this.bitmapHeight);
        RectF dst = new RectF(0.0f, 0.0f, currentBoundsWidth, currentBoundsHeight);
        this.matrix.setRectToRect(src, dst, Matrix.ScaleToFit.FILL);
        bitmapShader.setLocalMatrix(this.matrix);
        this.paint.setShader((Shader)bitmapShader);
        this.path.addRoundRect(new RectF(0.0f, 0.0f, currentBoundsWidth, currentBoundsHeight), this.cornerRadii, Path.Direction.CW);
        this.pathFrameNumber = frameNumber;
        return true;
    }

    private final void drawBitmap(int frameNumber, Bitmap bitmap, Canvas canvas) {
        Rect currentBounds = this.bounds;
        if (currentBounds == null) {
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint);
        } else if (this.updatePath(frameNumber, bitmap, currentBounds.width(), currentBounds.height())) {
            canvas.drawPath(this.path, this.paint);
        } else {
            canvas.drawBitmap(bitmap, null, currentBounds, this.paint);
        }
    }

    private final boolean drawBitmapAndCache(int frameNumber, CloseableReference<Bitmap> bitmapReference, Canvas canvas, int frameType) {
        block2: {
            if (bitmapReference == null || !CloseableReference.isValid(bitmapReference)) {
                return false;
            }
            Object object = bitmapReference.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bitmapReference.get()");
            this.drawBitmap(frameNumber, (Bitmap)object, canvas);
            if (frameType != 3 && !this.isNewRenderImplementation) {
                this.bitmapFrameCache.onFrameRendered(frameNumber, bitmapReference, frameType);
            }
            FrameListener frameListener = this.frameListener;
            if (frameListener == null) break block2;
            frameListener.onFrameDrawn(this, frameNumber, frameType);
        }
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend$Companion;", "", "()V", "FRAME_TYPE_CACHED", "", "FRAME_TYPE_CREATED", "FRAME_TYPE_FALLBACK", "FRAME_TYPE_REUSED", "FRAME_TYPE_UNKNOWN", "TAG", "Ljava/lang/Class;", "Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend;", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H&J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u000b"}, d2={"Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend$FrameListener;", "", "onDrawFrameStart", "", "backend", "Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend;", "frameNumber", "", "onFrameDrawn", "frameType", "onFrameDropped", "animated-drawable_release"})
    public static interface FrameListener {
        public void onDrawFrameStart(@NotNull BitmapAnimationBackend var1, int var2);

        public void onFrameDrawn(@NotNull BitmapAnimationBackend var1, int var2, int var3);

        public void onFrameDropped(@NotNull BitmapAnimationBackend var1, int var2);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/facebook/fresco/animation/bitmap/BitmapAnimationBackend$FrameType;", "", "animated-drawable_release"})
    public static @interface FrameType {
    }
}

