/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation;

import com.facebook.common.logging.FLog;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class FixedNumberBitmapFramePreparationStrategy
implements BitmapFramePreparationStrategy {
    private static final Class<?> TAG = FixedNumberBitmapFramePreparationStrategy.class;
    private static final int DEFAULT_FRAMES_TO_PREPARE = 3;
    private final int mFramesToPrepare;

    public FixedNumberBitmapFramePreparationStrategy() {
        this(3);
    }

    public FixedNumberBitmapFramePreparationStrategy(int framesToPrepare) {
        this.mFramesToPrepare = framesToPrepare;
    }

    @Override
    public void prepareFrames(BitmapFramePreparer bitmapFramePreparer, BitmapFrameCache bitmapFrameCache, AnimationBackend animationBackend, int lastDrawnFrameNumber) {
        for (int i = 1; i <= this.mFramesToPrepare; ++i) {
            int nextFrameNumber = (lastDrawnFrameNumber + i) % animationBackend.getFrameCount();
            if (FLog.isLoggable((int)2)) {
                FLog.v(TAG, (String)"Preparing frame %d, last drawn: %d", (Object)nextFrameNumber, (Object)lastDrawnFrameNumber);
            }
            if (bitmapFramePreparer.prepareFrame(bitmapFrameCache, animationBackend, nextFrameNumber)) continue;
            return;
        }
    }
}

