/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.backend;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimationBackendDelegate<T extends AnimationBackend>
implements AnimationBackend {
    private static final int ALPHA_UNSET = -1;
    @Nullable
    private T mAnimationBackend;
    @IntRange(from=-1L, to=255L)
    private int mAlpha = -1;
    @Nullable
    private ColorFilter mColorFilter;
    @Nullable
    private Rect mBounds;

    public AnimationBackendDelegate(@Nullable T animationBackend) {
        this.mAnimationBackend = animationBackend;
    }

    @Override
    public int getFrameCount() {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getFrameCount();
    }

    @Override
    public int getFrameDurationMs(int frameNumber) {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getFrameDurationMs(frameNumber);
    }

    @Override
    public int getLoopCount() {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getLoopCount();
    }

    @Override
    public boolean drawFrame(Drawable parent, Canvas canvas, int frameNumber) {
        return this.mAnimationBackend != null && this.mAnimationBackend.drawFrame(parent, canvas, frameNumber);
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setAlpha(alpha);
        }
        this.mAlpha = alpha;
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setColorFilter(colorFilter);
        }
        this.mColorFilter = colorFilter;
    }

    @Override
    public void setBounds(Rect bounds) {
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setBounds(bounds);
        }
        this.mBounds = bounds;
    }

    @Override
    public int getSizeInBytes() {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getSizeInBytes();
    }

    @Override
    public void clear() {
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.clear();
        }
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mAnimationBackend == null ? -1 : this.mAnimationBackend.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mAnimationBackend == null ? -1 : this.mAnimationBackend.getIntrinsicHeight();
    }

    public void setAnimationBackend(@Nullable T animationBackend) {
        this.mAnimationBackend = animationBackend;
        if (this.mAnimationBackend != null) {
            this.applyBackendProperties((AnimationBackend)this.mAnimationBackend);
        }
    }

    @Nullable
    public T getAnimationBackend() {
        return this.mAnimationBackend;
    }

    @SuppressLint(value={"Range"})
    private void applyBackendProperties(AnimationBackend backend) {
        if (this.mBounds != null) {
            backend.setBounds(this.mBounds);
        }
        if (this.mAlpha >= 0 && this.mAlpha <= 255) {
            backend.setAlpha(this.mAlpha);
        }
        if (this.mColorFilter != null) {
            backend.setColorFilter(this.mColorFilter);
        }
    }
}

