/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class KeepLastFrameCache
implements BitmapFrameCache {
    private static final int FRAME_NUMBER_UNSET = -1;
    private int mLastFrameNumber = -1;
    @Nullable
    private BitmapFrameCache.FrameCacheListener mFrameCacheListener;
    @Nullable
    @GuardedBy(value="this")
    private CloseableReference<Bitmap> mLastBitmapReference;

    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getCachedFrame(int frameNumber) {
        if (this.mLastFrameNumber == frameNumber) {
            return CloseableReference.cloneOrNull(this.mLastBitmapReference);
        }
        return null;
    }

    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getFallbackFrame(int frameNumber) {
        return CloseableReference.cloneOrNull(this.mLastBitmapReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getBitmapToReuseForFrame(int frameNumber, int width, int height) {
        try {
            CloseableReference closeableReference = CloseableReference.cloneOrNull(this.mLastBitmapReference);
            return closeableReference;
        }
        finally {
            this.closeAndResetLastBitmapReference();
        }
    }

    @Override
    public synchronized boolean contains(int frameNumber) {
        return frameNumber == this.mLastFrameNumber && CloseableReference.isValid(this.mLastBitmapReference);
    }

    @Override
    public synchronized int getSizeInBytes() {
        return this.mLastBitmapReference == null ? 0 : BitmapUtil.getSizeInBytes((Bitmap)((Bitmap)this.mLastBitmapReference.get()));
    }

    @Override
    public synchronized void clear() {
        this.closeAndResetLastBitmapReference();
    }

    @Override
    public synchronized void onFrameRendered(int frameNumber, CloseableReference<Bitmap> bitmapReference, int frameType) {
        if (bitmapReference != null && this.mLastBitmapReference != null && ((Bitmap)bitmapReference.get()).equals(this.mLastBitmapReference.get())) {
            return;
        }
        CloseableReference.closeSafely(this.mLastBitmapReference);
        if (this.mFrameCacheListener != null && this.mLastFrameNumber != -1) {
            this.mFrameCacheListener.onFrameEvicted(this, this.mLastFrameNumber);
        }
        this.mLastBitmapReference = CloseableReference.cloneOrNull(bitmapReference);
        if (this.mFrameCacheListener != null) {
            this.mFrameCacheListener.onFrameCached(this, frameNumber);
        }
        this.mLastFrameNumber = frameNumber;
    }

    @Override
    public void onFramePrepared(int frameNumber, CloseableReference<Bitmap> bitmapReference, int frameType) {
    }

    @Override
    public void setFrameCacheListener(BitmapFrameCache.FrameCacheListener frameCacheListener) {
        this.mFrameCacheListener = frameCacheListener;
    }

    private synchronized void closeAndResetLastBitmapReference() {
        if (this.mFrameCacheListener != null && this.mLastFrameNumber != -1) {
            this.mFrameCacheListener.onFrameEvicted(this, this.mLastFrameNumber);
        }
        CloseableReference.closeSafely(this.mLastBitmapReference);
        this.mLastBitmapReference = null;
        this.mLastFrameNumber = -1;
    }
}

