/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationBackendDelegateWithInactivityCheck;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nullable;

public class BitmapAnimationBackend
implements AnimationBackend,
AnimationBackendDelegateWithInactivityCheck.InactivityListener {
    public static final int FRAME_TYPE_UNKNOWN = -1;
    public static final int FRAME_TYPE_CACHED = 0;
    public static final int FRAME_TYPE_REUSED = 1;
    public static final int FRAME_TYPE_CREATED = 2;
    public static final int FRAME_TYPE_FALLBACK = 3;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final BitmapFrameCache mBitmapFrameCache;
    private final AnimationInformation mAnimationInformation;
    private final BitmapFrameRenderer mBitmapFrameRenderer;
    @Nullable
    private final BitmapFramePreparationStrategy mBitmapFramePreparationStrategy;
    @Nullable
    private final BitmapFramePreparer mBitmapFramePreparer;
    private final Paint mPaint;
    @Nullable
    private Rect mBounds;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private Bitmap.Config mBitmapConfig = Bitmap.Config.ARGB_8888;
    @Nullable
    private FrameListener mFrameListener;

    public BitmapAnimationBackend(PlatformBitmapFactory platformBitmapFactory, BitmapFrameCache bitmapFrameCache, AnimationInformation animationInformation, BitmapFrameRenderer bitmapFrameRenderer, @Nullable BitmapFramePreparationStrategy bitmapFramePreparationStrategy, @Nullable BitmapFramePreparer bitmapFramePreparer) {
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mBitmapFrameCache = bitmapFrameCache;
        this.mAnimationInformation = animationInformation;
        this.mBitmapFrameRenderer = bitmapFrameRenderer;
        this.mBitmapFramePreparationStrategy = bitmapFramePreparationStrategy;
        this.mBitmapFramePreparer = bitmapFramePreparer;
        this.mPaint = new Paint(6);
        this.updateBitmapDimensions();
    }

    public void setBitmapConfig(Bitmap.Config bitmapConfig) {
        this.mBitmapConfig = bitmapConfig;
    }

    public void setFrameListener(@Nullable FrameListener frameListener) {
        this.mFrameListener = frameListener;
    }

    @Override
    public int getFrameCount() {
        return this.mAnimationInformation.getFrameCount();
    }

    @Override
    public int getFrameDurationMs(int frameNumber) {
        return this.mAnimationInformation.getFrameDurationMs(frameNumber);
    }

    @Override
    public int getLoopCount() {
        return this.mAnimationInformation.getLoopCount();
    }

    @Override
    public boolean drawFrame(Drawable parent, Canvas canvas, int frameNumber) {
        boolean drawn;
        if (this.mFrameListener != null) {
            this.mFrameListener.onDrawFrameStart(this, frameNumber);
        }
        if (!(drawn = this.drawFrameOrFallback(canvas, frameNumber, 0)) && this.mFrameListener != null) {
            this.mFrameListener.onFrameDropped(this, frameNumber);
        }
        if (this.mBitmapFramePreparationStrategy != null && this.mBitmapFramePreparer != null) {
            this.mBitmapFramePreparationStrategy.prepareFrames(this.mBitmapFramePreparer, this.mBitmapFrameCache, this, frameNumber);
        }
        return drawn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean drawFrameOrFallback(Canvas canvas, int frameNumber, int frameType) {
        bitmapReference = null;
        drawn = false;
        nextFrameType = -1;
        try {
            switch (frameType) {
                case 0: {
                    bitmapReference = this.mBitmapFrameCache.getCachedFrame(frameNumber);
                    drawn = this.drawBitmapAndCache(frameNumber, (CloseableReference<Bitmap>)bitmapReference, canvas, 0);
                    nextFrameType = 1;
                    ** break;
                }
                case 1: {
                    bitmapReference = this.mBitmapFrameCache.getBitmapToReuseForFrame(frameNumber, this.mBitmapWidth, this.mBitmapHeight);
                    drawn = this.renderFrameInBitmap(frameNumber, (CloseableReference<Bitmap>)bitmapReference) != false && this.drawBitmapAndCache(frameNumber, (CloseableReference<Bitmap>)bitmapReference, canvas, 1) != false;
                    nextFrameType = 2;
                    ** break;
                }
                case 2: {
                    bitmapReference = this.mPlatformBitmapFactory.createBitmap(this.mBitmapWidth, this.mBitmapHeight, this.mBitmapConfig);
                    drawn = this.renderFrameInBitmap(frameNumber, (CloseableReference<Bitmap>)bitmapReference) != false && this.drawBitmapAndCache(frameNumber, (CloseableReference<Bitmap>)bitmapReference, canvas, 2) != false;
                    nextFrameType = 3;
                    ** break;
                }
                case 3: {
                    bitmapReference = this.mBitmapFrameCache.getFallbackFrame(frameNumber);
                    drawn = this.drawBitmapAndCache(frameNumber, (CloseableReference<Bitmap>)bitmapReference, canvas, 3);
                    ** break;
                }
            }
            var7_7 = false;
        }
        catch (Throwable var8_8) {
            CloseableReference.closeSafely(bitmapReference);
            throw var8_8;
        }
        CloseableReference.closeSafely(bitmapReference);
        return var7_7;
lbl32:
        // 4 sources

        CloseableReference.closeSafely((CloseableReference)bitmapReference);
        if (!drawn && nextFrameType != -1) {
            return this.drawFrameOrFallback(canvas, frameNumber, nextFrameType);
        }
        return drawn;
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    @Override
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    @Override
    public void setBounds(@Nullable Rect bounds) {
        this.mBounds = bounds;
        this.mBitmapFrameRenderer.setBounds(bounds);
        this.updateBitmapDimensions();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mBitmapWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mBitmapHeight;
    }

    @Override
    public int getSizeInBytes() {
        return this.mBitmapFrameCache.getSizeInBytes();
    }

    @Override
    public void clear() {
        this.mBitmapFrameCache.clear();
    }

    @Override
    public void onInactive() {
        this.clear();
    }

    private void updateBitmapDimensions() {
        this.mBitmapWidth = this.mBitmapFrameRenderer.getIntrinsicWidth();
        if (this.mBitmapWidth == -1) {
            this.mBitmapWidth = this.mBounds == null ? -1 : this.mBounds.width();
        }
        this.mBitmapHeight = this.mBitmapFrameRenderer.getIntrinsicHeight();
        if (this.mBitmapHeight == -1) {
            this.mBitmapHeight = this.mBounds == null ? -1 : this.mBounds.height();
        }
    }

    private boolean renderFrameInBitmap(int frameNumber, @Nullable CloseableReference<Bitmap> targetBitmap) {
        if (!CloseableReference.isValid(targetBitmap)) {
            return false;
        }
        boolean frameRendered = this.mBitmapFrameRenderer.renderFrame(frameNumber, (Bitmap)targetBitmap.get());
        if (!frameRendered) {
            CloseableReference.closeSafely(targetBitmap);
        }
        return frameRendered;
    }

    private boolean drawBitmapAndCache(int frameNumber, @Nullable CloseableReference<Bitmap> bitmapReference, Canvas canvas, int frameType) {
        if (!CloseableReference.isValid(bitmapReference)) {
            return false;
        }
        if (this.mBounds == null) {
            canvas.drawBitmap((Bitmap)bitmapReference.get(), 0.0f, 0.0f, this.mPaint);
        } else {
            canvas.drawBitmap((Bitmap)bitmapReference.get(), null, this.mBounds, this.mPaint);
        }
        if (frameType != 3) {
            this.mBitmapFrameCache.onFrameRendered(frameNumber, bitmapReference, frameType);
        }
        if (this.mFrameListener != null) {
            this.mFrameListener.onFrameDrawn(this, frameNumber, frameType);
        }
        return true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameType {
    }

    public static interface FrameListener {
        public void onDrawFrameStart(BitmapAnimationBackend var1, int var2);

        public void onFrameDrawn(BitmapAnimationBackend var1, int var2, int var3);

        public void onFrameDropped(BitmapAnimationBackend var1, int var2);
    }
}

