/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation;

import android.graphics.Bitmap;
import android.util.SparseArray;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import java.util.concurrent.ExecutorService;

public class DefaultBitmapFramePreparer
implements BitmapFramePreparer {
    private static final Class<?> TAG = DefaultBitmapFramePreparer.class;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    private final BitmapFrameRenderer mBitmapFrameRenderer;
    private final Bitmap.Config mBitmapConfig;
    private final ExecutorService mExecutorService;
    private final SparseArray<Runnable> mPendingFrameDecodeJobs;

    public DefaultBitmapFramePreparer(PlatformBitmapFactory platformBitmapFactory, BitmapFrameRenderer bitmapFrameRenderer, Bitmap.Config bitmapConfig, ExecutorService executorService) {
        this.mPlatformBitmapFactory = platformBitmapFactory;
        this.mBitmapFrameRenderer = bitmapFrameRenderer;
        this.mBitmapConfig = bitmapConfig;
        this.mExecutorService = executorService;
        this.mPendingFrameDecodeJobs = new SparseArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareFrame(BitmapFrameCache bitmapFrameCache, AnimationBackend animationBackend, int frameNumber) {
        int frameId = DefaultBitmapFramePreparer.getUniqueId(animationBackend, frameNumber);
        SparseArray<Runnable> sparseArray = this.mPendingFrameDecodeJobs;
        synchronized (sparseArray) {
            if (this.mPendingFrameDecodeJobs.get(frameId) != null) {
                FLog.v(TAG, (String)"Already scheduled decode job for frame %d", (Object)frameNumber);
                return true;
            }
            if (bitmapFrameCache.contains(frameNumber)) {
                FLog.v(TAG, (String)"Frame %d is cached already.", (Object)frameNumber);
                return true;
            }
            FrameDecodeRunnable frameDecodeRunnable = new FrameDecodeRunnable(animationBackend, bitmapFrameCache, frameNumber, frameId);
            this.mPendingFrameDecodeJobs.put(frameId, (Object)frameDecodeRunnable);
            this.mExecutorService.execute(frameDecodeRunnable);
        }
        return true;
    }

    private static int getUniqueId(AnimationBackend backend, int frameNumber) {
        int result = backend.hashCode();
        result = 31 * result + frameNumber;
        return result;
    }

    static /* synthetic */ Bitmap.Config access$200(DefaultBitmapFramePreparer x0) {
        return x0.mBitmapConfig;
    }

    static /* synthetic */ PlatformBitmapFactory access$300(DefaultBitmapFramePreparer x0) {
        return x0.mPlatformBitmapFactory;
    }

    private class FrameDecodeRunnable
    implements Runnable {
        private final BitmapFrameCache mBitmapFrameCache;
        private final AnimationBackend mAnimationBackend;
        private final int mFrameNumber;
        private final int mHashCode;

        public FrameDecodeRunnable(AnimationBackend animationBackend, BitmapFrameCache bitmapFrameCache, int frameNumber, int hashCode) {
            this.mAnimationBackend = animationBackend;
            this.mBitmapFrameCache = bitmapFrameCache;
            this.mFrameNumber = frameNumber;
            this.mHashCode = hashCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.mBitmapFrameCache.contains(this.mFrameNumber)) {
                    FLog.v((Class)TAG, (String)"Frame %d is cached already.", (Object)this.mFrameNumber);
                    return;
                }
                if (this.prepareFrameAndCache(this.mFrameNumber, 1)) {
                    FLog.v((Class)TAG, (String)"Prepared frame frame %d.", (Object)this.mFrameNumber);
                } else {
                    FLog.e((Class)TAG, (String)"Could not prepare frame %d.", (Object[])new Object[]{this.mFrameNumber});
                }
            }
            finally {
                SparseArray sparseArray = DefaultBitmapFramePreparer.this.mPendingFrameDecodeJobs;
                synchronized (sparseArray) {
                    DefaultBitmapFramePreparer.this.mPendingFrameDecodeJobs.remove(this.mHashCode);
                }
            }
        }

        /*
         * Exception decompiling
         */
        private boolean prepareFrameAndCache(int frameNumber, int frameType) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean renderFrameAndCache(int frameNumber, CloseableReference<Bitmap> bitmapReference, int frameType) {
            if (!CloseableReference.isValid(bitmapReference)) {
                return false;
            }
            if (!DefaultBitmapFramePreparer.this.mBitmapFrameRenderer.renderFrame(frameNumber, (Bitmap)bitmapReference.get())) {
                return false;
            }
            FLog.v((Class)TAG, (String)"Frame %d ready.", (Object)this.mFrameNumber);
            SparseArray sparseArray = DefaultBitmapFramePreparer.this.mPendingFrameDecodeJobs;
            synchronized (sparseArray) {
                this.mBitmapFrameCache.onFramePrepared(this.mFrameNumber, bitmapReference, frameType);
            }
            return true;
        }
    }
}

