/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.impl;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.SystemClock;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableCachingBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableDiagnostics;
import com.facebook.imagepipeline.animated.impl.RollingStat;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;

public class AnimatedDrawableDiagnosticsImpl
implements AnimatedDrawableDiagnostics {
    private static final Class<?> TAG = AnimatedDrawableDiagnostics.class;
    private final AnimatedDrawableUtil mAnimatedDrawableUtil;
    private final DisplayMetrics mDisplayMetrics;
    private final TextPaint mDebugTextPaint;
    private final StringBuilder sbTemp;
    private final RollingStat mDroppedFramesStat;
    private final RollingStat mDrawnFrames;
    private AnimatedDrawableCachingBackend mAnimatedDrawableBackend;
    private long mLastTimeStamp;

    public AnimatedDrawableDiagnosticsImpl(AnimatedDrawableUtil animatedDrawableUtil, DisplayMetrics displayMetrics) {
        this.mAnimatedDrawableUtil = animatedDrawableUtil;
        this.mDisplayMetrics = displayMetrics;
        this.mDroppedFramesStat = new RollingStat();
        this.mDrawnFrames = new RollingStat();
        this.sbTemp = new StringBuilder();
        this.mDebugTextPaint = new TextPaint();
        this.mDebugTextPaint.setColor(-16776961);
        this.mDebugTextPaint.setTextSize((float)this.convertDpToPx(14));
    }

    @Override
    public void setBackend(AnimatedDrawableCachingBackend animatedDrawableBackend) {
        this.mAnimatedDrawableBackend = animatedDrawableBackend;
    }

    @Override
    public void onStartMethodBegin() {
        this.mLastTimeStamp = SystemClock.uptimeMillis();
    }

    @Override
    public void onStartMethodEnd() {
        long elapsedMs = SystemClock.uptimeMillis() - this.mLastTimeStamp;
        if (elapsedMs > 3L) {
            FLog.v(TAG, (String)"onStart took %d", (Object)elapsedMs);
        }
    }

    @Override
    public void onNextFrameMethodBegin() {
        this.mLastTimeStamp = SystemClock.uptimeMillis();
    }

    @Override
    public void onNextFrameMethodEnd() {
        long elapsedMs = SystemClock.uptimeMillis() - this.mLastTimeStamp;
        if (elapsedMs > 3L) {
            FLog.v(TAG, (String)"onNextFrame took %d", (Object)elapsedMs);
        }
    }

    @Override
    public void incrementDroppedFrames(int droppedFrames) {
        this.mDroppedFramesStat.incrementStats(droppedFrames);
        if (droppedFrames > 0) {
            FLog.v(TAG, (String)"Dropped %d frames", (Object)droppedFrames);
        }
    }

    @Override
    public void incrementDrawnFrames(int drawnFrames) {
        this.mDrawnFrames.incrementStats(drawnFrames);
    }

    @Override
    public void onDrawMethodBegin() {
        this.mLastTimeStamp = SystemClock.uptimeMillis();
    }

    @Override
    public void onDrawMethodEnd() {
        long elapsedMs = SystemClock.uptimeMillis() - this.mLastTimeStamp;
        FLog.v(TAG, (String)"draw took %d", (Object)elapsedMs);
    }

    @Override
    public void drawDebugOverlay(Canvas canvas, Rect destRect) {
        int leftMargin;
        int droppedFrame10 = this.mDroppedFramesStat.getSum(10);
        int drawnFrames10 = this.mDrawnFrames.getSum(10);
        int totalFrames = drawnFrames10 + droppedFrame10;
        int x = leftMargin = this.convertDpToPx(10);
        int y = this.convertDpToPx(20);
        int spacingBetweenTextPx = this.convertDpToPx(5);
        if (totalFrames > 0) {
            int percentage = drawnFrames10 * 100 / totalFrames;
            this.sbTemp.setLength(0);
            this.sbTemp.append(percentage);
            this.sbTemp.append("%");
            canvas.drawText((CharSequence)this.sbTemp, 0, this.sbTemp.length(), (float)x, (float)y, (Paint)this.mDebugTextPaint);
            x = (int)((float)x + this.mDebugTextPaint.measureText((CharSequence)this.sbTemp, 0, this.sbTemp.length()));
            x += spacingBetweenTextPx;
        }
        int bytesUsed = this.mAnimatedDrawableBackend.getMemoryUsage();
        this.sbTemp.setLength(0);
        this.mAnimatedDrawableUtil.appendMemoryString(this.sbTemp, bytesUsed);
        float textWidth = this.mDebugTextPaint.measureText((CharSequence)this.sbTemp, 0, this.sbTemp.length());
        if ((float)x + textWidth > (float)destRect.width()) {
            x = leftMargin;
            y = (int)((float)y + (this.mDebugTextPaint.getTextSize() + (float)spacingBetweenTextPx));
        }
        canvas.drawText((CharSequence)this.sbTemp, 0, this.sbTemp.length(), (float)x, (float)y, (Paint)this.mDebugTextPaint);
        x = (int)((float)x + textWidth);
        x += spacingBetweenTextPx;
        this.sbTemp.setLength(0);
        this.mAnimatedDrawableBackend.appendDebugOptionString(this.sbTemp);
        textWidth = this.mDebugTextPaint.measureText((CharSequence)this.sbTemp, 0, this.sbTemp.length());
        if ((float)x + textWidth > (float)destRect.width()) {
            x = leftMargin;
            y = (int)((float)y + (this.mDebugTextPaint.getTextSize() + (float)spacingBetweenTextPx));
        }
        canvas.drawText((CharSequence)this.sbTemp, 0, this.sbTemp.length(), (float)x, (float)y, (Paint)this.mDebugTextPaint);
    }

    private int convertDpToPx(int dips) {
        return (int)TypedValue.applyDimension((int)1, (float)dips, (DisplayMetrics)this.mDisplayMetrics);
    }
}

