/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.base;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.view.animation.LinearInterpolator;
import com.facebook.common.time.MonotonicClock;
import com.facebook.imagepipeline.animated.base.AbstractAnimatedDrawable;
import com.facebook.imagepipeline.animated.base.AnimatableDrawable;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableCachingBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableDiagnostics;
import java.util.concurrent.ScheduledExecutorService;

@TargetApi(value=11)
public class AnimatedDrawable
extends AbstractAnimatedDrawable
implements AnimatableDrawable {
    public AnimatedDrawable(ScheduledExecutorService scheduledExecutorServiceForUiThread, AnimatedDrawableCachingBackend animatedDrawableBackend, AnimatedDrawableDiagnostics animatedDrawableDiagnostics, MonotonicClock monotonicClock) {
        super(scheduledExecutorServiceForUiThread, animatedDrawableBackend, animatedDrawableDiagnostics, monotonicClock);
    }

    @Override
    public ValueAnimator createValueAnimator(int maxDurationMs) {
        ValueAnimator animator = this.createValueAnimator();
        int repeatCount = Math.max(maxDurationMs / this.getAnimatedDrawableBackend().getDurationMs(), 1);
        animator.setRepeatCount(repeatCount);
        return animator;
    }

    @Override
    public ValueAnimator createValueAnimator() {
        int loopCount = this.getAnimatedDrawableBackend().getLoopCount();
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, this.getDuration()});
        animator.setDuration((long)this.getDuration());
        animator.setRepeatCount(loopCount != 0 ? loopCount : -1);
        animator.setRepeatMode(1);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(this.createAnimatorUpdateListener());
        return animator;
    }

    @Override
    public ValueAnimator.AnimatorUpdateListener createAnimatorUpdateListener() {
        return new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                AnimatedDrawable.this.setLevel((Integer)animation.getAnimatedValue());
            }
        };
    }
}

