/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.base;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.time.MonotonicClock;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.imagepipeline.animated.base.AnimatedDrawable;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableCachingBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableDiagnostics;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAnimatedDrawable
extends Drawable
implements Animatable,
DrawableWithCaches {
    private static final Class<?> TAG = AnimatedDrawable.class;
    private static final long WATCH_DOG_TIMER_POLL_INTERVAL_MS = 2000L;
    private static final long WATCH_DOG_TIMER_MIN_TIMEOUT_MS = 1000L;
    private static final int POLL_FOR_RENDERED_FRAME_MS = 5;
    private static final int NO_FRAME = -1;
    private final ScheduledExecutorService mScheduledExecutorServiceForUiThread;
    private final AnimatedDrawableDiagnostics mAnimatedDrawableDiagnostics;
    private final MonotonicClock mMonotonicClock;
    private final int mDurationMs;
    private final int mFrameCount;
    private final int mTotalLoops;
    private final Paint mPaint = new Paint(6);
    private final Rect mDstRect = new Rect();
    private final Paint mTransparentPaint;
    private volatile String mLogId;
    private AnimatedDrawableCachingBackend mAnimatedDrawableBackend;
    private long mStartTimeMs;
    private int mScheduledFrameNumber;
    private int mScheduledFrameMonotonicNumber;
    private int mPendingRenderedFrameNumber;
    private int mPendingRenderedFrameMonotonicNumber;
    private int mLastDrawnFrameNumber = -1;
    private int mLastDrawnFrameMonotonicNumber = -1;
    private CloseableReference<Bitmap> mLastDrawnFrame;
    private boolean mWaitingForDraw;
    private long mLastInvalidateTimeMs = -1L;
    private boolean mIsRunning;
    private boolean mHaveWatchdogScheduled;
    private float mSx = 1.0f;
    private float mSy = 1.0f;
    private boolean mApplyTransformation;
    private boolean mInvalidateTaskScheduled;
    private long mNextFrameTaskMs = -1L;
    private final Runnable mStartTask = new Runnable(){

        @Override
        public void run() {
            AbstractAnimatedDrawable.this.onStart();
        }
    };
    private final Runnable mNextFrameTask = new Runnable(){

        @Override
        public void run() {
            FLog.v((Class)TAG, (String)"(%s) Next Frame Task", (Object)AbstractAnimatedDrawable.this.mLogId);
            AbstractAnimatedDrawable.this.onNextFrame();
        }
    };
    private final Runnable mInvalidateTask = new Runnable(){

        @Override
        public void run() {
            FLog.v((Class)TAG, (String)"(%s) Invalidate Task", (Object)AbstractAnimatedDrawable.this.mLogId);
            AbstractAnimatedDrawable.this.mInvalidateTaskScheduled = false;
            AbstractAnimatedDrawable.this.doInvalidateSelf();
        }
    };
    private final Runnable mWatchdogTask = new Runnable(){

        @Override
        public void run() {
            FLog.v((Class)TAG, (String)"(%s) Watchdog Task", (Object)AbstractAnimatedDrawable.this.mLogId);
            AbstractAnimatedDrawable.this.doWatchdogCheck();
        }
    };

    public AbstractAnimatedDrawable(ScheduledExecutorService scheduledExecutorServiceForUiThread, AnimatedDrawableCachingBackend animatedDrawableBackend, AnimatedDrawableDiagnostics animatedDrawableDiagnostics, MonotonicClock monotonicClock) {
        this.mScheduledExecutorServiceForUiThread = scheduledExecutorServiceForUiThread;
        this.mAnimatedDrawableBackend = animatedDrawableBackend;
        this.mAnimatedDrawableDiagnostics = animatedDrawableDiagnostics;
        this.mMonotonicClock = monotonicClock;
        this.mDurationMs = this.mAnimatedDrawableBackend.getDurationMs();
        this.mFrameCount = this.mAnimatedDrawableBackend.getFrameCount();
        this.mAnimatedDrawableDiagnostics.setBackend(this.mAnimatedDrawableBackend);
        this.mTotalLoops = this.mAnimatedDrawableBackend.getLoopCount();
        this.mTransparentPaint = new Paint();
        this.mTransparentPaint.setColor(0);
        this.mTransparentPaint.setStyle(Paint.Style.FILL);
        this.resetToPreviewFrame();
    }

    private void resetToPreviewFrame() {
        this.mScheduledFrameMonotonicNumber = this.mScheduledFrameNumber = this.mAnimatedDrawableBackend.getFrameForPreview();
        this.mPendingRenderedFrameNumber = -1;
        this.mPendingRenderedFrameMonotonicNumber = -1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mLastDrawnFrame != null) {
            this.mLastDrawnFrame.close();
            this.mLastDrawnFrame = null;
        }
    }

    public void setLogId(String logId) {
        this.mLogId = logId;
    }

    public int getIntrinsicWidth() {
        return this.mAnimatedDrawableBackend.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mAnimatedDrawableBackend.getHeight();
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
        this.doInvalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
        this.doInvalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mApplyTransformation = true;
        if (this.mLastDrawnFrame != null) {
            this.mLastDrawnFrame.close();
            this.mLastDrawnFrame = null;
        }
        this.mLastDrawnFrameNumber = -1;
        this.mLastDrawnFrameMonotonicNumber = -1;
        this.mAnimatedDrawableBackend.dropCaches();
    }

    private void onStart() {
        if (!this.mIsRunning) {
            return;
        }
        this.mAnimatedDrawableDiagnostics.onStartMethodBegin();
        try {
            this.mStartTimeMs = this.mMonotonicClock.now();
            this.mScheduledFrameNumber = 0;
            this.mScheduledFrameMonotonicNumber = 0;
            long nextFrameMs = this.mStartTimeMs + (long)this.mAnimatedDrawableBackend.getDurationMsForFrame(0);
            this.scheduleSelf(this.mNextFrameTask, nextFrameMs);
            this.mNextFrameTaskMs = nextFrameMs;
            this.doInvalidateSelf();
        }
        finally {
            this.mAnimatedDrawableDiagnostics.onStartMethodEnd();
        }
    }

    private void onNextFrame() {
        this.mNextFrameTaskMs = -1L;
        if (!this.mIsRunning) {
            return;
        }
        if (this.mDurationMs == 0) {
            return;
        }
        this.mAnimatedDrawableDiagnostics.onNextFrameMethodBegin();
        try {
            this.computeAndScheduleNextFrame(true);
        }
        finally {
            this.mAnimatedDrawableDiagnostics.onNextFrameMethodEnd();
        }
    }

    private void computeAndScheduleNextFrame(boolean scheduleNextFrame) {
        if (this.mDurationMs == 0) {
            return;
        }
        long nowMs = this.mMonotonicClock.now();
        int loops = (int)((nowMs - this.mStartTimeMs) / (long)this.mDurationMs);
        if (this.mTotalLoops > 0 && loops >= this.mTotalLoops) {
            return;
        }
        int timestampMs = (int)((nowMs - this.mStartTimeMs) % (long)this.mDurationMs);
        int newCurrentFrameNumber = this.mAnimatedDrawableBackend.getFrameForTimestampMs(timestampMs);
        boolean changed = this.mScheduledFrameNumber != newCurrentFrameNumber;
        this.mScheduledFrameNumber = newCurrentFrameNumber;
        this.mScheduledFrameMonotonicNumber = loops * this.mFrameCount + newCurrentFrameNumber;
        if (!scheduleNextFrame) {
            return;
        }
        if (changed) {
            this.doInvalidateSelf();
        } else {
            int durationMs = this.mAnimatedDrawableBackend.getTimestampMsForFrame(this.mScheduledFrameNumber) + this.mAnimatedDrawableBackend.getDurationMsForFrame(this.mScheduledFrameNumber) - timestampMs;
            int nextFrame = (this.mScheduledFrameNumber + 1) % this.mFrameCount;
            long nextFrameMs = nowMs + (long)durationMs;
            if (this.mNextFrameTaskMs == -1L || this.mNextFrameTaskMs > nextFrameMs) {
                FLog.v(TAG, (String)"(%s) Next frame (%d) in %d ms", (Object)this.mLogId, (Object)nextFrame, (Object)durationMs);
                this.unscheduleSelf(this.mNextFrameTask);
                this.scheduleSelf(this.mNextFrameTask, nextFrameMs);
                this.mNextFrameTaskMs = nextFrameMs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Canvas canvas) {
        this.mAnimatedDrawableDiagnostics.onDrawMethodBegin();
        try {
            CloseableReference<Bitmap> previewBitmapReference;
            boolean rendered;
            this.mWaitingForDraw = false;
            if (this.mIsRunning && !this.mHaveWatchdogScheduled) {
                this.mScheduledExecutorServiceForUiThread.schedule(this.mWatchdogTask, 2000L, TimeUnit.MILLISECONDS);
                this.mHaveWatchdogScheduled = true;
            }
            if (this.mApplyTransformation) {
                this.mDstRect.set(this.getBounds());
                if (!this.mDstRect.isEmpty()) {
                    AnimatedDrawableCachingBackend newBackend = this.mAnimatedDrawableBackend.forNewBounds(this.mDstRect);
                    if (newBackend != this.mAnimatedDrawableBackend) {
                        this.mAnimatedDrawableBackend.dropCaches();
                        this.mAnimatedDrawableBackend = newBackend;
                        this.mAnimatedDrawableDiagnostics.setBackend(newBackend);
                    }
                    this.mSx = (float)this.mDstRect.width() / (float)this.mAnimatedDrawableBackend.getRenderedWidth();
                    this.mSy = (float)this.mDstRect.height() / (float)this.mAnimatedDrawableBackend.getRenderedHeight();
                    this.mApplyTransformation = false;
                }
            }
            if (this.mDstRect.isEmpty()) {
                return;
            }
            canvas.save();
            canvas.scale(this.mSx, this.mSy);
            boolean didDrawFrame = false;
            if (this.mPendingRenderedFrameNumber != -1) {
                rendered = this.renderFrame(canvas, this.mPendingRenderedFrameNumber, this.mPendingRenderedFrameMonotonicNumber);
                didDrawFrame |= rendered;
                if (rendered) {
                    FLog.v(TAG, (String)"(%s) Rendered pending frame %d", (Object)this.mLogId, (Object)this.mPendingRenderedFrameNumber);
                    this.mPendingRenderedFrameNumber = -1;
                    this.mPendingRenderedFrameMonotonicNumber = -1;
                } else {
                    FLog.v(TAG, (String)"(%s) Trying again later for pending %d", (Object)this.mLogId, (Object)this.mPendingRenderedFrameNumber);
                    this.scheduleInvalidatePoll();
                }
            }
            if (this.mPendingRenderedFrameNumber == -1) {
                if (this.mIsRunning) {
                    this.computeAndScheduleNextFrame(false);
                }
                rendered = this.renderFrame(canvas, this.mScheduledFrameNumber, this.mScheduledFrameMonotonicNumber);
                didDrawFrame |= rendered;
                if (rendered) {
                    FLog.v(TAG, (String)"(%s) Rendered current frame %d", (Object)this.mLogId, (Object)this.mScheduledFrameNumber);
                    if (this.mIsRunning) {
                        this.computeAndScheduleNextFrame(true);
                    }
                } else {
                    FLog.v(TAG, (String)"(%s) Trying again later for current %d", (Object)this.mLogId, (Object)this.mScheduledFrameNumber);
                    this.mPendingRenderedFrameNumber = this.mScheduledFrameNumber;
                    this.mPendingRenderedFrameMonotonicNumber = this.mScheduledFrameMonotonicNumber;
                    this.scheduleInvalidatePoll();
                }
            }
            if (!didDrawFrame && this.mLastDrawnFrame != null) {
                canvas.drawBitmap((Bitmap)this.mLastDrawnFrame.get(), 0.0f, 0.0f, this.mPaint);
                didDrawFrame = true;
                FLog.v(TAG, (String)"(%s) Rendered last known frame %d", (Object)this.mLogId, (Object)this.mLastDrawnFrameNumber);
            }
            if (!didDrawFrame && (previewBitmapReference = this.mAnimatedDrawableBackend.getPreviewBitmap()) != null) {
                canvas.drawBitmap((Bitmap)previewBitmapReference.get(), 0.0f, 0.0f, this.mPaint);
                previewBitmapReference.close();
                FLog.v(TAG, (String)"(%s) Rendered preview frame", (Object)this.mLogId);
                didDrawFrame = true;
            }
            if (!didDrawFrame) {
                canvas.drawRect(0.0f, 0.0f, (float)this.mDstRect.width(), (float)this.mDstRect.height(), this.mTransparentPaint);
                FLog.v(TAG, (String)"(%s) Failed to draw a frame", (Object)this.mLogId);
            }
            canvas.restore();
            this.mAnimatedDrawableDiagnostics.drawDebugOverlay(canvas, this.mDstRect);
        }
        finally {
            this.mAnimatedDrawableDiagnostics.onDrawMethodEnd();
        }
    }

    private void scheduleInvalidatePoll() {
        if (this.mInvalidateTaskScheduled) {
            return;
        }
        this.mInvalidateTaskScheduled = true;
        this.scheduleSelf(this.mInvalidateTask, 5L);
    }

    public boolean didLastDrawRender() {
        return this.mLastDrawnFrame != null;
    }

    private boolean renderFrame(Canvas canvas, int frameNumber, int frameMonotonicNumber) {
        CloseableReference<Bitmap> bitmapReference = this.mAnimatedDrawableBackend.getBitmapForFrame(frameNumber);
        if (bitmapReference != null) {
            canvas.drawBitmap((Bitmap)bitmapReference.get(), 0.0f, 0.0f, this.mPaint);
            if (this.mLastDrawnFrame != null) {
                this.mLastDrawnFrame.close();
            }
            if (this.mIsRunning && frameMonotonicNumber > this.mLastDrawnFrameMonotonicNumber) {
                int droppedFrames = frameMonotonicNumber - this.mLastDrawnFrameMonotonicNumber - 1;
                this.mAnimatedDrawableDiagnostics.incrementDrawnFrames(1);
                this.mAnimatedDrawableDiagnostics.incrementDroppedFrames(droppedFrames);
                if (droppedFrames > 0) {
                    FLog.v(TAG, (String)"(%s) Dropped %d frames", (Object)this.mLogId, (Object)droppedFrames);
                }
            }
            this.mLastDrawnFrame = bitmapReference;
            this.mLastDrawnFrameNumber = frameNumber;
            this.mLastDrawnFrameMonotonicNumber = frameMonotonicNumber;
            FLog.v(TAG, (String)"(%s) Drew frame %d", (Object)this.mLogId, (Object)frameNumber);
            return true;
        }
        return false;
    }

    private void doWatchdogCheck() {
        boolean hasNotAdvancedFrameWithinTimeout;
        this.mHaveWatchdogScheduled = false;
        if (!this.mIsRunning) {
            return;
        }
        long now = this.mMonotonicClock.now();
        boolean hasNotDrawnWithinTimeout = this.mWaitingForDraw && now - this.mLastInvalidateTimeMs > 1000L;
        boolean bl = hasNotAdvancedFrameWithinTimeout = this.mNextFrameTaskMs != -1L && now - this.mNextFrameTaskMs > 1000L;
        if (hasNotDrawnWithinTimeout || hasNotAdvancedFrameWithinTimeout) {
            this.dropCaches();
            this.doInvalidateSelf();
        } else {
            this.mScheduledExecutorServiceForUiThread.schedule(this.mWatchdogTask, 2000L, TimeUnit.MILLISECONDS);
            this.mHaveWatchdogScheduled = true;
        }
    }

    private void doInvalidateSelf() {
        this.mWaitingForDraw = true;
        this.mLastInvalidateTimeMs = this.mMonotonicClock.now();
        this.invalidateSelf();
    }

    @VisibleForTesting
    boolean isWaitingForDraw() {
        return this.mWaitingForDraw;
    }

    @VisibleForTesting
    boolean isWaitingForNextFrame() {
        return this.mNextFrameTaskMs != -1L;
    }

    @VisibleForTesting
    int getScheduledFrameNumber() {
        return this.mScheduledFrameNumber;
    }

    public void start() {
        if (this.mDurationMs == 0 || this.mFrameCount <= 1) {
            return;
        }
        this.mIsRunning = true;
        this.scheduleSelf(this.mStartTask, this.mMonotonicClock.now());
    }

    public void stop() {
        this.mIsRunning = false;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    protected boolean onLevelChange(int level) {
        if (this.mIsRunning) {
            return false;
        }
        int frame = this.mAnimatedDrawableBackend.getFrameForTimestampMs(level);
        if (frame == this.mScheduledFrameNumber) {
            return false;
        }
        try {
            this.mScheduledFrameNumber = frame;
            this.mScheduledFrameMonotonicNumber = frame;
            this.doInvalidateSelf();
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void dropCaches() {
        FLog.v(TAG, (String)"(%s) Dropping caches", (Object)this.mLogId);
        if (this.mLastDrawnFrame != null) {
            this.mLastDrawnFrame.close();
            this.mLastDrawnFrame = null;
            this.mLastDrawnFrameNumber = -1;
            this.mLastDrawnFrameMonotonicNumber = -1;
        }
        this.mAnimatedDrawableBackend.dropCaches();
    }

    protected int getDuration() {
        return this.mDurationMs;
    }

    protected AnimatedDrawableCachingBackend getAnimatedDrawableBackend() {
        return this.mAnimatedDrawableBackend;
    }
}

