/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.flipper.plugins.fresco;

import android.graphics.Bitmap;
import android.util.Base64;
import android.util.Pair;
import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.common.internal.ByteStreams;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferInputStream;
import com.facebook.common.memory.manager.DebugMemoryManager;
import com.facebook.common.memory.manager.NoOpDebugMemoryManager;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.SharedReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.info.ImageOriginUtils;
import com.facebook.drawee.backends.pipeline.info.ImagePerfData;
import com.facebook.drawee.backends.pipeline.info.ImagePerfDataListener;
import com.facebook.flipper.core.FlipperArray;
import com.facebook.flipper.core.FlipperConnection;
import com.facebook.flipper.core.FlipperObject;
import com.facebook.flipper.core.FlipperReceiver;
import com.facebook.flipper.core.FlipperResponder;
import com.facebook.flipper.perflogger.FlipperPerfLogger;
import com.facebook.flipper.perflogger.NoOpFlipperPerfLogger;
import com.facebook.flipper.plugins.common.BufferingFlipperPlugin;
import com.facebook.flipper.plugins.fresco.FrescoFlipperDebugPrefHelper;
import com.facebook.flipper.plugins.fresco.objecthelper.FlipperObjectHelper;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCacheInspector;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.debug.CloseableReferenceLeakTracker;
import com.facebook.imagepipeline.debug.DebugImageTracker;
import com.facebook.imagepipeline.debug.FlipperImageTracker;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imageutils.BitmapUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class FrescoFlipperPlugin
extends BufferingFlipperPlugin
implements ImagePerfDataListener,
CloseableReferenceLeakTracker.Listener {
    private static final String FRESCO_EVENT = "events";
    private static final String FRESCO_DEBUGOVERLAY_EVENT = "debug_overlay_event";
    private static final String FRESCO_CLOSEABLE_REFERENCE_LEAK_EVENT = "closeable_reference_leak_event";
    private static final int BITMAP_PREVIEW_WIDTH = 150;
    private static final int BITMAP_PREVIEW_HEIGHT = 150;
    private static final int BITMAP_SCALING_THRESHOLD_WIDTH = 200;
    private static final int BITMAP_SCALING_THRESHOLD_HEIGHT = 200;
    private static final Predicate<CacheKey> ALWAYS_TRUE_PREDICATE = new Predicate<CacheKey>(){

        public boolean apply(CacheKey cacheKey) {
            return true;
        }
    };
    private final FlipperImageTracker mFlipperImageTracker;
    private final PlatformBitmapFactory mPlatformBitmapFactory;
    @Nullable
    private final FlipperObjectHelper mSonarObjectHelper;
    private final DebugMemoryManager mMemoryManager;
    private final FlipperPerfLogger mPerfLogger;
    @Nullable
    private final FrescoFlipperDebugPrefHelper mDebugPrefHelper;
    private final List<FlipperObject> mEvents = new ArrayList<FlipperObject>();

    public FrescoFlipperPlugin(DebugImageTracker imageTracker, PlatformBitmapFactory bitmapFactory, @Nullable FlipperObjectHelper flipperObjectHelper, DebugMemoryManager memoryManager, FlipperPerfLogger perfLogger, @Nullable FrescoFlipperDebugPrefHelper debugPrefHelper, @Nullable CloseableReferenceLeakTracker closeableReferenceLeakTracker) {
        this.mFlipperImageTracker = imageTracker instanceof FlipperImageTracker ? (FlipperImageTracker)imageTracker : new FlipperImageTracker();
        this.mPlatformBitmapFactory = bitmapFactory;
        this.mSonarObjectHelper = flipperObjectHelper;
        this.mMemoryManager = memoryManager;
        this.mPerfLogger = perfLogger;
        this.mDebugPrefHelper = debugPrefHelper;
        if (closeableReferenceLeakTracker != null) {
            closeableReferenceLeakTracker.setListener((CloseableReferenceLeakTracker.Listener)this);
        }
    }

    public FrescoFlipperPlugin() {
        this((DebugImageTracker)new FlipperImageTracker(), Fresco.getImagePipelineFactory().getPlatformBitmapFactory(), null, (DebugMemoryManager)new NoOpDebugMemoryManager(), (FlipperPerfLogger)new NoOpFlipperPerfLogger(), null, null);
    }

    public FlipperImageTracker getFlipperImageTracker() {
        return this.mFlipperImageTracker;
    }

    public String getId() {
        return "Fresco";
    }

    public void onConnect(FlipperConnection connection) {
        super.onConnect(connection);
        connection.receive("getAllImageEventsInfo", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                FlipperArray.Builder arrayBuilder = new FlipperArray.Builder();
                for (FlipperObject obj : FrescoFlipperPlugin.this.mEvents) {
                    arrayBuilder.put(obj);
                }
                FrescoFlipperPlugin.this.mEvents.clear();
                FlipperObject object = new FlipperObject.Builder().put(FrescoFlipperPlugin.FRESCO_EVENT, arrayBuilder.build()).build();
                responder.success(object);
            }
        });
        connection.receive("listImages", new FlipperReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                FrescoFlipperPlugin.this.mPerfLogger.startMarker("Sonar.Fresco.listImages");
                boolean showDiskImages = params.getBoolean("showDiskImages");
                ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
                CountingMemoryCacheInspector.DumpInfo bitmapMemoryCache = new CountingMemoryCacheInspector(imagePipelineFactory.getBitmapCountingMemoryCache()).dumpCacheContent();
                CountingMemoryCacheInspector.DumpInfo encodedMemoryCache = new CountingMemoryCacheInspector(imagePipelineFactory.getEncodedCountingMemoryCache()).dumpCacheContent();
                try {
                    responder.success(FrescoFlipperPlugin.this.getImageList(bitmapMemoryCache, encodedMemoryCache, showDiskImages));
                    FrescoFlipperPlugin.this.mPerfLogger.endMarker("Sonar.Fresco.listImages");
                }
                finally {
                    bitmapMemoryCache.release();
                    encodedMemoryCache.release();
                }
            }
        });
        connection.receive("getImage", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                Bitmap bitmap;
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                FrescoFlipperPlugin.this.mPerfLogger.startMarker("Sonar.Fresco.getImage");
                String imageId = params.getString("imageId");
                CacheKey cacheKey = FrescoFlipperPlugin.this.mFlipperImageTracker.getCacheKey(imageId);
                if (cacheKey == null) {
                    FrescoFlipperPlugin.respondError(responder, "ImageId " + imageId + " was evicted from cache");
                    FrescoFlipperPlugin.this.mPerfLogger.cancelMarker("Sonar.Fresco.getImage");
                    return;
                }
                ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
                CloseableImage closeableImage = (CloseableImage)imagePipelineFactory.getBitmapCountingMemoryCache().inspect((Object)cacheKey);
                if (closeableImage instanceof CloseableBitmap && (bitmap = ((CloseableBitmap)closeableImage).getUnderlyingBitmap()) != null) {
                    this.loadFromBitmapCache(bitmap, imageId, cacheKey, responder);
                    FrescoFlipperPlugin.this.mPerfLogger.endMarker("Sonar.Fresco.getImage");
                    return;
                }
                PooledByteBuffer encoded = (PooledByteBuffer)imagePipelineFactory.getEncodedCountingMemoryCache().inspect((Object)cacheKey);
                if (encoded != null) {
                    this.loadFromEncodedCache(encoded, imageId, cacheKey, responder);
                    FrescoFlipperPlugin.this.mPerfLogger.endMarker("Sonar.Fresco.getImage");
                    return;
                }
                this.loadFromDisk(imageId, cacheKey, responder);
            }

            private void loadFromBitmapCache(Bitmap bitmap, String imageId, CacheKey cacheKey, FlipperResponder responder) {
                String encodedBitmap = FrescoFlipperPlugin.this.bitmapToBase64Preview(bitmap, FrescoFlipperPlugin.this.mPlatformBitmapFactory);
                responder.success(FrescoFlipperPlugin.getImageData(imageId, FrescoFlipperPlugin.this.mFlipperImageTracker.getUriString(cacheKey), bitmap.getWidth(), bitmap.getHeight(), BitmapUtil.getSizeInBytes((Bitmap)bitmap), encodedBitmap));
            }

            private void loadFromEncodedCache(PooledByteBuffer encoded, String imageId, CacheKey cacheKey, FlipperResponder responder) throws Exception {
                byte[] encodedArray = ByteStreams.toByteArray((InputStream)new PooledByteBufferInputStream(encoded));
                Pair dimensions = BitmapUtil.decodeDimensions((byte[])encodedArray);
                if (dimensions == null) {
                    FrescoFlipperPlugin.respondError(responder, "can not get dimensions withId=" + imageId);
                    return;
                }
                responder.success(FrescoFlipperPlugin.getImageData(imageId, FrescoFlipperPlugin.this.mFlipperImageTracker.getUriString(cacheKey), (Integer)dimensions.first, (Integer)dimensions.second, encodedArray.length, FrescoFlipperPlugin.dataFromEncodedArray(encodedArray)));
            }

            private void loadFromDisk(final String imageId, final CacheKey cacheKey, final FlipperResponder responder) {
                Task t = Fresco.getImagePipelineFactory().getMainBufferedDiskCache().get(cacheKey, new AtomicBoolean(false));
                t.continueWith((Continuation)new Continuation<EncodedImage, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void then(Task<EncodedImage> task) throws Exception {
                        if (task.isCancelled() || task.isFaulted()) {
                            FrescoFlipperPlugin.respondError(responder, "no bitmap withId=" + imageId);
                            FrescoFlipperPlugin.this.mPerfLogger.cancelMarker("Sonar.Fresco.getImage");
                            return null;
                        }
                        Preconditions.checkNotNull(task);
                        EncodedImage image = (EncodedImage)task.getResult();
                        try {
                            InputStream stream = (InputStream)Preconditions.checkNotNull((Object)image.getInputStream());
                            byte[] encodedArray = ByteStreams.toByteArray((InputStream)stream);
                            responder.success(FrescoFlipperPlugin.getImageData(imageId, (String)Preconditions.checkNotNull((Object)FrescoFlipperPlugin.this.mFlipperImageTracker.getLocalPath(cacheKey)), image.getWidth(), image.getHeight(), encodedArray.length, FrescoFlipperPlugin.dataFromEncodedArray(encodedArray)));
                        }
                        finally {
                            EncodedImage.closeSafely((EncodedImage)image);
                        }
                        FrescoFlipperPlugin.this.mPerfLogger.endMarker("Sonar.Fresco.getImage");
                        return null;
                    }
                });
            }
        });
        connection.receive("clear", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) {
                String type;
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                FrescoFlipperPlugin.this.mPerfLogger.startMarker("Sonar.Fresco.clear");
                switch (type = params.getString("type")) {
                    case "memory": {
                        ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
                        imagePipelineFactory.getBitmapMemoryCache().removeAll(ALWAYS_TRUE_PREDICATE);
                        break;
                    }
                    case "disk": {
                        Fresco.getImagePipeline().clearDiskCaches();
                    }
                }
                FrescoFlipperPlugin.this.mPerfLogger.endMarker("Sonar.Fresco.clear");
            }
        });
        connection.receive("trimMemory", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                if (FrescoFlipperPlugin.this.mMemoryManager != null) {
                    FrescoFlipperPlugin.this.mMemoryManager.trimMemory(2);
                }
            }
        });
        connection.receive("enableDebugOverlay", new FlipperReceiver(){

            public void onReceive(FlipperObject params, FlipperResponder responder) throws Exception {
                if (!FrescoFlipperPlugin.this.ensureFrescoInitialized()) {
                    return;
                }
                boolean enabled = params.getBoolean("enabled");
                if (FrescoFlipperPlugin.this.mDebugPrefHelper != null) {
                    FrescoFlipperPlugin.this.mDebugPrefHelper.setDebugOverlayEnabled(enabled);
                }
            }
        });
        if (this.mDebugPrefHelper != null) {
            this.mDebugPrefHelper.setDebugOverlayEnabledListener(new FrescoFlipperDebugPrefHelper.Listener(){

                @Override
                public void onEnabledStatusChanged(boolean enabled) {
                    FrescoFlipperPlugin.this.sendDebugOverlayEnabledEvent(enabled);
                }
            });
            this.sendDebugOverlayEnabledEvent(this.mDebugPrefHelper.isDebugOverlayEnabled());
        }
    }

    private static String dataFromEncodedArray(byte[] encodedArray) {
        return "data:image/jpeg;base64," + Base64.encodeToString((byte[])encodedArray, (int)0);
    }

    private FlipperObject getImageList(CountingMemoryCacheInspector.DumpInfo bitmapMemoryCache, CountingMemoryCacheInspector.DumpInfo encodedMemoryCache, boolean showDiskImages) throws IOException {
        FlipperArray.Builder levelsBuilder = new FlipperArray.Builder().put(this.getUsedStats("On screen bitmaps", bitmapMemoryCache)).put(this.getCachedStats("Bitmap memory cache", bitmapMemoryCache)).put(this.getUsedStats("Used encoded images", encodedMemoryCache)).put(this.getCachedStats("Cached encoded images", encodedMemoryCache));
        if (showDiskImages) {
            levelsBuilder.put(this.getDiskStats("Disk images", Fresco.getImagePipelineFactory().getMainFileCache().getDumpInfo().entries));
        }
        return new FlipperObject.Builder().put("levels", levelsBuilder.build()).build();
    }

    private FlipperObject getUsedStats(String cacheType, CountingMemoryCacheInspector.DumpInfo memoryCache) {
        return new FlipperObject.Builder().put("cacheType", cacheType).put("sizeBytes", Integer.valueOf(memoryCache.size - memoryCache.lruSize)).put("imageIds", this.buildImageIdList(memoryCache.sharedEntries)).build();
    }

    private FlipperObject getCachedStats(String cacheType, CountingMemoryCacheInspector.DumpInfo memoryCache) {
        return new FlipperObject.Builder().put("cacheType", cacheType).put("clearKey", "memory").put("sizeBytes", Integer.valueOf(memoryCache.size)).put("maxSizeBytes", Integer.valueOf(memoryCache.maxSize)).put("imageIds", this.buildImageIdList(memoryCache.lruEntries)).build();
    }

    private FlipperObject getDiskStats(String cacheType, List<DiskStorage.DiskDumpInfoEntry> diskEntries) {
        return new FlipperObject.Builder().put("cacheType", cacheType).put("clearKey", "disk").put("sizeBytes", Long.valueOf(Fresco.getImagePipelineFactory().getMainFileCache().getSize())).put("imageIds", this.buildImageIdListDisk(diskEntries)).build();
    }

    private static FlipperObject getImageData(String imageID, String uriString, int width, int height, int sizeBytes, String data) {
        return new FlipperObject.Builder().put("imageId", imageID).put("uri", uriString).put("width", Integer.valueOf(width)).put("height", Integer.valueOf(height)).put("sizeBytes", Integer.valueOf(sizeBytes)).put("data", data).build();
    }

    private boolean ensureFrescoInitialized() {
        this.mPerfLogger.startMarker("Sonar.Fresco.ensureFrescoInitialized");
        try {
            Fresco.getImagePipelineFactory();
            boolean bl = true;
            return bl;
        }
        catch (NullPointerException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.mPerfLogger.endMarker("Sonar.Fresco.ensureFrescoInitialized");
        }
    }

    private FlipperArray buildImageIdList(List<CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage>> images) {
        FlipperArray.Builder builder = new FlipperArray.Builder();
        for (CountingMemoryCacheInspector.DumpInfoEntry<CacheKey, CloseableImage> entry : images) {
            FlipperImageTracker.ImageDebugData imageDebugData = this.mFlipperImageTracker.getImageDebugData((CacheKey)entry.key);
            if (imageDebugData == null) {
                builder.put(this.mFlipperImageTracker.trackImage((CacheKey)entry.key).getUniqueId());
                continue;
            }
            builder.put(imageDebugData.getUniqueId());
        }
        return builder.build();
    }

    private FlipperArray buildImageIdListDisk(List<DiskStorage.DiskDumpInfoEntry> diskEntries) {
        FlipperArray.Builder builder = new FlipperArray.Builder();
        for (DiskStorage.DiskDumpInfoEntry entry : diskEntries) {
            SimpleCacheKey entryCacheKey = new SimpleCacheKey(entry.id, true);
            FlipperImageTracker.ImageDebugData imageDebugData = this.mFlipperImageTracker.getImageDebugData((CacheKey)entryCacheKey);
            if (imageDebugData == null) {
                builder.put(this.mFlipperImageTracker.trackImage(entry.path, (CacheKey)entryCacheKey).getUniqueId());
                continue;
            }
            builder.put(imageDebugData.getUniqueId());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bitmapToBase64Preview(Bitmap bitmap, PlatformBitmapFactory bitmapFactory) {
        String string;
        if (bitmap.getWidth() < 200 && bitmap.getHeight() < 200) {
            return this.bitmapToBase64WithoutScaling(bitmap);
        }
        this.mPerfLogger.startMarker("Sonar.Fresco.bitmap2base64-resize");
        CloseableReference scaledBitmapReference = null;
        try {
            int scaledHeight;
            int scaledWidth;
            float previewAspectRatio = 1.0f;
            float imageAspectRatio = bitmap.getWidth() / bitmap.getHeight();
            if (previewAspectRatio > imageAspectRatio) {
                scaledWidth = bitmap.getWidth() * 150 / bitmap.getHeight();
                scaledHeight = 150;
            } else {
                scaledWidth = 150;
                scaledHeight = bitmap.getHeight() * 150 / bitmap.getWidth();
            }
            scaledBitmapReference = bitmapFactory.createScaledBitmap(bitmap, scaledWidth, scaledHeight, false);
            string = this.bitmapToBase64WithoutScaling((Bitmap)scaledBitmapReference.get());
        }
        catch (Throwable throwable) {
            CloseableReference.closeSafely(scaledBitmapReference);
            this.mPerfLogger.endMarker("Sonar.Fresco.bitmap2base64-resize");
            throw throwable;
        }
        CloseableReference.closeSafely((CloseableReference)scaledBitmapReference);
        this.mPerfLogger.endMarker("Sonar.Fresco.bitmap2base64-resize");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String bitmapToBase64WithoutScaling(Bitmap bitmap) {
        this.mPerfLogger.startMarker("Sonar.Fresco.bitmap2base64-orig");
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            String string = "data:image/png;base64," + Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)0);
            return string;
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.mPerfLogger.endMarker("Sonar.Fresco.bitmap2base64-orig");
        }
    }

    public void onImageLoadStatusUpdated(ImagePerfData imagePerfData, int imageLoadStatus) {
        if (imageLoadStatus != 3) {
            return;
        }
        String requestId = imagePerfData.getRequestId();
        if (requestId == null) {
            return;
        }
        FlipperImageTracker.ImageDebugData data = this.mFlipperImageTracker.getDebugDataForRequestId(requestId);
        if (data == null) {
            return;
        }
        FlipperArray.Builder imageIdsBuilder = new FlipperArray.Builder();
        Set cks = data.getCacheKeys();
        if (cks != null) {
            for (CacheKey ck : cks) {
                FlipperImageTracker.ImageDebugData d = this.mFlipperImageTracker.getImageDebugData(ck);
                if (d == null) continue;
                imageIdsBuilder.put(d.getUniqueId());
            }
        } else {
            imageIdsBuilder.put(data.getUniqueId());
        }
        Object callerContext = imagePerfData.getCallerContext();
        FlipperArray attribution = callerContext == null ? new FlipperArray.Builder().put("unknown").build() : (this.mSonarObjectHelper == null ? new FlipperArray.Builder().put(callerContext.toString()).build() : this.mSonarObjectHelper.fromCallerContext(callerContext));
        FlipperObject.Builder response = new FlipperObject.Builder().put("imageIds", imageIdsBuilder.build()).put("attribution", attribution).put("startTime", Long.valueOf(imagePerfData.getControllerSubmitTimeMs())).put("endTime", Long.valueOf(imagePerfData.getControllerFinalImageSetTimeMs())).put("source", ImageOriginUtils.toString((int)imagePerfData.getImageOrigin()));
        if (!imagePerfData.isPrefetch()) {
            response.put("viewport", new FlipperObject.Builder().put("width", Integer.valueOf(imagePerfData.getOnScreenWidthPx())).put("height", Integer.valueOf(imagePerfData.getOnScreenHeightPx())).build());
        }
        FlipperObject responseObject = response.build();
        this.mEvents.add(responseObject);
        this.send(FRESCO_EVENT, responseObject);
    }

    public void onImageVisibilityUpdated(ImagePerfData imagePerfData, int visibilityState) {
    }

    public void sendDebugOverlayEnabledEvent(boolean enabled) {
        FlipperObject.Builder builder = new FlipperObject.Builder().put("enabled", Boolean.valueOf(enabled));
        this.send(FRESCO_DEBUGOVERLAY_EVENT, builder.build());
    }

    private static void respondError(FlipperResponder responder, String errorReason) {
        responder.error(new FlipperObject.Builder().put("reason", errorReason).build());
    }

    public void onCloseableReferenceLeak(SharedReference<Object> reference, @Nullable Throwable stacktrace) {
        Object object = reference.get();
        Preconditions.checkNotNull((Object)object);
        FlipperObject.Builder builder = new FlipperObject.Builder().put("identityHashCode", Integer.valueOf(System.identityHashCode(reference))).put("className", object.getClass().getName());
        if (stacktrace != null) {
            builder.put("stacktrace", FrescoFlipperPlugin.getStackTraceString(stacktrace));
        }
        this.send(FRESCO_CLOSEABLE_REFERENCE_LEAK_EVENT, builder.build());
    }

    public static String getStackTraceString(Throwable tr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        return sw.toString();
    }
}

