/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;

public class DelegateCodec<T>
implements ThriftCodec<T> {
    private final ThriftCodecManager codecManager;
    private final TypeToken<T> typeToken;

    public DelegateCodec(ThriftCodecManager codecManager, Type javaType) {
        this.codecManager = codecManager;
        this.typeToken = TypeToken.of((Type)javaType);
    }

    @Override
    public ThriftType getType() {
        return this.getCodec().getType();
    }

    @Override
    public T read(TProtocolReader protocol) throws Exception {
        return this.getCodec().read(protocol);
    }

    @Override
    public void write(T value, TProtocolWriter protocol) throws Exception {
        this.getCodec().write(value, protocol);
    }

    private ThriftCodec<T> getCodec() {
        ThriftCodec<T> codec = this.codecManager.getCachedCodecIfPresent(this.typeToken);
        if (codec == null) {
            throw new IllegalStateException("Tried to encode/decode using a DelegateCodec before the target codec was built (likely a bug in recursive type support)");
        }
        return codec;
    }
}

