/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift;

import com.facebook.drift.TException;
import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@ThriftStruct
public class TApplicationException
extends TException {
    private final int typeValue;
    private final Optional<Type> type;

    public TApplicationException() {
        this(Type.UNKNOWN, null);
    }

    public TApplicationException(Type type, String message) {
        super(message);
        Objects.requireNonNull(type, "type is null");
        this.type = Optional.of(type);
        this.typeValue = type.getType();
    }

    @ThriftConstructor
    public TApplicationException(int typeValue, String message) {
        super(message);
        this.typeValue = typeValue;
        this.type = Type.fromTypeId(typeValue);
    }

    @Override
    @ThriftField(value=1)
    public String getMessage() {
        return super.getMessage();
    }

    @ThriftField(value=2)
    public int getTypeValue() {
        return this.typeValue;
    }

    public Optional<Type> getType() {
        return this.type;
    }

    public static enum Type {
        UNKNOWN(0),
        UNKNOWN_METHOD(1),
        INVALID_MESSAGE_TYPE(2),
        WRONG_METHOD_NAME(3),
        BAD_SEQUENCE_ID(4),
        MISSING_RESULT(5),
        INTERNAL_ERROR(6),
        PROTOCOL_ERROR(7),
        INVALID_TRANSFORM(8),
        INVALID_PROTOCOL(9),
        UNSUPPORTED_CLIENT_TYPE(10);

        private final int type;
        private static final Map<Integer, Type> TYPES_BY_ID;

        private Type(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static Optional<Type> fromTypeId(int typeId) {
            return Optional.ofNullable(TYPES_BY_ID.get(typeId));
        }

        static {
            TYPES_BY_ID = Collections.unmodifiableMap(Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getType, Function.identity())));
        }
    }
}

