/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdNetworkAnalyticsSyncQueryResult
extends APINode {
    @SerializedName(value="query_id")
    private String mQueryId = null;
    @SerializedName(value="results")
    private List<Object> mResults = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdNetworkAnalyticsSyncQueryResult loadJSON(String json, APIContext context, String header) {
        AdNetworkAnalyticsSyncQueryResult adNetworkAnalyticsSyncQueryResult = (AdNetworkAnalyticsSyncQueryResult)AdNetworkAnalyticsSyncQueryResult.getGson().fromJson(json, AdNetworkAnalyticsSyncQueryResult.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adNetworkAnalyticsSyncQueryResult.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adNetworkAnalyticsSyncQueryResult.context = context;
        adNetworkAnalyticsSyncQueryResult.rawValue = json;
        adNetworkAnalyticsSyncQueryResult.header = header;
        return adNetworkAnalyticsSyncQueryResult;
    }

    public static APINodeList<AdNetworkAnalyticsSyncQueryResult> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdNetworkAnalyticsSyncQueryResult> adNetworkAnalyticsSyncQueryResults = new APINodeList<AdNetworkAnalyticsSyncQueryResult>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adNetworkAnalyticsSyncQueryResults.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adNetworkAnalyticsSyncQueryResults.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adNetworkAnalyticsSyncQueryResults.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adNetworkAnalyticsSyncQueryResults;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adNetworkAnalyticsSyncQueryResults;
                }
                adNetworkAnalyticsSyncQueryResults.clear();
                adNetworkAnalyticsSyncQueryResults.add(AdNetworkAnalyticsSyncQueryResult.loadJSON(json, context, header));
                return adNetworkAnalyticsSyncQueryResults;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdNetworkAnalyticsSyncQueryResult.getGson().toJson((Object)this);
    }

    public String getFieldQueryId() {
        return this.mQueryId;
    }

    public AdNetworkAnalyticsSyncQueryResult setFieldQueryId(String value) {
        this.mQueryId = value;
        return this;
    }

    public List<Object> getFieldResults() {
        return this.mResults;
    }

    public AdNetworkAnalyticsSyncQueryResult setFieldResults(List<Object> value) {
        this.mResults = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdNetworkAnalyticsSyncQueryResult copyFrom(AdNetworkAnalyticsSyncQueryResult instance) {
        this.mQueryId = instance.mQueryId;
        this.mResults = instance.mResults;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdNetworkAnalyticsSyncQueryResult> getParser() {
        return new APIRequest.ResponseParser<AdNetworkAnalyticsSyncQueryResult>(){

            @Override
            public APINodeList<AdNetworkAnalyticsSyncQueryResult> parseResponse(String response, APIContext context, APIRequest<AdNetworkAnalyticsSyncQueryResult> request, String header) throws APIException.MalformedResponseException {
                return AdNetworkAnalyticsSyncQueryResult.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOrderingType {
        VALUE_ASCENDING("ASCENDING"),
        VALUE_DESCENDING("DESCENDING");

        private String value;

        private EnumOrderingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumOrderingColumn {
        VALUE_METRIC("METRIC"),
        VALUE_TIME("TIME"),
        VALUE_VALUE("VALUE");

        private String value;

        private EnumOrderingColumn(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumMetrics {
        VALUE_FB_AD_NETWORK_BIDDING_BID_RATE("FB_AD_NETWORK_BIDDING_BID_RATE"),
        VALUE_FB_AD_NETWORK_BIDDING_REQUEST("FB_AD_NETWORK_BIDDING_REQUEST"),
        VALUE_FB_AD_NETWORK_BIDDING_RESPONSE("FB_AD_NETWORK_BIDDING_RESPONSE"),
        VALUE_FB_AD_NETWORK_BIDDING_REVENUE("FB_AD_NETWORK_BIDDING_REVENUE"),
        VALUE_FB_AD_NETWORK_BIDDING_WIN_RATE("FB_AD_NETWORK_BIDDING_WIN_RATE"),
        VALUE_FB_AD_NETWORK_CLICK("FB_AD_NETWORK_CLICK"),
        VALUE_FB_AD_NETWORK_CPM("FB_AD_NETWORK_CPM"),
        VALUE_FB_AD_NETWORK_CTR("FB_AD_NETWORK_CTR"),
        VALUE_FB_AD_NETWORK_FILLED_REQUEST("FB_AD_NETWORK_FILLED_REQUEST"),
        VALUE_FB_AD_NETWORK_FILL_RATE("FB_AD_NETWORK_FILL_RATE"),
        VALUE_FB_AD_NETWORK_IMP("FB_AD_NETWORK_IMP"),
        VALUE_FB_AD_NETWORK_IMPRESSION_RATE("FB_AD_NETWORK_IMPRESSION_RATE"),
        VALUE_FB_AD_NETWORK_REQUEST("FB_AD_NETWORK_REQUEST"),
        VALUE_FB_AD_NETWORK_REVENUE("FB_AD_NETWORK_REVENUE"),
        VALUE_FB_AD_NETWORK_SHOW_RATE("FB_AD_NETWORK_SHOW_RATE"),
        VALUE_FB_AD_NETWORK_VIDEO_GUARANTEE_REVENUE("FB_AD_NETWORK_VIDEO_GUARANTEE_REVENUE"),
        VALUE_FB_AD_NETWORK_VIDEO_MRC("FB_AD_NETWORK_VIDEO_MRC"),
        VALUE_FB_AD_NETWORK_VIDEO_MRC_RATE("FB_AD_NETWORK_VIDEO_MRC_RATE"),
        VALUE_FB_AD_NETWORK_VIDEO_VIEW("FB_AD_NETWORK_VIDEO_VIEW"),
        VALUE_FB_AD_NETWORK_VIDEO_VIEW_RATE("FB_AD_NETWORK_VIDEO_VIEW_RATE");

        private String value;

        private EnumMetrics(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumBreakdowns {
        VALUE_AD_SERVER_CAMPAIGN_ID("AD_SERVER_CAMPAIGN_ID"),
        VALUE_AD_SPACE("AD_SPACE"),
        VALUE_AGE("AGE"),
        VALUE_APP("APP"),
        VALUE_CLICKED_VIEW_TAG("CLICKED_VIEW_TAG"),
        VALUE_COUNTRY("COUNTRY"),
        VALUE_DEAL("DEAL"),
        VALUE_DEAL_AD("DEAL_AD"),
        VALUE_DEAL_PAGE("DEAL_PAGE"),
        VALUE_DELIVERY_METHOD("DELIVERY_METHOD"),
        VALUE_DISPLAY_FORMAT("DISPLAY_FORMAT"),
        VALUE_FAIL_REASON("FAIL_REASON"),
        VALUE_GENDER("GENDER"),
        VALUE_INSTANT_ARTICLE_ID("INSTANT_ARTICLE_ID"),
        VALUE_INSTANT_ARTICLE_PAGE_ID("INSTANT_ARTICLE_PAGE_ID"),
        VALUE_IS_DEAL_BACKFILL("IS_DEAL_BACKFILL"),
        VALUE_PLACEMENT("PLACEMENT"),
        VALUE_PLACEMENT_NAME("PLACEMENT_NAME"),
        VALUE_PLATFORM("PLATFORM"),
        VALUE_PROPERTY("PROPERTY"),
        VALUE_SDK_VERSION("SDK_VERSION");

        private String value;

        private EnumBreakdowns(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumAggregationPeriod {
        VALUE_DAY("DAY"),
        VALUE_TOTAL("TOTAL");

        private String value;

        private EnumAggregationPeriod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

