/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APIResponse;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public class APIException
extends Exception
implements APIResponse {
    private String header;

    public APIException() {
    }

    public APIException(Throwable e) {
        super(e);
    }

    public APIException(String message) {
        super(message);
    }

    public APIException(String message, Throwable e) {
        super(message, e);
    }

    public APIException(String header, String message, Throwable e) {
        super(message, e);
        this.header = header;
    }

    public APINode head() {
        return null;
    }

    public APIException getException() {
        return this;
    }

    public String getRawResponse() {
        return this.getMessage();
    }

    public JsonObject getRawResponseAsJsonObject() {
        JsonParser parser = new JsonParser();
        return parser.parse(this.getMessage()).getAsJsonObject();
    }

    public String getHeader() {
        return this.header;
    }

    public static class FailedRequestException
    extends APIException {
        public FailedRequestException() {
        }

        public FailedRequestException(Throwable e) {
            super(e);
        }

        public FailedRequestException(String message) {
            super(message);
        }

        public FailedRequestException(String message, Throwable e) {
            super(message, e);
        }

        public FailedRequestException(String header, String message, Throwable e) {
            super(header, message, e);
        }
    }

    public static class MalformedResponseException
    extends APIException {
        public MalformedResponseException() {
        }

        public MalformedResponseException(Throwable e) {
            super(e);
        }

        public MalformedResponseException(String message) {
            super(message);
        }

        public MalformedResponseException(String message, Throwable e) {
            super(message, e);
        }
    }
}

