/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk.signal;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.businessdataapi.EventResponse;
import com.facebook.ads.sdk.serverside.HttpServiceInterface;
import com.facebook.ads.sdk.signal.Event;
import com.facebook.ads.sdk.signal.SignalResponse;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRequest {
    private com.facebook.ads.sdk.businessdataapi.EventRequest businessDataEventRequest;
    private com.facebook.ads.sdk.serverside.EventRequest serverSideEventRequest;

    public EventRequest(String pixelId, String pageId, APIContext context) {
        this.businessDataEventRequest = new com.facebook.ads.sdk.businessdataapi.EventRequest(pageId, context);
        this.serverSideEventRequest = new com.facebook.ads.sdk.serverside.EventRequest(pixelId, context);
    }

    public EventRequest(String pixelId, String pageId, APIContext context, List<Event> data, String testEventCode, String partnerAgent, String namespaceId, String uploadId, String uploadTag, String uploadSource, HttpServiceInterface httpServiceClient) {
        this.setData(data);
        this.serverSideEventRequest = new com.facebook.ads.sdk.serverside.EventRequest(pixelId, context);
        this.serverSideEventRequest.setTestEventCode(testEventCode);
        this.serverSideEventRequest.setPartnerAgent(partnerAgent);
        this.serverSideEventRequest.setNamespaceId(namespaceId);
        this.serverSideEventRequest.setUploadId(uploadId);
        this.serverSideEventRequest.setUploadTag(uploadTag);
        this.serverSideEventRequest.setUploadSource(uploadSource);
        this.serverSideEventRequest.setHttpServiceClient(httpServiceClient);
        this.businessDataEventRequest = new com.facebook.ads.sdk.businessdataapi.EventRequest(pageId, context);
        this.businessDataEventRequest.setPartnerAgent(partnerAgent);
    }

    public EventRequest data(List<Event> data) {
        this.setData(data);
        return this;
    }

    public SignalResponse<List<com.facebook.ads.sdk.serverside.Event>, List<com.facebook.ads.sdk.businessdataapi.Event>> getData() {
        return new SignalResponse<List<com.facebook.ads.sdk.serverside.Event>, List<com.facebook.ads.sdk.businessdataapi.Event>>(this.serverSideEventRequest.getData(), this.businessDataEventRequest.getData());
    }

    public void setData(List<Event> data) {
        ArrayList<com.facebook.ads.sdk.businessdataapi.Event> businessDataEvents = new ArrayList<com.facebook.ads.sdk.businessdataapi.Event>();
        ArrayList<com.facebook.ads.sdk.serverside.Event> serverSideEvents = new ArrayList<com.facebook.ads.sdk.serverside.Event>();
        for (Event event : data) {
            businessDataEvents.add(event.getBusinessDataEvent());
            serverSideEvents.add(event.getServerSideEvent());
        }
        this.businessDataEventRequest.setData(businessDataEvents);
        this.serverSideEventRequest.setData(serverSideEvents);
    }

    public EventRequest partnerAgent(String partnerAgent) {
        this.businessDataEventRequest.setPartnerAgent(partnerAgent);
        this.serverSideEventRequest.setPartnerAgent(partnerAgent);
        return this;
    }

    public SignalResponse<String, String> getPartnerAgent() {
        return new SignalResponse<String, String>(this.serverSideEventRequest.getPartnerAgent(), this.businessDataEventRequest.getPartnerAgent());
    }

    public void setPartnerAgent(String partnerAgent) {
        this.businessDataEventRequest.setPartnerAgent(partnerAgent);
        this.serverSideEventRequest.setPartnerAgent(partnerAgent);
    }

    public SignalResponse<String, String> getNamespaceId() {
        return new SignalResponse<String, Object>(this.serverSideEventRequest.getNamespaceId(), null);
    }

    public void setNamespaceId(String namespaceId) {
        this.serverSideEventRequest.setNamespaceId(namespaceId);
    }

    public EventRequest namespaceId(String namespaceId) {
        this.serverSideEventRequest.setNamespaceId(namespaceId);
        return this;
    }

    public SignalResponse<String, String> getUploadId() {
        return new SignalResponse<String, Object>(this.serverSideEventRequest.getUploadId(), null);
    }

    public void setUploadId(String uploadId) {
        this.serverSideEventRequest.setUploadId(uploadId);
    }

    public EventRequest uploadId(String uploadId) {
        this.serverSideEventRequest.setUploadId(uploadId);
        return this;
    }

    public SignalResponse<String, String> getUploadTag() {
        return new SignalResponse<String, Object>(this.serverSideEventRequest.getUploadTag(), null);
    }

    public void setUploadTag(String uploadTag) {
        this.serverSideEventRequest.setUploadTag(uploadTag);
    }

    public EventRequest uploadTag(String uploadTag) {
        this.serverSideEventRequest.setUploadTag(uploadTag);
        return this;
    }

    public SignalResponse<String, String> getUploadSource() {
        return new SignalResponse<String, Object>(this.serverSideEventRequest.getUploadSource(), null);
    }

    public void setUploadSource(String uploadSource) {
        this.serverSideEventRequest.setUploadSource(uploadSource);
    }

    public EventRequest uploadSource(String uploadSource) {
        this.serverSideEventRequest.setUploadSource(uploadSource);
        return this;
    }

    public EventRequest testEventCode(String testEventCode) {
        this.serverSideEventRequest.setTestEventCode(testEventCode);
        return this;
    }

    public SignalResponse<String, String> getTestEventCode() {
        return new SignalResponse<String, Object>(this.serverSideEventRequest.getTestEventCode(), null);
    }

    public void setTestEventCode(String testEventCode) {
        this.serverSideEventRequest.setTestEventCode(testEventCode);
    }

    public SignalResponse<HttpServiceInterface, HttpServiceInterface> getHttpServiceClient() {
        return new SignalResponse<HttpServiceInterface, Object>(this.serverSideEventRequest.getHttpServiceClient(), null);
    }

    public void setHttpServiceClient(HttpServiceInterface httpServiceClient) {
        this.serverSideEventRequest.setHttpServiceClient(httpServiceClient);
    }

    public com.facebook.ads.sdk.businessdataapi.EventRequest getBusinessDataEventRequest() {
        return this.businessDataEventRequest;
    }

    public com.facebook.ads.sdk.serverside.EventRequest getServerSideEventRequest() {
        return this.serverSideEventRequest;
    }

    public SignalResponse<com.facebook.ads.sdk.serverside.EventResponse, EventResponse> execute() throws APIException {
        com.facebook.ads.sdk.serverside.EventResponse serverSideEventResponse = this.serverSideEventRequest.execute();
        EventResponse businessDataEventResponse = this.businessDataEventRequest.execute();
        return new SignalResponse<com.facebook.ads.sdk.serverside.EventResponse, EventResponse>(serverSideEventResponse, businessDataEventResponse);
    }
}

