/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdStudyCell;
import com.facebook.ads.sdk.AdStudyObjective;
import com.facebook.ads.sdk.Business;
import com.facebook.ads.sdk.User;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdStudy
extends APINode {
    @SerializedName(value="business")
    private Business mBusiness = null;
    @SerializedName(value="canceled_time")
    private String mCanceledTime = null;
    @SerializedName(value="cooldown_start_time")
    private String mCooldownStartTime = null;
    @SerializedName(value="created_by")
    private User mCreatedBy = null;
    @SerializedName(value="created_time")
    private String mCreatedTime = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="observation_end_time")
    private String mObservationEndTime = null;
    @SerializedName(value="results_first_available_date")
    private String mResultsFirstAvailableDate = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="type")
    private String mType = null;
    @SerializedName(value="updated_by")
    private User mUpdatedBy = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    AdStudy() {
    }

    public AdStudy(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public AdStudy(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public AdStudy fetch() throws APIException {
        AdStudy newInstance = AdStudy.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static AdStudy fetchById(Long id, APIContext context) throws APIException {
        return AdStudy.fetchById(id.toString(), context);
    }

    public static ListenableFuture<AdStudy> fetchByIdAsync(Long id, APIContext context) throws APIException {
        return AdStudy.fetchByIdAsync(id.toString(), context);
    }

    public static AdStudy fetchById(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().execute();
    }

    public static ListenableFuture<AdStudy> fetchByIdAsync(String id, APIContext context) throws APIException {
        return new APIRequestGet(id, context).requestAllFields().executeAsync();
    }

    public static APINodeList<AdStudy> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<AdStudy>(context, "", "/", "GET", AdStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    public static ListenableFuture<APINodeList<AdStudy>> fetchByIdsAsync(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return new APIRequest<AdStudy>(context, "", "/", "GET", AdStudy.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).executeAsyncBase();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static AdStudy loadJSON(String json, APIContext context, String header) {
        AdStudy adStudy = (AdStudy)AdStudy.getGson().fromJson(json, AdStudy.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adStudy.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adStudy.context = context;
        adStudy.rawValue = json;
        adStudy.header = header;
        return adStudy;
    }

    public static APINodeList<AdStudy> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdStudy> adStudys = new APINodeList<AdStudy>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adStudys;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adStudys.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adStudys.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adStudys.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adStudys.add(AdStudy.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adStudys.add(AdStudy.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adStudys;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adStudys.add(AdStudy.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adStudys;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adStudys.add(AdStudy.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adStudys;
                }
                adStudys.clear();
                adStudys.add(AdStudy.loadJSON(json, context, header));
                return adStudys;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdStudy.getGson().toJson((Object)this);
    }

    public APIRequestGetCells getCells() {
        return new APIRequestGetCells(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGetObjectives getObjectives() {
        return new APIRequestGetObjectives(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestCreateObjective createObjective() {
        return new APIRequestCreateObjective(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public Business getFieldBusiness() {
        if (this.mBusiness != null) {
            this.mBusiness.context = this.getContext();
        }
        return this.mBusiness;
    }

    public String getFieldCanceledTime() {
        return this.mCanceledTime;
    }

    public String getFieldCooldownStartTime() {
        return this.mCooldownStartTime;
    }

    public User getFieldCreatedBy() {
        if (this.mCreatedBy != null) {
            this.mCreatedBy.context = this.getContext();
        }
        return this.mCreatedBy;
    }

    public String getFieldCreatedTime() {
        return this.mCreatedTime;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public String getFieldId() {
        return this.mId;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldObservationEndTime() {
        return this.mObservationEndTime;
    }

    public String getFieldResultsFirstAvailableDate() {
        return this.mResultsFirstAvailableDate;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldType() {
        return this.mType;
    }

    public User getFieldUpdatedBy() {
        if (this.mUpdatedBy != null) {
            this.mUpdatedBy.context = this.getContext();
        }
        return this.mUpdatedBy;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdStudy copyFrom(AdStudy instance) {
        this.mBusiness = instance.mBusiness;
        this.mCanceledTime = instance.mCanceledTime;
        this.mCooldownStartTime = instance.mCooldownStartTime;
        this.mCreatedBy = instance.mCreatedBy;
        this.mCreatedTime = instance.mCreatedTime;
        this.mDescription = instance.mDescription;
        this.mEndTime = instance.mEndTime;
        this.mId = instance.mId;
        this.mName = instance.mName;
        this.mObservationEndTime = instance.mObservationEndTime;
        this.mResultsFirstAvailableDate = instance.mResultsFirstAvailableDate;
        this.mStartTime = instance.mStartTime;
        this.mType = instance.mType;
        this.mUpdatedBy = instance.mUpdatedBy;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdStudy> getParser() {
        return new APIRequest.ResponseParser<AdStudy>(){

            @Override
            public APINodeList<AdStudy> parseResponse(String response, APIContext context, APIRequest<AdStudy> request, String header) throws APIException.MalformedResponseException {
                return AdStudy.parseResponse(response, context, request, header);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_CONTINUOUS_LIFT_CONFIG("CONTINUOUS_LIFT_CONFIG"),
        VALUE_GEO_LIFT("GEO_LIFT"),
        VALUE_LIFT("LIFT"),
        VALUE_PRIVATE_LIFT("PRIVATE_LIFT"),
        VALUE_SPLIT_TEST("SPLIT_TEST");

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[]{"cells", "client_business", "confidence_level", "cooldown_start_time", "description", "end_time", "name", "objectives", "observation_end_time", "start_time", "type", "viewers"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudy>(){

                public AdStudy apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestUpdate.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setCells(List<Object> cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestUpdate setCells(String cells) {
            this.setParam("cells", cells);
            return this;
        }

        public APIRequestUpdate setClientBusiness(String clientBusiness) {
            this.setParam("client_business", clientBusiness);
            return this;
        }

        public APIRequestUpdate setConfidenceLevel(Double confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestUpdate setConfidenceLevel(String confidenceLevel) {
            this.setParam("confidence_level", confidenceLevel);
            return this;
        }

        public APIRequestUpdate setCooldownStartTime(Long cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestUpdate setCooldownStartTime(String cooldownStartTime) {
            this.setParam("cooldown_start_time", cooldownStartTime);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setEndTime(Long endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestUpdate setEndTime(String endTime) {
            this.setParam("end_time", endTime);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setObjectives(List<Object> objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestUpdate setObjectives(String objectives) {
            this.setParam("objectives", objectives);
            return this;
        }

        public APIRequestUpdate setObservationEndTime(Long observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestUpdate setObservationEndTime(String observationEndTime) {
            this.setParam("observation_end_time", observationEndTime);
            return this;
        }

        public APIRequestUpdate setStartTime(Long startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestUpdate setStartTime(String startTime) {
            this.setParam("start_time", startTime);
            return this;
        }

        public APIRequestUpdate setType(EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestUpdate setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestUpdate setViewers(List<Long> viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestUpdate setViewers(String viewers) {
            this.setParam("viewers", viewers);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<AdStudy> {
        AdStudy lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"business", "canceled_time", "cooldown_start_time", "created_by", "created_time", "description", "end_time", "id", "name", "observation_end_time", "results_first_available_date", "start_time", "type", "updated_by", "updated_time"};

        @Override
        public AdStudy getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudy parseResponse(String response, String header) throws APIException {
            return AdStudy.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudy execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudy execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudy> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudy> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudy>(){

                public AdStudy apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGet.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestBusinessField() {
            return this.requestBusinessField(true);
        }

        public APIRequestGet requestBusinessField(boolean value) {
            this.requestField("business", value);
            return this;
        }

        public APIRequestGet requestCanceledTimeField() {
            return this.requestCanceledTimeField(true);
        }

        public APIRequestGet requestCanceledTimeField(boolean value) {
            this.requestField("canceled_time", value);
            return this;
        }

        public APIRequestGet requestCooldownStartTimeField() {
            return this.requestCooldownStartTimeField(true);
        }

        public APIRequestGet requestCooldownStartTimeField(boolean value) {
            this.requestField("cooldown_start_time", value);
            return this;
        }

        public APIRequestGet requestCreatedByField() {
            return this.requestCreatedByField(true);
        }

        public APIRequestGet requestCreatedByField(boolean value) {
            this.requestField("created_by", value);
            return this;
        }

        public APIRequestGet requestCreatedTimeField() {
            return this.requestCreatedTimeField(true);
        }

        public APIRequestGet requestCreatedTimeField(boolean value) {
            this.requestField("created_time", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestObservationEndTimeField() {
            return this.requestObservationEndTimeField(true);
        }

        public APIRequestGet requestObservationEndTimeField(boolean value) {
            this.requestField("observation_end_time", value);
            return this;
        }

        public APIRequestGet requestResultsFirstAvailableDateField() {
            return this.requestResultsFirstAvailableDateField(true);
        }

        public APIRequestGet requestResultsFirstAvailableDateField(boolean value) {
            this.requestField("results_first_available_date", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedByField() {
            return this.requestUpdatedByField(true);
        }

        public APIRequestGet requestUpdatedByField(boolean value) {
            this.requestField("updated_by", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response, String header) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this, header).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINode> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINode> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINode>(){

                public APINode apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestDelete.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateObjective
    extends APIRequest<AdStudyObjective> {
        AdStudyObjective lastResponse = null;
        public static final String[] PARAMS = new String[]{"adspixels", "applications", "customconversions", "is_primary", "name", "offline_conversion_data_sets", "product_catalogs", "product_sets", "type"};
        public static final String[] FIELDS = new String[0];

        @Override
        public AdStudyObjective getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public AdStudyObjective parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header).head();
        }

        @Override
        public AdStudyObjective execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public AdStudyObjective execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<AdStudyObjective> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<AdStudyObjective> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, AdStudyObjective>(){

                public AdStudyObjective apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestCreateObjective.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestCreateObjective(String nodeId, APIContext context) {
            super(context, nodeId, "/objectives", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateObjective setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateObjective setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(List<Object> adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setAdspixels(String adspixels) {
            this.setParam("adspixels", adspixels);
            return this;
        }

        public APIRequestCreateObjective setApplications(List<Object> applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setApplications(String applications) {
            this.setParam("applications", applications);
            return this;
        }

        public APIRequestCreateObjective setCustomconversions(List<Object> customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestCreateObjective setCustomconversions(String customconversions) {
            this.setParam("customconversions", customconversions);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(Boolean isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setIsPrimary(String isPrimary) {
            this.setParam("is_primary", isPrimary);
            return this;
        }

        public APIRequestCreateObjective setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateObjective setOfflineConversionDataSets(List<Object> offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestCreateObjective setOfflineConversionDataSets(String offlineConversionDataSets) {
            this.setParam("offline_conversion_data_sets", offlineConversionDataSets);
            return this;
        }

        public APIRequestCreateObjective setProductCatalogs(List<Object> productCatalogs) {
            this.setParam("product_catalogs", productCatalogs);
            return this;
        }

        public APIRequestCreateObjective setProductCatalogs(String productCatalogs) {
            this.setParam("product_catalogs", productCatalogs);
            return this;
        }

        public APIRequestCreateObjective setProductSets(List<Object> productSets) {
            this.setParam("product_sets", productSets);
            return this;
        }

        public APIRequestCreateObjective setProductSets(String productSets) {
            this.setParam("product_sets", productSets);
            return this;
        }

        public APIRequestCreateObjective setType(AdStudyObjective.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestCreateObjective setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestCreateObjective requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateObjective requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateObjective requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateObjective requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetObjectives
    extends APIRequest<AdStudyObjective> {
        APINodeList<AdStudyObjective> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"id", "is_primary", "last_updated_results", "name", "results", "type"};

        @Override
        public APINodeList<AdStudyObjective> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudyObjective> parseResponse(String response, String header) throws APIException {
            return AdStudyObjective.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudyObjective> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudyObjective> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudyObjective>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudyObjective>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdStudyObjective>>(){

                public APINodeList<AdStudyObjective> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetObjectives.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetObjectives(String nodeId, APIContext context) {
            super(context, nodeId, "/objectives", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetObjectives setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetObjectives setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetObjectives requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetObjectives requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjectives requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetObjectives requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetObjectives requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetObjectives requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetObjectives requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetObjectives requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetObjectives requestIsPrimaryField() {
            return this.requestIsPrimaryField(true);
        }

        public APIRequestGetObjectives requestIsPrimaryField(boolean value) {
            this.requestField("is_primary", value);
            return this;
        }

        public APIRequestGetObjectives requestLastUpdatedResultsField() {
            return this.requestLastUpdatedResultsField(true);
        }

        public APIRequestGetObjectives requestLastUpdatedResultsField(boolean value) {
            this.requestField("last_updated_results", value);
            return this;
        }

        public APIRequestGetObjectives requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetObjectives requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetObjectives requestResultsField() {
            return this.requestResultsField(true);
        }

        public APIRequestGetObjectives requestResultsField(boolean value) {
            this.requestField("results", value);
            return this;
        }

        public APIRequestGetObjectives requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGetObjectives requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetCells
    extends APIRequest<AdStudyCell> {
        APINodeList<AdStudyCell> lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"ad_entities_count", "control_percentage", "id", "name", "treatment_percentage"};

        @Override
        public APINodeList<AdStudyCell> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<AdStudyCell> parseResponse(String response, String header) throws APIException {
            return AdStudyCell.parseResponse(response, this.getContext(), (APIRequest)this, header);
        }

        @Override
        public APINodeList<AdStudyCell> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<AdStudyCell> execute(Map<String, Object> extraParams) throws APIException {
            APIRequest.ResponseWrapper rw = this.executeInternal(extraParams);
            this.lastResponse = this.parseResponse(rw.getBody(), rw.getHeader());
            return this.lastResponse;
        }

        public ListenableFuture<APINodeList<AdStudyCell>> executeAsync() throws APIException {
            return this.executeAsync(new HashMap<String, Object>());
        }

        public ListenableFuture<APINodeList<AdStudyCell>> executeAsync(Map<String, Object> extraParams) throws APIException {
            return Futures.transform(this.executeAsyncInternal(extraParams), (Function)new Function<APIRequest.ResponseWrapper, APINodeList<AdStudyCell>>(){

                public APINodeList<AdStudyCell> apply(APIRequest.ResponseWrapper result) {
                    try {
                        return APIRequestGetCells.this.parseResponse(result.getBody(), result.getHeader());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        public APIRequestGetCells(String nodeId, APIContext context) {
            super(context, nodeId, "/cells", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetCells setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetCells setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetCells requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetCells requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCells requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetCells requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetCells requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetCells requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetCells requestAdEntitiesCountField() {
            return this.requestAdEntitiesCountField(true);
        }

        public APIRequestGetCells requestAdEntitiesCountField(boolean value) {
            this.requestField("ad_entities_count", value);
            return this;
        }

        public APIRequestGetCells requestControlPercentageField() {
            return this.requestControlPercentageField(true);
        }

        public APIRequestGetCells requestControlPercentageField(boolean value) {
            this.requestField("control_percentage", value);
            return this;
        }

        public APIRequestGetCells requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGetCells requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGetCells requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGetCells requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGetCells requestTreatmentPercentageField() {
            return this.requestTreatmentPercentageField(true);
        }

        public APIRequestGetCells requestTreatmentPercentageField(boolean value) {
            this.requestField("treatment_percentage", value);
            return this;
        }
    }
}

