/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributionSpec
extends APINode {
    @SerializedName(value="event_type")
    private String mEventType = null;
    @SerializedName(value="window_days")
    private Long mWindowDays = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AttributionSpec loadJSON(String json, APIContext context, String header) {
        AttributionSpec attributionSpec = (AttributionSpec)AttributionSpec.getGson().fromJson(json, AttributionSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(attributionSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        attributionSpec.context = context;
        attributionSpec.rawValue = json;
        attributionSpec.header = header;
        return attributionSpec;
    }

    public static APINodeList<AttributionSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AttributionSpec> attributionSpecs = new APINodeList<AttributionSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        attributionSpecs.add(AttributionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return attributionSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            attributionSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        attributionSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            attributionSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            attributionSpecs.add(AttributionSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                attributionSpecs.add(AttributionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            attributionSpecs.add(AttributionSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return attributionSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        attributionSpecs.add(AttributionSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return attributionSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        attributionSpecs.add(AttributionSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return attributionSpecs;
                }
                attributionSpecs.clear();
                attributionSpecs.add(AttributionSpec.loadJSON(json, context, header));
                return attributionSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AttributionSpec.getGson().toJson((Object)this);
    }

    public String getFieldEventType() {
        return this.mEventType;
    }

    public AttributionSpec setFieldEventType(String value) {
        this.mEventType = value;
        return this;
    }

    public Long getFieldWindowDays() {
        return this.mWindowDays;
    }

    public AttributionSpec setFieldWindowDays(Long value) {
        this.mWindowDays = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AttributionSpec copyFrom(AttributionSpec instance) {
        this.mEventType = instance.mEventType;
        this.mWindowDays = instance.mWindowDays;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AttributionSpec> getParser() {
        return new APIRequest.ResponseParser<AttributionSpec>(){

            @Override
            public APINodeList<AttributionSpec> parseResponse(String response, APIContext context, APIRequest<AttributionSpec> request, String header) throws APIException.MalformedResponseException {
                return AttributionSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

