/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookalikeSpec
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="is_financial_service")
    private Boolean mIsFinancialService = null;
    @SerializedName(value="origin")
    private List<Object> mOrigin = null;
    @SerializedName(value="origin_event_name")
    private String mOriginEventName = null;
    @SerializedName(value="origin_event_source_name")
    private String mOriginEventSourceName = null;
    @SerializedName(value="origin_event_source_type")
    private String mOriginEventSourceType = null;
    @SerializedName(value="product_set_name")
    private String mProductSetName = null;
    @SerializedName(value="ratio")
    private Double mRatio = null;
    @SerializedName(value="starting_ratio")
    private Double mStartingRatio = null;
    @SerializedName(value="target_countries")
    private List<String> mTargetCountries = null;
    @SerializedName(value="target_country_names")
    private JsonArray mTargetCountryNames = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static LookalikeSpec loadJSON(String json, APIContext context, String header) {
        LookalikeSpec lookalikeSpec = (LookalikeSpec)LookalikeSpec.getGson().fromJson(json, LookalikeSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(lookalikeSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        lookalikeSpec.context = context;
        lookalikeSpec.rawValue = json;
        lookalikeSpec.header = header;
        return lookalikeSpec;
    }

    public static APINodeList<LookalikeSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<LookalikeSpec> lookalikeSpecs = new APINodeList<LookalikeSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return lookalikeSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            lookalikeSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        lookalikeSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            lookalikeSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            lookalikeSpecs.add(LookalikeSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                lookalikeSpecs.add(LookalikeSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            lookalikeSpecs.add(LookalikeSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return lookalikeSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return lookalikeSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return lookalikeSpecs;
                }
                lookalikeSpecs.clear();
                lookalikeSpecs.add(LookalikeSpec.loadJSON(json, context, header));
                return lookalikeSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LookalikeSpec.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public LookalikeSpec setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public Boolean getFieldIsFinancialService() {
        return this.mIsFinancialService;
    }

    public LookalikeSpec setFieldIsFinancialService(Boolean value) {
        this.mIsFinancialService = value;
        return this;
    }

    public List<Object> getFieldOrigin() {
        return this.mOrigin;
    }

    public LookalikeSpec setFieldOrigin(List<Object> value) {
        this.mOrigin = value;
        return this;
    }

    public String getFieldOriginEventName() {
        return this.mOriginEventName;
    }

    public LookalikeSpec setFieldOriginEventName(String value) {
        this.mOriginEventName = value;
        return this;
    }

    public String getFieldOriginEventSourceName() {
        return this.mOriginEventSourceName;
    }

    public LookalikeSpec setFieldOriginEventSourceName(String value) {
        this.mOriginEventSourceName = value;
        return this;
    }

    public String getFieldOriginEventSourceType() {
        return this.mOriginEventSourceType;
    }

    public LookalikeSpec setFieldOriginEventSourceType(String value) {
        this.mOriginEventSourceType = value;
        return this;
    }

    public String getFieldProductSetName() {
        return this.mProductSetName;
    }

    public LookalikeSpec setFieldProductSetName(String value) {
        this.mProductSetName = value;
        return this;
    }

    public Double getFieldRatio() {
        return this.mRatio;
    }

    public LookalikeSpec setFieldRatio(Double value) {
        this.mRatio = value;
        return this;
    }

    public Double getFieldStartingRatio() {
        return this.mStartingRatio;
    }

    public LookalikeSpec setFieldStartingRatio(Double value) {
        this.mStartingRatio = value;
        return this;
    }

    public List<String> getFieldTargetCountries() {
        return this.mTargetCountries;
    }

    public LookalikeSpec setFieldTargetCountries(List<String> value) {
        this.mTargetCountries = value;
        return this;
    }

    public JsonArray getFieldTargetCountryNames() {
        return this.mTargetCountryNames;
    }

    public LookalikeSpec setFieldTargetCountryNames(JsonArray value) {
        this.mTargetCountryNames = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public LookalikeSpec setFieldType(String value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LookalikeSpec copyFrom(LookalikeSpec instance) {
        this.mCountry = instance.mCountry;
        this.mIsFinancialService = instance.mIsFinancialService;
        this.mOrigin = instance.mOrigin;
        this.mOriginEventName = instance.mOriginEventName;
        this.mOriginEventSourceName = instance.mOriginEventSourceName;
        this.mOriginEventSourceType = instance.mOriginEventSourceType;
        this.mProductSetName = instance.mProductSetName;
        this.mRatio = instance.mRatio;
        this.mStartingRatio = instance.mStartingRatio;
        this.mTargetCountries = instance.mTargetCountries;
        this.mTargetCountryNames = instance.mTargetCountryNames;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LookalikeSpec> getParser() {
        return new APIRequest.ResponseParser<LookalikeSpec>(){

            @Override
            public APINodeList<LookalikeSpec> parseResponse(String response, APIContext context, APIRequest<LookalikeSpec> request, String header) throws APIException.MalformedResponseException {
                return LookalikeSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

