/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMEExportConfig
extends APINode {
    @SerializedName(value="can_edit")
    private Boolean mCanEdit = null;
    @SerializedName(value="column_id")
    private String mColumnId = null;
    @SerializedName(value="display_name")
    private String mDisplayName = null;
    @SerializedName(value="format")
    private String mFormat = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static FAMEExportConfig loadJSON(String json, APIContext context, String header) {
        FAMEExportConfig fameExportConfig = (FAMEExportConfig)FAMEExportConfig.getGson().fromJson(json, FAMEExportConfig.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(fameExportConfig.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        fameExportConfig.context = context;
        fameExportConfig.rawValue = json;
        fameExportConfig.header = header;
        return fameExportConfig;
    }

    public static APINodeList<FAMEExportConfig> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<FAMEExportConfig> fameExportConfigs = new APINodeList<FAMEExportConfig>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        fameExportConfigs.add(FAMEExportConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return fameExportConfigs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            fameExportConfigs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        fameExportConfigs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            fameExportConfigs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            fameExportConfigs.add(FAMEExportConfig.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                fameExportConfigs.add(FAMEExportConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            fameExportConfigs.add(FAMEExportConfig.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return fameExportConfigs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        fameExportConfigs.add(FAMEExportConfig.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return fameExportConfigs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        fameExportConfigs.add(FAMEExportConfig.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return fameExportConfigs;
                }
                fameExportConfigs.clear();
                fameExportConfigs.add(FAMEExportConfig.loadJSON(json, context, header));
                return fameExportConfigs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return FAMEExportConfig.getGson().toJson((Object)this);
    }

    public Boolean getFieldCanEdit() {
        return this.mCanEdit;
    }

    public FAMEExportConfig setFieldCanEdit(Boolean value) {
        this.mCanEdit = value;
        return this;
    }

    public String getFieldColumnId() {
        return this.mColumnId;
    }

    public FAMEExportConfig setFieldColumnId(String value) {
        this.mColumnId = value;
        return this;
    }

    public String getFieldDisplayName() {
        return this.mDisplayName;
    }

    public FAMEExportConfig setFieldDisplayName(String value) {
        this.mDisplayName = value;
        return this;
    }

    public String getFieldFormat() {
        return this.mFormat;
    }

    public FAMEExportConfig setFieldFormat(String value) {
        this.mFormat = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public FAMEExportConfig copyFrom(FAMEExportConfig instance) {
        this.mCanEdit = instance.mCanEdit;
        this.mColumnId = instance.mColumnId;
        this.mDisplayName = instance.mDisplayName;
        this.mFormat = instance.mFormat;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<FAMEExportConfig> getParser() {
        return new APIRequest.ResponseParser<FAMEExportConfig>(){

            @Override
            public APINodeList<FAMEExportConfig> parseResponse(String response, APIContext context, APIRequest<FAMEExportConfig> request, String header) throws APIException.MalformedResponseException {
                return FAMEExportConfig.parseResponse(response, context, request, header);
            }
        };
    }
}

