/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdEntityTargetSpend
extends APINode {
    @SerializedName(value="amount")
    private String mAmount = null;
    @SerializedName(value="has_error")
    private Boolean mHasError = null;
    @SerializedName(value="is_accurate")
    private Boolean mIsAccurate = null;
    @SerializedName(value="is_prorated")
    private Boolean mIsProrated = null;
    @SerializedName(value="is_updating")
    private Boolean mIsUpdating = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdEntityTargetSpend loadJSON(String json, APIContext context, String header) {
        AdEntityTargetSpend adEntityTargetSpend = (AdEntityTargetSpend)AdEntityTargetSpend.getGson().fromJson(json, AdEntityTargetSpend.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adEntityTargetSpend.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adEntityTargetSpend.context = context;
        adEntityTargetSpend.rawValue = json;
        adEntityTargetSpend.header = header;
        return adEntityTargetSpend;
    }

    public static APINodeList<AdEntityTargetSpend> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdEntityTargetSpend> adEntityTargetSpends = new APINodeList<AdEntityTargetSpend>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adEntityTargetSpends;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adEntityTargetSpends.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adEntityTargetSpends.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adEntityTargetSpends.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adEntityTargetSpends;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adEntityTargetSpends;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adEntityTargetSpends;
                }
                adEntityTargetSpends.clear();
                adEntityTargetSpends.add(AdEntityTargetSpend.loadJSON(json, context, header));
                return adEntityTargetSpends;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdEntityTargetSpend.getGson().toJson((Object)this);
    }

    public String getFieldAmount() {
        return this.mAmount;
    }

    public AdEntityTargetSpend setFieldAmount(String value) {
        this.mAmount = value;
        return this;
    }

    public Boolean getFieldHasError() {
        return this.mHasError;
    }

    public AdEntityTargetSpend setFieldHasError(Boolean value) {
        this.mHasError = value;
        return this;
    }

    public Boolean getFieldIsAccurate() {
        return this.mIsAccurate;
    }

    public AdEntityTargetSpend setFieldIsAccurate(Boolean value) {
        this.mIsAccurate = value;
        return this;
    }

    public Boolean getFieldIsProrated() {
        return this.mIsProrated;
    }

    public AdEntityTargetSpend setFieldIsProrated(Boolean value) {
        this.mIsProrated = value;
        return this;
    }

    public Boolean getFieldIsUpdating() {
        return this.mIsUpdating;
    }

    public AdEntityTargetSpend setFieldIsUpdating(Boolean value) {
        this.mIsUpdating = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdEntityTargetSpend copyFrom(AdEntityTargetSpend instance) {
        this.mAmount = instance.mAmount;
        this.mHasError = instance.mHasError;
        this.mIsAccurate = instance.mIsAccurate;
        this.mIsProrated = instance.mIsProrated;
        this.mIsUpdating = instance.mIsUpdating;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdEntityTargetSpend> getParser() {
        return new APIRequest.ResponseParser<AdEntityTargetSpend>(){

            @Override
            public APINodeList<AdEntityTargetSpend> parseResponse(String response, APIContext context, APIRequest<AdEntityTargetSpend> request, String header) throws APIException.MalformedResponseException {
                return AdEntityTargetSpend.parseResponse(response, context, request, header);
            }
        };
    }
}

