/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeTemplateURLSpec
extends APINode {
    @SerializedName(value="android")
    private Object mAndroid = null;
    @SerializedName(value="config")
    private Object mConfig = null;
    @SerializedName(value="ios")
    private Object mIos = null;
    @SerializedName(value="ipad")
    private Object mIpad = null;
    @SerializedName(value="iphone")
    private Object mIphone = null;
    @SerializedName(value="web")
    private Object mWeb = null;
    @SerializedName(value="windows_phone")
    private Object mWindowsPhone = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeTemplateURLSpec loadJSON(String json, APIContext context, String header) {
        AdCreativeTemplateURLSpec adCreativeTemplateURLSpec = (AdCreativeTemplateURLSpec)AdCreativeTemplateURLSpec.getGson().fromJson(json, AdCreativeTemplateURLSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeTemplateURLSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeTemplateURLSpec.context = context;
        adCreativeTemplateURLSpec.rawValue = json;
        adCreativeTemplateURLSpec.header = header;
        return adCreativeTemplateURLSpec;
    }

    public static APINodeList<AdCreativeTemplateURLSpec> parseResponse(String json, APIContext context, APIRequest request, String header) throws APIException.MalformedResponseException {
        Exception exception;
        block20: {
            APINodeList<AdCreativeTemplateURLSpec> adCreativeTemplateURLSpecs = new APINodeList<AdCreativeTemplateURLSpec>(request, json, header);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                    }
                    return adCreativeTemplateURLSpecs;
                }
                if (!result.isJsonObject()) break block20;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject();
                        if (paging.has("cursors")) {
                            JsonObject cursors = paging.get("cursors").getAsJsonObject();
                            String before = cursors.has("before") ? cursors.get("before").getAsString() : null;
                            String after = cursors.has("after") ? cursors.get("after").getAsString() : null;
                            adCreativeTemplateURLSpecs.setCursors(before, after);
                        }
                        String[] previous = paging.has("previous") ? paging.get("previous").getAsString() : null;
                        String next = paging.has("next") ? paging.get("next").getAsString() : null;
                        adCreativeTemplateURLSpecs.setPaging((String)previous, next);
                        if (context.hasAppSecret()) {
                            adCreativeTemplateURLSpecs.setAppSecret(context.getAppSecretProof());
                        }
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context, header));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(obj.toString(), context, header));
                        }
                    }
                    return adCreativeTemplateURLSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context, header));
                    }
                    return adCreativeTemplateURLSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(value.toString(), context, header));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeTemplateURLSpecs;
                }
                adCreativeTemplateURLSpecs.clear();
                adCreativeTemplateURLSpecs.add(AdCreativeTemplateURLSpec.loadJSON(json, context, header));
                return adCreativeTemplateURLSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeTemplateURLSpec.getGson().toJson((Object)this);
    }

    public Object getFieldAndroid() {
        return this.mAndroid;
    }

    public AdCreativeTemplateURLSpec setFieldAndroid(Object value) {
        this.mAndroid = value;
        return this;
    }

    public Object getFieldConfig() {
        return this.mConfig;
    }

    public AdCreativeTemplateURLSpec setFieldConfig(Object value) {
        this.mConfig = value;
        return this;
    }

    public Object getFieldIos() {
        return this.mIos;
    }

    public AdCreativeTemplateURLSpec setFieldIos(Object value) {
        this.mIos = value;
        return this;
    }

    public Object getFieldIpad() {
        return this.mIpad;
    }

    public AdCreativeTemplateURLSpec setFieldIpad(Object value) {
        this.mIpad = value;
        return this;
    }

    public Object getFieldIphone() {
        return this.mIphone;
    }

    public AdCreativeTemplateURLSpec setFieldIphone(Object value) {
        this.mIphone = value;
        return this;
    }

    public Object getFieldWeb() {
        return this.mWeb;
    }

    public AdCreativeTemplateURLSpec setFieldWeb(Object value) {
        this.mWeb = value;
        return this;
    }

    public Object getFieldWindowsPhone() {
        return this.mWindowsPhone;
    }

    public AdCreativeTemplateURLSpec setFieldWindowsPhone(Object value) {
        this.mWindowsPhone = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeTemplateURLSpec copyFrom(AdCreativeTemplateURLSpec instance) {
        this.mAndroid = instance.mAndroid;
        this.mConfig = instance.mConfig;
        this.mIos = instance.mIos;
        this.mIpad = instance.mIpad;
        this.mIphone = instance.mIphone;
        this.mWeb = instance.mWeb;
        this.mWindowsPhone = instance.mWindowsPhone;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeTemplateURLSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeTemplateURLSpec>(){

            @Override
            public APINodeList<AdCreativeTemplateURLSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeTemplateURLSpec> request, String header) throws APIException.MalformedResponseException {
                return AdCreativeTemplateURLSpec.parseResponse(response, context, request, header);
            }
        };
    }
}

